/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.config;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import net.optifine.Config;
import net.optifine.ConnectedProperties;
import net.optifine.config.BiomeId;
import net.optifine.config.INameGetter;
import net.optifine.config.MatchBlock;
import net.optifine.config.MatchProfession;
import net.optifine.config.NbtTagValue;
import net.optifine.config.RangeInt;
import net.optifine.config.RangeListInt;
import net.optifine.config.Weather;
import net.optifine.util.BiomeUtils;
import net.optifine.util.BlockUtils;
import net.optifine.util.EntityTypeUtils;
import net.optifine.util.ItemUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ConnectedParser {
    private String context = null;
    public static final MatchProfession[] PROFESSIONS_INVALID = new MatchProfession[0];
    public static final bzq[] DYE_COLORS_INVALID = new bzq[0];
    private static Map<abb, BiomeId> MAP_BIOMES_COMPACT = null;
    private static final INameGetter<Enum> NAME_GETTER_ENUM = new /* Unavailable Anonymous Inner Class!! */;
    private static final INameGetter<bzq> NAME_GETTER_DYE_COLOR = new /* Unavailable Anonymous Inner Class!! */;
    private static final Pattern PATTERN_RANGE_SEPARATOR = Pattern.compile("(\\d|\\))-(\\d|\\()");

    public ConnectedParser(String context) {
        this.context = context;
    }

    public String parseName(String path) {
        int pos2;
        String str = path;
        int pos = str.lastIndexOf(47);
        if (pos >= 0) {
            str = str.substring(pos + 1);
        }
        if ((pos2 = str.lastIndexOf(46)) >= 0) {
            str = str.substring(0, pos2);
        }
        return str;
    }

    public String parseBasePath(String path) {
        int pos = path.lastIndexOf(47);
        if (pos < 0) {
            return "";
        }
        return path.substring(0, pos);
    }

    public MatchBlock[] parseMatchBlocks(String propMatchBlocks) {
        if (propMatchBlocks == null) {
            return null;
        }
        ArrayList<MatchBlock> list = new ArrayList<MatchBlock>();
        String[] blockStrs = Config.tokenize((String)propMatchBlocks, (String)" ");
        for (int i2 = 0; i2 < blockStrs.length; ++i2) {
            String blockStr = blockStrs[i2];
            MatchBlock[] mbs = this.parseMatchBlock(blockStr);
            if (mbs == null) continue;
            list.addAll(Arrays.asList(mbs));
        }
        MatchBlock[] mbs = list.toArray(new MatchBlock[list.size()]);
        return mbs;
    }

    public cvo parseBlockState(String str, cvo def) {
        MatchBlock[] mbs = this.parseMatchBlock(str);
        if (mbs == null) {
            return def;
        }
        if (mbs.length != 1) {
            return def;
        }
        MatchBlock mb = mbs[0];
        int blockId = mb.getBlockId();
        cjt block = (cjt)hm.V.a(blockId);
        return block.m();
    }

    public MatchBlock[] parseMatchBlock(String blockStr) {
        if (blockStr == null) {
            return null;
        }
        if ((blockStr = blockStr.trim()).length() <= 0) {
            return null;
        }
        String[] parts = Config.tokenize((String)blockStr, (String)":");
        String domain = "minecraft";
        int blockIndex = 0;
        if (parts.length > 1 && this.isFullBlockName(parts)) {
            domain = parts[0];
            blockIndex = 1;
        } else {
            domain = "minecraft";
            blockIndex = 0;
        }
        String blockPart = parts[blockIndex];
        String[] params = Arrays.copyOfRange(parts, blockIndex + 1, parts.length);
        cjt[] blocks = this.parseBlockPart(domain, blockPart);
        if (blocks == null) {
            return null;
        }
        MatchBlock[] datas = new MatchBlock[blocks.length];
        for (int i2 = 0; i2 < blocks.length; ++i2) {
            MatchBlock bd;
            cjt block = blocks[i2];
            int blockId = hm.V.a((Object)block);
            int[] metadatas = null;
            if (params.length > 0 && (metadatas = this.parseBlockMetadatas(block, params)) == null) {
                return null;
            }
            datas[i2] = bd = new MatchBlock(blockId, metadatas);
        }
        return datas;
    }

    public boolean isFullBlockName(String[] parts) {
        if (parts.length <= 1) {
            return false;
        }
        String part1 = parts[1];
        if (part1.length() < 1) {
            return false;
        }
        return !part1.contains("=");
    }

    public boolean startsWithDigit(String str) {
        if (str == null) {
            return false;
        }
        if (str.length() < 1) {
            return false;
        }
        char ch = str.charAt(0);
        return Character.isDigit(ch);
    }

    public cjt[] parseBlockPart(String domain, String blockPart) {
        String fullName = domain + ":" + blockPart;
        abb fullLoc = new abb(fullName);
        cjt block = BlockUtils.getBlock((abb)fullLoc);
        if (block == null) {
            this.warn("Block not found for name: " + fullName);
            return null;
        }
        cjt[] blocks = new cjt[]{block};
        return blocks;
    }

    public int[] parseBlockMetadatas(cjt block, String[] params) {
        if (params.length <= 0) {
            return null;
        }
        cvo stateDefault = block.m();
        Collection properties = stateDefault.v();
        HashMap mapPropValues = new HashMap();
        for (int i2 = 0; i2 < params.length; ++i2) {
            String param = params[i2];
            if (param.length() <= 0) continue;
            String[] parts = Config.tokenize((String)param, (String)"=");
            if (parts.length != 2) {
                this.warn("Invalid block property: " + param);
                return null;
            }
            String key = parts[0];
            String valStr = parts[1];
            cwr prop = ConnectedProperties.getProperty((String)key, (Collection)properties);
            if (prop == null) {
                this.warn("Property not found: " + key + ", block: " + block);
                return null;
            }
            ArrayList<Comparable> list = (ArrayList<Comparable>)mapPropValues.get(key);
            if (list == null) {
                list = new ArrayList<Comparable>();
                mapPropValues.put(prop, list);
            }
            String[] vals = Config.tokenize((String)valStr, (String)",");
            for (int v2 = 0; v2 < vals.length; ++v2) {
                String val = vals[v2];
                Comparable propVal = ConnectedParser.parsePropertyValue((cwr)prop, (String)val);
                if (propVal == null) {
                    this.warn("Property value not found: " + val + ", property: " + key + ", block: " + block);
                    return null;
                }
                list.add(propVal);
            }
        }
        if (mapPropValues.isEmpty()) {
            return null;
        }
        ArrayList<Integer> listMetadatas = new ArrayList<Integer>();
        int metaCount = BlockUtils.getMetadataCount((cjt)block);
        for (int md = 0; md < metaCount; ++md) {
            try {
                cvo bs = BlockUtils.getBlockState((cjt)block, (int)md);
                if (!this.matchState(bs, mapPropValues)) continue;
                listMetadatas.add(md);
                continue;
            }
            catch (IllegalArgumentException bs) {
                // empty catch block
            }
        }
        if (listMetadatas.size() == metaCount) {
            return null;
        }
        int[] metadatas = new int[listMetadatas.size()];
        for (int i3 = 0; i3 < metadatas.length; ++i3) {
            metadatas[i3] = (Integer)listMetadatas.get(i3);
        }
        return metadatas;
    }

    public static Comparable parsePropertyValue(cwr prop, String valStr) {
        Class valueClass = prop.g();
        Comparable valueObj = ConnectedParser.parseValue((String)valStr, (Class)valueClass);
        if (valueObj == null) {
            Collection propertyValues = prop.a();
            valueObj = ConnectedParser.getPropertyValue((String)valStr, (Collection)propertyValues);
        }
        return valueObj;
    }

    public static Comparable getPropertyValue(String value, Collection propertyValues) {
        for (Comparable obj : propertyValues) {
            if (!ConnectedParser.getValueName((Comparable)obj).equals(value)) continue;
            return obj;
        }
        return null;
    }

    private static Object getValueName(Comparable obj) {
        if (obj instanceof amw) {
            amw iss = (amw)obj;
            return iss.c();
        }
        return obj.toString();
    }

    public static Comparable parseValue(String str, Class cls) {
        if (cls == String.class) {
            return str;
        }
        try {
            if (cls == Boolean.class) {
                return Boolean.valueOf(str);
            }
            if (cls == Float.class) {
                return Float.valueOf(str);
            }
            if (cls == Double.class) {
                return Double.valueOf(str);
            }
            if (cls == Integer.class) {
                return Integer.valueOf(str);
            }
            if (cls == Long.class) {
                return Long.valueOf(str);
            }
            return null;
        }
        catch (Exception e) {
            Config.warn((String)(e.getClass().getName() + ": " + e.getMessage()));
            return null;
        }
    }

    public boolean matchState(cvo bs, Map<cwr, List<Comparable>> mapPropValues) {
        Set<cwr> keys = mapPropValues.keySet();
        for (cwr prop : keys) {
            List<Comparable> vals = mapPropValues.get(prop);
            Comparable bsVal = bs.c(prop);
            if (bsVal == null) {
                return false;
            }
            if (vals.contains(bsVal)) continue;
            return false;
        }
        return true;
    }

    public BiomeId[] parseBiomes(String str) {
        if (str == null) {
            return null;
        }
        str = str.trim();
        boolean negative = false;
        if (str.startsWith("!")) {
            negative = true;
            str = str.substring(1);
        }
        String[] biomeNames = Config.tokenize((String)str, (String)" ");
        List<Object> list = new ArrayList<BiomeId>();
        for (int i2 = 0; i2 < biomeNames.length; ++i2) {
            String biomeName = biomeNames[i2];
            BiomeId biome = this.getBiomeId(biomeName);
            if (biome == null) {
                this.warn("Biome not found: " + biomeName);
                continue;
            }
            list.add(biome);
        }
        if (negative) {
            HashSet allBiomes = new HashSet(BiomeUtils.getLocations());
            for (BiomeId bi : list) {
                allBiomes.remove(bi.getResourceLocation());
            }
            list = BiomeUtils.getBiomeIds(allBiomes);
        }
        BiomeId[] biomeArr = list.toArray(new BiomeId[list.size()]);
        return biomeArr;
    }

    public BiomeId getBiomeId(String biomeName) {
        abb biomeLoc = new abb(biomeName = biomeName.toLowerCase());
        BiomeId biome = BiomeUtils.getBiomeId((abb)biomeLoc);
        if (biome != null) {
            return biome;
        }
        String biomeNameCompact = biomeName.replace(" ", "").replace("_", "");
        abb biomeLocCompact = new abb(biomeNameCompact);
        if (MAP_BIOMES_COMPACT == null) {
            MAP_BIOMES_COMPACT = new HashMap();
            Set biomeIds = BiomeUtils.getLocations();
            for (abb loc : biomeIds) {
                BiomeId biomeCompact = BiomeUtils.getBiomeId((abb)loc);
                if (biomeCompact == null) continue;
                String pathCompact = loc.a().replace(" ", "").replace("_", "").toLowerCase();
                abb locCompact = new abb(loc.b(), pathCompact);
                MAP_BIOMES_COMPACT.put(locCompact, biomeCompact);
            }
        }
        if ((biome = (BiomeId)MAP_BIOMES_COMPACT.get(biomeLocCompact)) != null) {
            return biome;
        }
        return null;
    }

    public int parseInt(String str, int defVal) {
        if (str == null) {
            return defVal;
        }
        int num = Config.parseInt((String)(str = str.trim()), (int)-1);
        if (num < 0) {
            this.warn("Invalid number: " + str);
            return defVal;
        }
        return num;
    }

    public int parseIntNeg(String str, int defVal) {
        if (str == null) {
            return defVal;
        }
        int num = Config.parseInt((String)(str = str.trim()), (int)Integer.MIN_VALUE);
        if (num == Integer.MIN_VALUE) {
            this.warn("Invalid number: " + str);
            return defVal;
        }
        return num;
    }

    public int[] parseIntList(String str) {
        if (str == null) {
            return null;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        String[] intStrs = Config.tokenize((String)str, (String)" ,");
        for (int i2 = 0; i2 < intStrs.length; ++i2) {
            String intStr = intStrs[i2];
            if (intStr.contains("-")) {
                String[] subStrs = Config.tokenize((String)intStr, (String)"-");
                if (subStrs.length != 2) {
                    this.warn("Invalid interval: " + intStr + ", when parsing: " + str);
                    continue;
                }
                int min = Config.parseInt((String)subStrs[0], (int)-1);
                int max = Config.parseInt((String)subStrs[1], (int)-1);
                if (min < 0 || max < 0 || min > max) {
                    this.warn("Invalid interval: " + intStr + ", when parsing: " + str);
                    continue;
                }
                for (int n = min; n <= max; ++n) {
                    list.add(n);
                }
                continue;
            }
            int val = Config.parseInt((String)intStr, (int)-1);
            if (val < 0) {
                this.warn("Invalid number: " + intStr + ", when parsing: " + str);
                continue;
            }
            list.add(val);
        }
        int[] ints = new int[list.size()];
        for (int i3 = 0; i3 < ints.length; ++i3) {
            ints[i3] = (Integer)list.get(i3);
        }
        return ints;
    }

    public boolean[] parseFaces(String str, boolean[] defVal) {
        if (str == null) {
            return defVal;
        }
        EnumSet<gy> setFaces = EnumSet.allOf(gy.class);
        String[] faceStrs = Config.tokenize((String)str, (String)" ,");
        for (int i2 = 0; i2 < faceStrs.length; ++i2) {
            String faceStr = faceStrs[i2];
            if (faceStr.equals("sides")) {
                setFaces.add(gy.c);
                setFaces.add(gy.d);
                setFaces.add(gy.e);
                setFaces.add(gy.f);
                continue;
            }
            if (faceStr.equals("all")) {
                setFaces.addAll(Arrays.asList(gy.p));
                continue;
            }
            gy face = this.parseFace(faceStr);
            if (face == null) continue;
            setFaces.add(face);
        }
        boolean[] faces = new boolean[gy.p.length];
        for (int i3 = 0; i3 < faces.length; ++i3) {
            faces[i3] = setFaces.contains(gy.p[i3]);
        }
        return faces;
    }

    public gy parseFace(String str) {
        if ((str = str.toLowerCase()).equals("bottom") || str.equals("down")) {
            return gy.a;
        }
        if (str.equals("top") || str.equals("up")) {
            return gy.b;
        }
        if (str.equals("north")) {
            return gy.c;
        }
        if (str.equals("south")) {
            return gy.d;
        }
        if (str.equals("east")) {
            return gy.f;
        }
        if (str.equals("west")) {
            return gy.e;
        }
        Config.warn((String)("Unknown face: " + str));
        return null;
    }

    public void dbg(String str) {
        Config.dbg((String)(this.context + ": " + str));
    }

    public void warn(String str) {
        Config.warn((String)(this.context + ": " + str));
    }

    public RangeListInt parseRangeListInt(String str) {
        if (str == null) {
            return null;
        }
        RangeListInt list = new RangeListInt();
        String[] parts = Config.tokenize((String)str, (String)" ,");
        for (int i2 = 0; i2 < parts.length; ++i2) {
            String part = parts[i2];
            RangeInt ri = this.parseRangeInt(part);
            if (ri == null) {
                return null;
            }
            list.addRange(ri);
        }
        return list;
    }

    public RangeListInt parseRangeListIntNeg(String str) {
        if (str == null) {
            return null;
        }
        RangeListInt list = new RangeListInt();
        String[] parts = Config.tokenize((String)str, (String)" ,");
        for (int i2 = 0; i2 < parts.length; ++i2) {
            String part = parts[i2];
            RangeInt ri = this.parseRangeIntNeg(part);
            if (ri == null) {
                return null;
            }
            list.addRange(ri);
        }
        return list;
    }

    private RangeInt parseRangeInt(String str) {
        if (str == null) {
            return null;
        }
        if (str.indexOf(45) >= 0) {
            String[] parts = Config.tokenize((String)str, (String)"-");
            if (parts.length != 2) {
                this.warn("Invalid range: " + str);
                return null;
            }
            int min = Config.parseInt((String)parts[0], (int)-1);
            int max = Config.parseInt((String)parts[1], (int)-1);
            if (min < 0 || max < 0) {
                this.warn("Invalid range: " + str);
                return null;
            }
            return new RangeInt(min, max);
        }
        int val = Config.parseInt((String)str, (int)-1);
        if (val < 0) {
            this.warn("Invalid integer: " + str);
            return null;
        }
        return new RangeInt(val, val);
    }

    private RangeInt parseRangeIntNeg(String str) {
        if (str == null) {
            return null;
        }
        if (str.indexOf("=") >= 0) {
            this.warn("Invalid range: " + str);
            return null;
        }
        String strEq = PATTERN_RANGE_SEPARATOR.matcher(str).replaceAll("$1=$2");
        if (strEq.indexOf(61) >= 0) {
            String[] parts = Config.tokenize((String)strEq, (String)"=");
            if (parts.length != 2) {
                this.warn("Invalid range: " + str);
                return null;
            }
            int min = Config.parseInt((String)ConnectedParser.stripBrackets((String)parts[0]), (int)Integer.MIN_VALUE);
            int max = Config.parseInt((String)ConnectedParser.stripBrackets((String)parts[1]), (int)Integer.MIN_VALUE);
            if (min == Integer.MIN_VALUE || max == Integer.MIN_VALUE) {
                this.warn("Invalid range: " + str);
                return null;
            }
            return new RangeInt(min, max);
        }
        int val = Config.parseInt((String)ConnectedParser.stripBrackets((String)str), (int)Integer.MIN_VALUE);
        if (val == Integer.MIN_VALUE) {
            this.warn("Invalid integer: " + str);
            return null;
        }
        return new RangeInt(val, val);
    }

    private static String stripBrackets(String str) {
        if (str.startsWith("(") && str.endsWith(")")) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    public boolean parseBoolean(String str, boolean defVal) {
        if (str == null) {
            return defVal;
        }
        String strLower = str.toLowerCase().trim();
        if (strLower.equals("true")) {
            return true;
        }
        if (strLower.equals("false")) {
            return false;
        }
        this.warn("Invalid boolean: " + str);
        return defVal;
    }

    public Boolean parseBooleanObject(String str) {
        if (str == null) {
            return null;
        }
        String strLower = str.toLowerCase().trim();
        if (strLower.equals("true")) {
            return Boolean.TRUE;
        }
        if (strLower.equals("false")) {
            return Boolean.FALSE;
        }
        this.warn("Invalid boolean: " + str);
        return null;
    }

    public static int parseColor(String str, int defVal) {
        if (str == null) {
            return defVal;
        }
        str = str.trim();
        try {
            int val = Integer.parseInt(str, 16) & 0xFFFFFF;
            return val;
        }
        catch (NumberFormatException e) {
            return defVal;
        }
    }

    public static int parseColor4(String str, int defVal) {
        if (str == null) {
            return defVal;
        }
        str = str.trim();
        try {
            int val = (int)(Long.parseLong(str, 16) & 0xFFFFFFFFFFFFFFFFL);
            return val;
        }
        catch (NumberFormatException e) {
            return defVal;
        }
    }

    public faa parseBlockRenderLayer(String str, faa def) {
        if (str == null) {
            return def;
        }
        str = str.toLowerCase().trim();
        faa[] layers = faa.CHUNK_RENDER_TYPES;
        for (int i2 = 0; i2 < layers.length; ++i2) {
            faa layer = layers[i2];
            if (!str.equals(layer.getName().toLowerCase())) continue;
            return layer;
        }
        return def;
    }

    public <T> T parseObject(String str, T[] objs, INameGetter nameGetter, String property) {
        if (str == null) {
            return null;
        }
        String strLower = str.toLowerCase().trim();
        for (int i2 = 0; i2 < objs.length; ++i2) {
            T obj = objs[i2];
            String name = nameGetter.getName(obj);
            if (name == null || !name.toLowerCase().equals(strLower)) continue;
            return obj;
        }
        this.warn("Invalid " + property + ": " + str);
        return null;
    }

    public <T> T[] parseObjects(String str, T[] objs, INameGetter nameGetter, String property, T[] errValue) {
        if (str == null) {
            return null;
        }
        str = str.toLowerCase().trim();
        String[] parts = Config.tokenize((String)str, (String)" ");
        Object[] arr = (Object[])Array.newInstance(objs.getClass().getComponentType(), parts.length);
        for (int i2 = 0; i2 < parts.length; ++i2) {
            String part = parts[i2];
            Object obj = this.parseObject(part, (Object[])objs, nameGetter, property);
            if (obj == null) {
                return errValue;
            }
            arr[i2] = obj;
        }
        return arr;
    }

    public Enum parseEnum(String str, Enum[] enums, String property) {
        return (Enum)this.parseObject(str, (Object[])enums, NAME_GETTER_ENUM, property);
    }

    public Enum[] parseEnums(String str, Enum[] enums, String property, Enum[] errValue) {
        return (Enum[])this.parseObjects(str, (Object[])enums, NAME_GETTER_ENUM, property, (Object[])errValue);
    }

    public bzq[] parseDyeColors(String str, String property, bzq[] errValue) {
        return (bzq[])this.parseObjects(str, (Object[])bzq.values(), NAME_GETTER_DYE_COLOR, property, (Object[])errValue);
    }

    public Weather[] parseWeather(String str, String property, Weather[] errValue) {
        return (Weather[])this.parseObjects(str, (Object[])Weather.values(), NAME_GETTER_ENUM, property, (Object[])errValue);
    }

    public NbtTagValue[] parseNbtTagValues(Properties props, String prefix) {
        ArrayList<NbtTagValue> listNbts = new ArrayList<NbtTagValue>();
        Set<Object> keySet = props.keySet();
        for (String string : keySet) {
            if (!string.startsWith(prefix)) continue;
            String val = (String)props.get(string);
            String id = string.substring(prefix.length());
            NbtTagValue nbt = new NbtTagValue(id, val);
            listNbts.add(nbt);
        }
        if (listNbts.isEmpty()) {
            return null;
        }
        NbtTagValue[] nbts = listNbts.toArray(new NbtTagValue[listNbts.size()]);
        return nbts;
    }

    public NbtTagValue parseNbtTagValue(String path, String value) {
        if (path == null || value == null) {
            return null;
        }
        return new NbtTagValue(path, value);
    }

    public MatchProfession[] parseProfessions(String profStr) {
        if (profStr == null) {
            return null;
        }
        ArrayList<MatchProfession> list = new ArrayList<MatchProfession>();
        String[] tokens = Config.tokenize((String)profStr, (String)" ");
        for (int i2 = 0; i2 < tokens.length; ++i2) {
            String str = tokens[i2];
            MatchProfession prof = this.parseProfession(str);
            if (prof == null) {
                this.warn("Invalid profession: " + str);
                return PROFESSIONS_INVALID;
            }
            list.add(prof);
        }
        if (list.isEmpty()) {
            return null;
        }
        MatchProfession[] arr = list.toArray(new MatchProfession[list.size()]);
        return arr;
    }

    private MatchProfession parseProfession(String str) {
        bts prof;
        String strProf = str;
        String strLevels = null;
        int pos = str.lastIndexOf(58);
        if (pos >= 0) {
            String part1 = str.substring(0, pos);
            String part2 = str.substring(pos + 1);
            if (part2.isEmpty() || part2.matches("[0-9].*")) {
                strProf = part1;
                strLevels = part2;
            }
        }
        if ((prof = this.parseVillagerProfession(strProf)) == null) {
            return null;
        }
        int[] levels = this.parseIntList(strLevels);
        MatchProfession mp = new MatchProfession(prof, levels);
        return mp;
    }

    private bts parseVillagerProfession(String str) {
        if (str == null) {
            return null;
        }
        gx registry = hm.ap;
        abb loc = new abb(str = str.toLowerCase());
        if (!registry.c(loc)) {
            return null;
        }
        return (bts)registry.a(loc);
    }

    public int[] parseItems(String str) {
        str = str.trim();
        TreeSet<Integer> setIds = new TreeSet<Integer>();
        String[] tokens = Config.tokenize((String)str, (String)" ");
        for (int i2 = 0; i2 < tokens.length; ++i2) {
            String token = tokens[i2];
            abb loc = new abb(token);
            cat item = ItemUtils.getItem((abb)loc);
            if (item == null) {
                this.warn("Item not found: " + token);
                continue;
            }
            int id = ItemUtils.getId((cat)item);
            if (id < 0) {
                this.warn("Item has no ID: " + item + ", name: " + token);
                continue;
            }
            setIds.add(new Integer(id));
        }
        Integer[] integers = setIds.toArray(new Integer[setIds.size()]);
        int[] ints = Config.toPrimitive((Integer[])integers);
        return ints;
    }

    public int[] parseEntities(String str) {
        str = str.trim();
        TreeSet<Integer> setIds = new TreeSet<Integer>();
        String[] tokens = Config.tokenize((String)str, (String)" ");
        for (int i2 = 0; i2 < tokens.length; ++i2) {
            String token = tokens[i2];
            abb loc = new abb(token);
            bbr type = EntityTypeUtils.getEntityType((abb)loc);
            if (type == null) {
                this.warn("Entity not found: " + token);
                continue;
            }
            int id = hm.X.a((Object)type);
            if (id < 0) {
                this.warn("Entity has no ID: " + type + ", name: " + token);
                continue;
            }
            setIds.add(new Integer(id));
        }
        Integer[] integers = setIds.toArray(new Integer[setIds.size()]);
        int[] ints = Config.toPrimitive((Integer[])integers);
        return ints;
    }
}

