/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import java.util.ArrayList;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.RendererCache;
import net.optifine.util.Either;

public abstract class ModelAdapter {
    private Either<bbr, ctk> type;
    private String name;
    private float shadowSize;
    private String[] aliases;

    public ModelAdapter(bbr entityType, String name, float shadowSize) {
        this(Either.makeLeft((Object)entityType), name, shadowSize, null);
    }

    public ModelAdapter(bbr entityType, String name, float shadowSize, String[] aliases) {
        this(Either.makeLeft((Object)entityType), name, shadowSize, aliases);
    }

    public ModelAdapter(ctk tileEntityType, String name, float shadowSize) {
        this(Either.makeRight((Object)tileEntityType), name, shadowSize, null);
    }

    public ModelAdapter(ctk tileEntityType, String name, float shadowSize, String[] aliases) {
        this(Either.makeRight((Object)tileEntityType), name, shadowSize, aliases);
    }

    public ModelAdapter(Either<bbr, ctk> type, String name, float shadowSize, String[] aliases) {
        this.type = type;
        this.name = name;
        this.shadowSize = shadowSize;
        this.aliases = aliases;
    }

    public Either<bbr, ctk> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public float getShadowSize() {
        return this.shadowSize;
    }

    public abstract esf makeModel();

    public abstract eue getModelRenderer(esf var1, String var2);

    public abstract String[] getModelRendererNames();

    public abstract IEntityRenderer makeEntityRender(esf var1, float var2, RendererCache var3, int var4);

    public boolean setTextureLocation(IEntityRenderer er, abb textureLocation) {
        return false;
    }

    public eue[] getModelRenderers(esf model) {
        String[] names = this.getModelRendererNames();
        ArrayList<eue> list = new ArrayList<eue>();
        for (int i2 = 0; i2 < names.length; ++i2) {
            String name = names[i2];
            eue mr = this.getModelRenderer(model, name);
            if (mr == null) continue;
            list.add(mr);
        }
        eue[] mrs = list.toArray(new eue[list.size()]);
        return mrs;
    }

    public static eue bakeModelLayer(euc loc) {
        return efu.I().ag().getContext().a(loc);
    }
}

