/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_3545;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4494;
import net.minecraft.class_5250;
import net.minecraft.class_638;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.ducks.IERayTraceContext;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorage;
import qouteall.imm_ptl.core.render.CrossPortalEntityRenderer;
import qouteall.q_misc_util.my_util.LimitedLogger;

public class IPMcHelper {
    public static final LimitedLogger limitedLogger = new LimitedLogger(20);

    public static void foreachNearbyPortals(class_1937 world, class_243 pos, int range, Consumer<Portal> func) {
        List<Portal> globalPortals = GlobalPortalStorage.getGlobalPortals(world);
        for (Portal globalPortal : globalPortals) {
            if (!(globalPortal.getDistanceToNearestPointInPortal(pos) < (double)(range * 2))) continue;
            func.accept(globalPortal);
        }
        McHelper.foreachEntitiesByPointAndRoughRadius(Portal.class, world, pos, range, func);
    }

    public static List<Portal> getNearbyPortalList(class_1297 center, double range, Predicate<Portal> predicate) {
        return IPMcHelper.getNearbyPortalList(center.method_37908(), center.method_19538(), range, predicate);
    }

    public static List<Portal> getNearbyPortalList(class_1937 world, class_243 pos, double range, Predicate<Portal> predicate) {
        ArrayList<Portal> result = new ArrayList<Portal>();
        IPMcHelper.foreachNearbyPortals(world, pos, (int)range, portal -> {
            if (predicate.test((Portal)portal)) {
                result.add((Portal)portal);
            }
        });
        return result;
    }

    public static Stream<Portal> getNearbyPortals(class_1297 center, double range) {
        return IPMcHelper.getNearbyPortals(center.method_37908(), center.method_19538(), range);
    }

    public static Stream<Portal> getNearbyPortals(class_1937 world, class_243 pos, double range) {
        return IPMcHelper.getNearbyPortalList(world, pos, range, e -> true).stream();
    }

    public static void traverseNearbyPortals(class_1937 world, class_243 pos, int range, Consumer<Portal> func) {
        List<Portal> globalPortals = GlobalPortalStorage.getGlobalPortals(world);
        for (Portal globalPortal : globalPortals) {
            if (!(globalPortal.getDistanceToNearestPointInPortal(pos) < (double)(range * 2))) continue;
            func.accept(globalPortal);
        }
        McHelper.traverseEntitiesByPointAndRoughRadius(Portal.class, world, pos, range, portal -> {
            func.accept((Portal)portal);
            return null;
        });
    }

    public static void onClientEntityTick(class_1297 entity) {
        CrossPortalEntityRenderer.onEntityTickClient(entity);
    }

    public static List<class_3545<Portal, class_243>> rayTracePortals(class_1937 world, class_243 start, class_243 end, boolean includeGlobalPortals, Predicate<Portal> filter) {
        class_243 middle = start.method_1021(0.5).method_1019(end.method_1021(0.5));
        int chunkRadius = (int)Math.ceil(Math.abs(start.method_1022(end) / 2.0) / 16.0);
        List<Portal> nearby = McHelper.getEntitiesNearby(world, middle, Portal.class, chunkRadius * 16);
        if (includeGlobalPortals) {
            nearby.addAll(GlobalPortalStorage.getGlobalPortals(world));
        }
        ArrayList<class_3545<Portal, class_243>> hits = new ArrayList<class_3545<Portal, class_243>>();
        nearby.forEach(portal -> {
            class_243 intersection;
            if ((filter == null || filter.test((Portal)portal)) && (intersection = portal.rayTrace(start, end)) != null) {
                hits.add(new class_3545(portal, (Object)intersection));
            }
        });
        hits.sort((pair1, pair2) -> {
            class_243 intersection1 = (class_243)pair1.method_15441();
            class_243 intersection2 = (class_243)pair2.method_15441();
            return (int)Math.signum(intersection1.method_1025(start) - intersection2.method_1025(start));
        });
        return hits;
    }

    public static <T> T withSwitchedContext(class_1937 world, Supplier<T> func) {
        if (world.field_9236) {
            return ClientWorldLoader.withSwitchedWorld((class_638)world, func);
        }
        return func.get();
    }

    private static class_3545<class_3965, List<Portal>> rayTrace(class_1937 world, class_3959 context, boolean includeGlobalPortals, List<Portal> portals) {
        class_243 start = context.method_17750();
        class_243 end = context.method_17747();
        if (portals.size() > IPGlobal.maxPortalLayer) {
            class_243 diff = end.method_1020(start);
            return new class_3545((Object)class_3965.method_17778((class_243)end, (class_2350)class_2350.method_10142((double)diff.field_1352, (double)diff.field_1351, (double)diff.field_1350), (class_2338)class_2338.method_49638((class_2374)end)), portals);
        }
        class_3965 hitResult = world.method_17742(context);
        List<class_3545<Portal, class_243>> rayTracedPortals = IPMcHelper.rayTracePortals(world, start, end, includeGlobalPortals, Portal::isInteractable);
        if (rayTracedPortals.isEmpty()) {
            return new class_3545((Object)hitResult, portals);
        }
        class_3545<Portal, class_243> portalHit = rayTracedPortals.get(0);
        Portal portal = (Portal)portalHit.method_15442();
        class_243 intersection = (class_243)portalHit.method_15441();
        if (hitResult.method_17784().method_1025(start) < intersection.method_1025(start)) {
            return new class_3545((Object)hitResult, portals);
        }
        IERayTraceContext betterContext = (IERayTraceContext)context;
        betterContext.ip_setStart(portal.transformPoint(intersection)).ip_setEnd(portal.transformPoint(end));
        portals.add(portal);
        class_1937 destWorld = portal.getDestinationWorld();
        class_3545 recursion = IPMcHelper.withSwitchedContext(destWorld, () -> IPMcHelper.rayTrace(destWorld, context, includeGlobalPortals, portals));
        betterContext.ip_setStart(start).ip_setEnd(end);
        return recursion;
    }

    public static class_3545<class_3965, List<Portal>> rayTrace(class_1937 world, class_3959 context, boolean includeGlobalPortals) {
        return IPMcHelper.rayTrace(world, context, includeGlobalPortals, new ArrayList<Portal>());
    }

    public static boolean hitResultIsMissedOrNull(class_239 hitResult) {
        return hitResult == null || hitResult.method_17783() == class_239.class_240.field_1333;
    }

    public static class_5250 getTextWithCommand(class_5250 component, String command) {
        return component.method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, command)).method_30938(Boolean.valueOf(true)));
    }

    public static class_2561 getDisableWarningText(String warningKey) {
        return class_2561.method_43470((String)" ").method_10852((class_2561)IPMcHelper.getTextWithCommand(class_2561.method_43471((String)"imm_ptl.disable_warning"), "/imm_ptl_client_debug disable_warning_for \"" + warningKey + "\"")).method_27693(" ");
    }

    public static class_2561 getDisableUpdateCheckText() {
        return class_2561.method_43470((String)" ").method_10852((class_2561)IPMcHelper.getTextWithCommand(class_2561.method_43471((String)"imm_ptl.disable_update_check"), "/imm_ptl_client_debug disable_update_check"));
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean isNvidiaVideocard() {
        return class_4494.method_22088().toLowerCase().contains("nvidia");
    }

    public static class_2540 bytesToBuf(byte[] packetBytes) {
        class_2540 buf = new class_2540(Unpooled.wrappedBuffer((byte[])packetBytes));
        return buf;
    }

    public static byte[] bufToBytes(class_2540 buf) {
        byte[] packetBytes = new byte[buf.readableBytes()];
        buf.method_52979(packetBytes);
        return packetBytes;
    }

    public static byte[] packetToBytes(class_2596<?> packet) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        packet.method_11052(buf);
        return IPMcHelper.bufToBytes(buf);
    }
}

