/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.nio.file.Path;
import java.util.function.BiConsumer;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_2168;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.block_manipulation.BlockManipulationServer;
import qouteall.imm_ptl.core.chunk_loading.EntitySync;
import qouteall.imm_ptl.core.chunk_loading.ImmPtlChunkTickets;
import qouteall.imm_ptl.core.chunk_loading.ImmPtlChunkTracking;
import qouteall.imm_ptl.core.chunk_loading.ServerPerformanceMonitor;
import qouteall.imm_ptl.core.chunk_loading.WorldInfoSender;
import qouteall.imm_ptl.core.collision.CollisionHelper;
import qouteall.imm_ptl.core.commands.AxisArgumentType;
import qouteall.imm_ptl.core.commands.PortalCommand;
import qouteall.imm_ptl.core.commands.SubCommandArgumentType;
import qouteall.imm_ptl.core.commands.TimingFunctionArgumentType;
import qouteall.imm_ptl.core.compat.IPPortingLibCompat;
import qouteall.imm_ptl.core.debug.DebugUtil;
import qouteall.imm_ptl.core.mc_utils.ServerTaskList;
import qouteall.imm_ptl.core.miscellaneous.GcMonitor;
import qouteall.imm_ptl.core.network.ImmPtlNetworkConfig;
import qouteall.imm_ptl.core.network.ImmPtlNetworking;
import qouteall.imm_ptl.core.platform_specific.IPConfig;
import qouteall.imm_ptl.core.platform_specific.O_O;
import qouteall.imm_ptl.core.portal.BreakableMirror;
import qouteall.imm_ptl.core.portal.EndPortalEntity;
import qouteall.imm_ptl.core.portal.LoadingIndicatorEntity;
import qouteall.imm_ptl.core.portal.Mirror;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalExtension;
import qouteall.imm_ptl.core.portal.PortalPlaceholderBlock;
import qouteall.imm_ptl.core.portal.animation.NormalAnimation;
import qouteall.imm_ptl.core.portal.animation.RotationAnimation;
import qouteall.imm_ptl.core.portal.custom_portal_gen.CustomPortalGenManager;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorage;
import qouteall.imm_ptl.core.portal.global_portals.GlobalTrackedPortal;
import qouteall.imm_ptl.core.portal.global_portals.VerticalConnectingPortal;
import qouteall.imm_ptl.core.portal.global_portals.WorldWrappingPortal;
import qouteall.imm_ptl.core.portal.nether_portal.GeneralBreakablePortal;
import qouteall.imm_ptl.core.portal.nether_portal.NetherPortalEntity;
import qouteall.imm_ptl.core.portal.shape.BoxPortalShape;
import qouteall.imm_ptl.core.portal.shape.RectangularPortalShape;
import qouteall.imm_ptl.core.portal.shape.SpecialFlatPortalShape;
import qouteall.imm_ptl.core.teleportation.ServerTeleportationManager;
import qouteall.imm_ptl.peripheral.platform_specific.IPFeatureControl;
import qouteall.q_misc_util.Helper;

public class IPModMain {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void init() {
        IPModMain.loadConfig();
        Helper.LOGGER.info("Immersive Portals Mod Initializing");
        ImmPtlNetworking.init();
        ImmPtlNetworkConfig.init();
        IPGlobal.POST_CLIENT_TICK_EVENT.register(IPGlobal.CLIENT_TASK_LIST::processTasks);
        IPGlobal.PRE_GAME_RENDER_EVENT.register(IPGlobal.PRE_GAME_RENDER_TASK_LIST::processTasks);
        RectangularPortalShape.init();
        SpecialFlatPortalShape.init();
        BoxPortalShape.init();
        ImmPtlChunkTracking.init();
        WorldInfoSender.init();
        GlobalPortalStorage.init();
        EntitySync.init();
        ServerTeleportationManager.init();
        CollisionHelper.init();
        PortalExtension.init();
        GcMonitor.initCommon();
        ServerPerformanceMonitor.init();
        ImmPtlChunkTickets.init();
        IPPortingLibCompat.init();
        BlockManipulationServer.init();
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> PortalCommand.register((CommandDispatcher<class_2168>)dispatcher));
        SubCommandArgumentType.init();
        TimingFunctionArgumentType.init();
        AxisArgumentType.init();
        DebugUtil.init();
        ServerTaskList.init();
        CustomPortalGenManager.init();
        RotationAnimation.init();
        NormalAnimation.init();
        if (!IPFeatureControl.enableVanillaBehaviorChangingByDefault()) {
            LOGGER.info("iPortal is provided by jar-in-jar.\nThe default value of 'nether portal mode', 'end portal mode' and 'enable mirror creation' in config will be respectively vanilla, vanilla and false.\n(The default value is only used when config file is not present of missing fields. This does not change existing config.)\n");
        }
    }

    private static void loadConfig() {
        Path gameDir = O_O.getGameDir();
        File oldConfigFile = gameDir.resolve("config").resolve("immersive_portals_fabric.json").toFile();
        if (oldConfigFile.exists()) {
            File dest = gameDir.resolve("config").resolve("immersive_portals.json").toFile();
            boolean succeeded = oldConfigFile.renameTo(dest);
            if (succeeded) {
                Helper.log("Upgraded old config file");
            } else {
                Helper.err("Failed to upgrade old config file");
            }
        }
        Helper.log("Loading Immersive Portals config");
        IPGlobal.configHolder = AutoConfig.register(IPConfig.class, GsonConfigSerializer::new);
        IPGlobal.configHolder.registerSaveListener((configHolder, ipConfig) -> {
            ipConfig.onConfigChanged();
            return class_1269.field_5812;
        });
        IPConfig ipConfig2 = IPConfig.getConfig();
        ipConfig2.onConfigChanged();
    }

    public static void registerBlocks(BiConsumer<class_2960, PortalPlaceholderBlock> regFunc) {
        regFunc.accept(new class_2960("immersive_portals", "nether_portal_block"), PortalPlaceholderBlock.instance);
    }

    public static void registerEntityTypes(BiConsumer<class_2960, class_1299<?>> regFunc) {
        regFunc.accept(new class_2960("immersive_portals", "portal"), Portal.ENTITY_TYPE);
        regFunc.accept(new class_2960("immersive_portals", "nether_portal_new"), NetherPortalEntity.ENTITY_TYPE);
        regFunc.accept(new class_2960("immersive_portals", "end_portal"), EndPortalEntity.ENTITY_TYPE);
        regFunc.accept(new class_2960("immersive_portals", "mirror"), Mirror.ENTITY_TYPE);
        regFunc.accept(new class_2960("immersive_portals", "breakable_mirror"), BreakableMirror.ENTITY_TYPE);
        regFunc.accept(new class_2960("immersive_portals", "global_tracked_portal"), GlobalTrackedPortal.ENTITY_TYPE);
        regFunc.accept(new class_2960("immersive_portals", "border_portal"), WorldWrappingPortal.ENTITY_TYPE);
        regFunc.accept(new class_2960("immersive_portals", "end_floor_portal"), VerticalConnectingPortal.ENTITY_TYPE);
        regFunc.accept(new class_2960("immersive_portals", "general_breakable_portal"), GeneralBreakablePortal.ENTITY_TYPE);
        regFunc.accept(new class_2960("immersive_portals", "loading_indicator"), LoadingIndicatorEntity.entityType);
    }
}

