/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.block_manipulation;

import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2626;
import net.minecraft.class_2846;
import net.minecraft.class_2885;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.IPMcHelper;
import qouteall.imm_ptl.core.compat.PehkuiInterface;
import qouteall.imm_ptl.core.miscellaneous.IPVanillaCopy;
import qouteall.imm_ptl.core.network.PacketRedirection;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalUtils;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorage;

public class BlockManipulationServer {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final ThreadLocal<Context> REDIRECT_CONTEXT = ThreadLocal.withInitial(() -> null);
    public static final Event<Predicate<class_1657>> canDoCrossPortalInteractionEvent = EventFactory.createArrayBacked(Predicate.class, handlers -> player -> {
        for (Predicate handler : handlers) {
            if (handler.test(player)) continue;
            return false;
        }
        return true;
    });

    private static boolean canPlayerReach(class_5321<class_1937> dimension, class_3222 player, class_2338 requestPos) {
        if (!((Predicate)canDoCrossPortalInteractionEvent.invoker()).test(player)) {
            return false;
        }
        Float playerScale = Float.valueOf(PehkuiInterface.invoker.computeBlockReachScale((class_1297)player));
        class_243 pos = class_243.method_24953((class_2382)requestPos);
        class_243 playerPos = player.method_19538();
        double distanceSquare = 576.0f * playerScale.floatValue() * playerScale.floatValue();
        if (player.method_37908().method_27983() == dimension && playerPos.method_1025(pos) < distanceSquare) {
            return true;
        }
        return IPMcHelper.getNearbyPortals((class_1297)player, IPGlobal.maxNormalPortalRadius).anyMatch(portal -> portal.getDestDim() == dimension && portal.isInteractableBy((class_1657)player) && portal.transformPoint(playerPos).method_1025(pos) < distanceSquare * portal.getScale() * portal.getScale());
    }

    public static class_3545<class_3965, class_5321<class_1937>> getHitResultForPlacing(class_1937 world, class_3965 blockHitResult) {
        class_2350 side = blockHitResult.method_17780();
        class_243 sideVec = class_243.method_24954((class_2382)side.method_10163());
        class_2338 hitPos = blockHitResult.method_17777();
        class_243 hitCenter = class_243.method_24953((class_2382)hitPos);
        List<Portal> globalPortals = GlobalPortalStorage.getGlobalPortals(world);
        Portal portal = globalPortals.stream().filter(p -> p.getNormal().method_1026(sideVec) < -0.9 && p.getPortalShape().isBoxInPortalProjection(p.getThisSideState(), new class_238(hitPos)) && p.getDistanceToPlane(hitCenter) < 0.6).findFirst().orElse(null);
        if (portal == null) {
            return new class_3545((Object)blockHitResult, (Object)world.method_27983());
        }
        class_243 newCenter = portal.transformPoint(hitCenter.method_1019(sideVec.method_1021(0.501)));
        class_2338 placingBlockPos = class_2338.method_49638((class_2374)newCenter);
        class_3965 newHitResult = new class_3965(class_243.field_1353, side.method_10153(), placingBlockPos, blockHitResult.method_17781());
        return new class_3545((Object)newHitResult, portal.getDestDim());
    }

    public static void init() {
    }

    private static void withRedirect(Context context, Runnable runnable) {
        Context original = REDIRECT_CONTEXT.get();
        REDIRECT_CONTEXT.set(context);
        try {
            PacketRedirection.withForceRedirect(context.world(), runnable);
        }
        finally {
            REDIRECT_CONTEXT.set(original);
        }
    }

    @IPVanillaCopy
    private static void doProcessPlayerAction(class_3218 world, class_3222 player, class_2846 packet) {
        player.method_14234();
        class_2338 blockPos = packet.method_12362();
        class_2846.class_2847 action = packet.method_12363();
        if (!BlockManipulationServer.canPlayerReach((class_5321<class_1937>)world.method_27983(), player, blockPos)) {
            LOGGER.error("Reject cross-portal action {} {} {}", new Object[]{player, world, blockPos});
            return;
        }
        if (BlockManipulationServer.isAttackingAction(action)) {
            player.field_13974.method_14263(blockPos, action, packet.method_12360(), world.method_31600(), packet.method_42079());
            player.field_13987.method_41255(packet.method_42079());
        }
    }

    public static boolean isAttackingAction(class_2846.class_2847 action) {
        return action == class_2846.class_2847.field_12968 || action == class_2846.class_2847.field_12971 || action == class_2846.class_2847.field_12973;
    }

    @IPVanillaCopy
    private static void doProcessUseItemOn(class_3218 world, class_3222 player, class_2885 packet) {
        player.field_13987.method_41255(packet.method_42080());
        class_1268 hand = packet.method_12546();
        class_3965 blockHitResult = packet.method_12543();
        class_5321 dimension = world.method_27983();
        class_1799 itemStack = player.method_5998(hand);
        if (!itemStack.method_45435(world.method_45162())) {
            return;
        }
        class_2338 blockPos = blockHitResult.method_17777();
        class_2350 direction = blockHitResult.method_17780();
        player.method_14234();
        if (world.method_8505((class_1657)player, blockPos)) {
            if (!BlockManipulationServer.canPlayerReach((class_5321<class_1937>)dimension, player, blockPos)) {
                LOGGER.error("Reject cross-portal action {} {} {}", new Object[]{player, world, blockPos});
                return;
            }
            class_1269 actionResult = player.field_13974.method_14262(player, (class_1937)world, itemStack, hand, blockHitResult);
            if (actionResult.method_23666()) {
                player.method_23667(hand, true);
            }
        }
        PacketRedirection.sendRedirectedMessage(player, (class_5321<class_1937>)dimension, (class_2596<class_2602>)new class_2626((class_1922)world, blockPos));
        class_2338 offseted = blockPos.method_10093(direction);
        if (offseted.method_10264() >= world.method_31607() && offseted.method_10264() < world.method_31600()) {
            PacketRedirection.sendRedirectedMessage(player, (class_5321<class_1937>)dimension, (class_2596<class_2602>)new class_2626((class_1922)world, offseted));
        }
    }

    public static boolean validateReach(class_1657 player, class_1937 targetWorld, class_2338 targetPos) {
        PortalUtils.PortalAwareRaytraceResult result = PortalUtils.portalAwareRayTrace(player.method_37908(), player.method_33571(), player.method_5828(1.0f), 32.0, (class_1297)player, class_3959.class_3960.field_17558);
        return result != null && result.world() == targetWorld && result.hitResult().method_17777().method_19455((class_2382)targetPos) < 8;
    }

    public record Context(class_3218 world, @Nullable class_3965 blockHitResult) {
    }

    public static class RemoteCallables {
        public static void processPlayerActionPacket(class_3222 player, class_5321<class_1937> dimension, byte[] packetBytes) {
            class_2540 buf = IPMcHelper.bytesToBuf(packetBytes);
            class_2846 packet = new class_2846(buf);
            class_3218 world = player.field_13995.method_3847(dimension);
            Validate.notNull((Object)world, (String)"missing %s", (Object[])new Object[]{dimension.method_29177()});
            BlockManipulationServer.withRedirect(new Context(world, null), () -> BlockManipulationServer.doProcessPlayerAction(world, player, packet));
        }

        public static void processUseItemOnPacket(class_3222 player, class_5321<class_1937> dimension, byte[] packetBytes) {
            class_2540 buf = IPMcHelper.bytesToBuf(packetBytes);
            class_2885 packet = new class_2885(buf);
            class_3218 world = player.field_13995.method_3847(dimension);
            Validate.notNull((Object)world, (String)"missing %s", (Object[])new Object[]{dimension.method_29177()});
            BlockManipulationServer.withRedirect(new Context(world, packet.method_12543()), () -> BlockManipulationServer.doProcessUseItemOn(world, player, packet));
        }
    }
}

