/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.chunk_loading;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.chunk_loading.ChunkLoader;
import qouteall.imm_ptl.core.chunk_loading.DimensionalChunkPos;
import qouteall.imm_ptl.core.chunk_loading.ImmPtlChunkTracking;
import qouteall.imm_ptl.core.chunk_loading.PerformanceLevel;
import qouteall.imm_ptl.core.chunk_loading.ServerPerformanceMonitor;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorage;
import qouteall.q_misc_util.my_util.LimitedLogger;

public class ChunkVisibility {
    private static final LimitedLogger limitedLogger = new LimitedLogger(10);
    private static final int portalLoadingRange = 48;
    public static final int secondaryPortalLoadingRange = 16;

    public static ChunkLoader playerDirectLoader(class_3222 player) {
        return new ChunkLoader(new DimensionalChunkPos((class_5321<class_1937>)player.method_37908().method_27983(), player.method_31476()), McHelper.getPlayerLoadDistance(player));
    }

    private static int getDirectLoadingDistance(int renderDistance, double distanceToPortal) {
        if (distanceToPortal < 5.0) {
            return renderDistance;
        }
        if (distanceToPortal < 15.0) {
            return renderDistance * 2 / 3;
        }
        return renderDistance / 3;
    }

    private static int getCappedLoadingDistance(Portal portal, class_3222 player, int targetLoadingDistance) {
        PerformanceLevel performanceLevel = ImmPtlChunkTracking.getPlayerInfo((class_3222)player).performanceLevel;
        int cap1 = PerformanceLevel.getIndirectLoadingRadiusCap(performanceLevel);
        int cap2 = IPGlobal.indirectLoadingRadiusCap;
        int cap3 = PerformanceLevel.getIndirectLoadingRadiusCap(ServerPerformanceMonitor.getLevel());
        int cap = Math.min(cap1, cap2);
        if (portal.getScale() > 2.0) {
            cap *= 2;
        }
        int cappedLoadingDistance = Math.min(targetLoadingDistance, cap);
        return cappedLoadingDistance;
    }

    public static List<Portal> getNearbyPortals(class_3218 world, class_243 pos, Predicate<Portal> predicate, int radiusChunks, int radiusChunksForGlobalPortals) {
        List<Portal> result = McHelper.findEntitiesRough(Portal.class, (class_1937)world, pos, radiusChunks, predicate);
        for (Portal globalPortal : GlobalPortalStorage.getGlobalPortals((class_1937)world)) {
            double distance = globalPortal.getDistanceToNearestPointInPortal(pos);
            if (!(distance < (double)(radiusChunksForGlobalPortals * 16))) continue;
            result.add(globalPortal);
        }
        if (result.size() > 100) {
            limitedLogger.err("too many portal nearby " + world + pos);
            Optional<Portal> nearest = result.stream().min(Comparator.comparingDouble(p -> p.getDistanceToNearestPointInPortal(pos)));
            return List.of(nearest.get());
        }
        return result;
    }

    private static ChunkLoader getGeneralDirectPortalLoader(class_3222 player, Portal portal) {
        if (portal.getIsGlobal()) {
            int renderDistance = Math.min(IPGlobal.indirectLoadingRadiusCap * 2, Math.max(2, McHelper.getPlayerLoadDistance(player) - Math.floorDiv((int)portal.getDistanceToNearestPointInPortal(player.method_19538()), 16)));
            return new ChunkLoader(new DimensionalChunkPos(portal.getDestDim(), new class_1923(class_2338.method_49638((class_2374)portal.transformPoint(player.method_19538())))), renderDistance);
        }
        int loadDistance = McHelper.getPlayerLoadDistance(player);
        double distance = portal.getDistanceToNearestPointInPortal(player.method_19538());
        if (portal.getScaling() > 2.0 && distance < 5.0) {
            loadDistance = (int)(portal.getDestAreaRadiusEstimation() * 1.4 / 16.0);
        }
        return new ChunkLoader(new DimensionalChunkPos(portal.getDestDim(), new class_1923(class_2338.method_49638((class_2374)portal.getDestPos()))), ChunkVisibility.getCappedLoadingDistance(portal, player, ChunkVisibility.getDirectLoadingDistance(loadDistance, distance)));
    }

    private static ChunkLoader getGeneralPortalIndirectLoader(class_3222 player, class_243 transformedPos, Portal portal) {
        int loadDistance = McHelper.getPlayerLoadDistance(player);
        if (portal.getIsGlobal()) {
            int renderDistance = Math.min(IPGlobal.indirectLoadingRadiusCap, loadDistance / 3);
            return new ChunkLoader(new DimensionalChunkPos(portal.getDestDim(), new class_1923(class_2338.method_49638((class_2374)transformedPos))), renderDistance);
        }
        return new ChunkLoader(new DimensionalChunkPos(portal.getDestDim(), new class_1923(class_2338.method_49638((class_2374)portal.getDestPos()))), ChunkVisibility.getCappedLoadingDistance(portal, player, loadDistance / 4));
    }

    public static void foreachBaseChunkLoaders(class_3222 player, Consumer<ChunkLoader> func) {
        PerformanceLevel perfLevel = ImmPtlChunkTracking.getPlayerInfo((class_3222)player).performanceLevel;
        int visiblePortalRangeChunks = PerformanceLevel.getVisiblePortalRangeChunks(perfLevel);
        int indirectVisiblePortalRangeChunks = PerformanceLevel.getIndirectVisiblePortalRangeChunks(perfLevel);
        ChunkLoader playerDirectLoader = ChunkVisibility.playerDirectLoader(player);
        func.accept(playerDirectLoader);
        List<Portal> nearbyPortals = ChunkVisibility.getNearbyPortals((class_3218)player.method_37908(), player.method_19538(), portal -> portal.method_5680(player), visiblePortalRangeChunks, 256);
        for (Portal portal2 : nearbyPortals) {
            class_1937 destinationWorld = portal2.getDestinationWorld();
            if (destinationWorld == null) continue;
            class_243 transformedPlayerPos = portal2.transformPoint(player.method_19538());
            func.accept(ChunkVisibility.getGeneralDirectPortalLoader(player, portal2));
            if (ChunkVisibility.isShrinkLoading()) continue;
            List<Portal> indirectNearbyPortals = ChunkVisibility.getNearbyPortals((class_3218)destinationWorld, transformedPlayerPos, p -> p.method_5680(player), indirectVisiblePortalRangeChunks, 32);
            for (Portal innerPortal : indirectNearbyPortals) {
                func.accept(ChunkVisibility.getGeneralPortalIndirectLoader(player, transformedPlayerPos, innerPortal));
            }
        }
    }

    public static boolean isShrinkLoading() {
        return ServerPerformanceMonitor.getLevel() != PerformanceLevel.good;
    }
}

