/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.chunk_loading;

import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongPredicate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import net.minecraft.class_1923;
import net.minecraft.class_3193;
import net.minecraft.class_3204;
import net.minecraft.class_3218;
import net.minecraft.class_3228;
import net.minecraft.class_3230;
import net.minecraft.class_4706;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import qouteall.dimlib.api.DimensionAPI;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.ducks.IEChunkMap;
import qouteall.imm_ptl.core.ducks.IEServerChunkCache;
import qouteall.imm_ptl.core.ducks.IEWorld;
import qouteall.imm_ptl.core.mixin.common.chunk_sync.IEDistanceManager;
import qouteall.imm_ptl.core.platform_specific.IPConfig;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.RateStat;

public class ImmPtlChunkTickets {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final class_3230<class_1923> TICKET_TYPE = class_3230.method_14291((String)"imm_ptl", Comparator.comparingLong(class_1923::method_8324));
    private static boolean enableDebugRateStat = false;
    private static final RateStat debugRateStat = new RateStat("imm_ptl_chunk_ticket");
    public static final WeakHashMap<class_3218, ImmPtlChunkTickets> BY_DIMENSION = new WeakHashMap();
    private final Long2ObjectOpenHashMap<ChunkTicketInfo> chunkPosToTicketInfo = new Long2ObjectOpenHashMap();
    private final ArrayList<LongLinkedOpenHashSet> chunksToAddTicketByDistance = new ArrayList();
    private final LongOpenHashSet waitingForLoading = new LongOpenHashSet();
    private boolean isValid = true;
    public final int throttlingLimit = 4;

    public static void init() {
        DimensionAPI.SERVER_PRE_REMOVE_DIMENSION_EVENT.register(ImmPtlChunkTickets::onDimensionRemove);
        IPGlobal.SERVER_CLEANUP_EVENT.register(ImmPtlChunkTickets::cleanup);
    }

    private ImmPtlChunkTickets() {
    }

    public static ImmPtlChunkTickets get(class_3218 world) {
        return BY_DIMENSION.computeIfAbsent(world, k -> new ImmPtlChunkTickets());
    }

    public void markForLoading(long chunkPos, int distanceToSource, int generation) {
        Validate.isTrue((distanceToSource >= 0 && distanceToSource <= 32 ? 1 : 0) != 0);
        ChunkTicketInfo info = (ChunkTicketInfo)this.chunkPosToTicketInfo.get(chunkPos);
        if (info == null) {
            info = new ChunkTicketInfo(generation, distanceToSource);
            this.chunkPosToTicketInfo.put(chunkPos, (Object)info);
            this.getQueueByDistance(distanceToSource).add(chunkPos);
        } else if (generation != info.lastUpdateGeneration) {
            info.lastUpdateGeneration = generation;
            int oldDistanceToSource = info.distanceToSource;
            info.distanceToSource = distanceToSource;
            if (this.getQueueByDistance(oldDistanceToSource).remove(chunkPos)) {
                this.getQueueByDistance(distanceToSource).add(chunkPos);
            }
        } else if (distanceToSource < info.distanceToSource) {
            int oldDistanceToSource = info.distanceToSource;
            info.distanceToSource = distanceToSource;
            if (this.getQueueByDistance(oldDistanceToSource).remove(chunkPos)) {
                this.getQueueByDistance(distanceToSource).add(chunkPos);
            }
        }
    }

    private LongLinkedOpenHashSet getQueueByDistance(int distanceToSource) {
        return Helper.arrayListComputeIfAbsent(this.chunksToAddTicketByDistance, distanceToSource, LongLinkedOpenHashSet::new);
    }

    public void tick(class_3218 world) {
        this.flushThrottling(world);
    }

    public void flushThrottling(class_3218 world) {
        if (Thread.currentThread() != ((IEWorld)world).portal_getThread()) {
            LOGGER.error("Called in a non-server-main (or server-world) thread.", new Throwable());
            return;
        }
        if (enableDebugRateStat) {
            debugRateStat.update();
        }
        if (!this.isValid) {
            LOGGER.error("flushing when invalid {}", (Object)world);
            return;
        }
        if (!world.method_8503().method_3806()) {
            return;
        }
        class_3204 distanceManager = ImmPtlChunkTickets.getDistanceManager(world);
        Executor mainThreadExecutor = ((IEDistanceManager)distanceManager).ip_getMainThreadExecutor();
        this.waitingForLoading.removeIf(chunkPos -> {
            class_3193 chunkHolder = ImmPtlChunkTickets.getChunkHolder(world, chunkPos);
            if (chunkHolder == null) {
                return true;
            }
            Either resultNow = chunkHolder.method_14003().getNow(null);
            return resultNow != null && resultNow.left().isPresent();
        });
        for (LongLinkedOpenHashSet queue : this.chunksToAddTicketByDistance) {
            if (queue == null) continue;
            while (!queue.isEmpty()) {
                if (this.waitingForLoading.size() >= 4) {
                    return;
                }
                long chunkPos2 = queue.removeFirstLong();
                if (this.chunkPosToTicketInfo.containsKey(chunkPos2)) {
                    ImmPtlChunkTickets.addTicket(distanceManager, chunkPos2);
                    this.waitingForLoading.add(chunkPos2);
                    continue;
                }
                LOGGER.warn("Chunk {} is not in the queue", (Object)new class_1923(chunkPos2));
            }
        }
    }

    private static void addTicket(class_3204 distanceManager, long chunkPos) {
        if (!IPConfig.getConfig().enableImmPtlChunkLoading) {
            return;
        }
        class_1923 chunkPosObj = new class_1923(chunkPos);
        distanceManager.method_17291(TICKET_TYPE, chunkPosObj, ImmPtlChunkTickets.getLoadingRadius(), (Object)chunkPosObj);
        if (enableDebugRateStat) {
            debugRateStat.hit();
        }
    }

    public void purge(class_3218 world, LongPredicate shouldKeepLoadingFunc) {
        class_3204 distanceManager = ImmPtlChunkTickets.getDistanceManager(world);
        this.chunkPosToTicketInfo.long2ObjectEntrySet().removeIf(e -> {
            long chunkPos = e.getLongKey();
            ChunkTicketInfo ticketInfo = (ChunkTicketInfo)e.getValue();
            boolean keepLoading = shouldKeepLoadingFunc.test(chunkPos);
            if (!keepLoading) {
                this.waitingForLoading.remove(chunkPos);
                boolean pendingTicketAdding = this.getQueueByDistance(ticketInfo.distanceToSource).remove(chunkPos);
                if (!pendingTicketAdding) {
                    class_1923 chunkPosObj = new class_1923(chunkPos);
                    distanceManager.method_17292(TICKET_TYPE, chunkPosObj, ImmPtlChunkTickets.getLoadingRadius(), (Object)chunkPosObj);
                }
                return true;
            }
            return false;
        });
    }

    public int getLoadedChunkNum() {
        return this.chunkPosToTicketInfo.size();
    }

    public static void onDimensionRemove(class_3218 world) {
        ImmPtlChunkTickets dimTicketManager = BY_DIMENSION.remove(world);
        if (dimTicketManager == null) {
            return;
        }
        ImmPtlChunkTickets.removeAllTicketsInWorld(world, dimTicketManager);
    }

    private static void removeAllTicketsInWorld(class_3218 world, ImmPtlChunkTickets dimTicketManager) {
        class_3204 ticketManager = ImmPtlChunkTickets.getDistanceManager(world);
        dimTicketManager.chunkPosToTicketInfo.keySet().forEach(pos -> {
            class_4706<class_3228<?>> tickets = ((qouteall.imm_ptl.core.ducks.IEDistanceManager)ImmPtlChunkTickets.getDistanceManager(world)).portal_getTicketSet(pos);
            List<class_3228> toRemove = tickets.stream().filter(t -> t.method_14281() == TICKET_TYPE).toList();
            class_1923 chunkPos = new class_1923(pos);
            for (class_3228 ticket : toRemove) {
                ticketManager.method_17292(TICKET_TYPE, chunkPos, ticket.method_14283(), (Object)chunkPos);
            }
        });
        dimTicketManager.isValid = false;
    }

    public static int getLoadingRadius() {
        if (IPGlobal.activeLoading) {
            return 2;
        }
        return 1;
    }

    public static class_3193 getChunkHolder(class_3218 world, long chunkPos) {
        return ((IEChunkMap)world.method_14178().field_17254).ip_getChunkHolder(chunkPos);
    }

    public static class_3204 getDistanceManager(class_3218 world) {
        return ((IEServerChunkCache)world.method_14178()).ip_getDistanceManager();
    }

    private static void cleanup(MinecraftServer server) {
        for (ImmPtlChunkTickets immPtlChunkTickets : BY_DIMENSION.values()) {
            immPtlChunkTickets.isValid = false;
        }
        BY_DIMENSION.clear();
    }

    public static class ChunkTicketInfo {
        public int lastUpdateGeneration;
        public int distanceToSource;

        public ChunkTicketInfo(int lastUpdateGeneration, int distanceToSource) {
            this.lastUpdateGeneration = lastUpdateGeneration;
            this.distanceToSource = distanceToSource;
        }
    }
}

