/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.chunk_loading;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2666;
import net.minecraft.class_2818;
import net.minecraft.class_3193;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.dimlib.api.DimensionAPI;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.chunk_loading.ChunkLoader;
import qouteall.imm_ptl.core.chunk_loading.ChunkVisibility;
import qouteall.imm_ptl.core.chunk_loading.EntitySync;
import qouteall.imm_ptl.core.chunk_loading.ImmPtlChunkTickets;
import qouteall.imm_ptl.core.chunk_loading.PerformanceLevel;
import qouteall.imm_ptl.core.chunk_loading.PlayerChunkLoading;
import qouteall.imm_ptl.core.ducks.IEChunkMap;
import qouteall.imm_ptl.core.mixin.common.chunk_sync.IEServerCommonPacketListenerImpl;
import qouteall.imm_ptl.core.network.PacketRedirection;
import qouteall.q_misc_util.my_util.IntBox;

public class ImmPtlChunkTracking {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int updateInterval = 13;
    public static final int defaultDelayUnloadGenerations = 4;
    private static final Map<class_5321<class_1937>, Long2ObjectOpenHashMap<Object2ObjectOpenHashMap<class_3222, PlayerWatchRecord>>> chunkWatchRecords = new Object2ObjectOpenHashMap();
    private static final ArrayList<ChunkLoader> additionalChunkLoaders = new ArrayList();
    private static final Object2ObjectOpenHashMap<class_3222, PlayerChunkLoading> playerInfoMap = new Object2ObjectOpenHashMap();
    private static int generationCounter = 0;

    public static void init() {
        ServerTickEvents.END_SERVER_TICK.register(ImmPtlChunkTracking::tick);
        IPGlobal.SERVER_CLEANUP_EVENT.register(ImmPtlChunkTracking::cleanup);
        DimensionAPI.SERVER_PRE_REMOVE_DIMENSION_EVENT.register(ImmPtlChunkTracking::onDimensionRemove);
    }

    public static void onChunkProvidedDeferred(class_2818 chunk) {
    }

    public static void removePlayerFromChunkTrackersAndEntityTrackers(class_3222 oldPlayer) {
        for (class_3218 world : oldPlayer.field_13995.method_3738()) {
            class_3215 chunkManager = world.method_14178();
            IEChunkMap storage = (IEChunkMap)chunkManager.field_17254;
            storage.ip_onPlayerUnload(oldPlayer);
        }
        ImmPtlChunkTracking.forceRemovePlayer(oldPlayer);
    }

    public static void onDimensionRemove(class_3218 world) {
        class_3215 chunkManager = world.method_14178();
        IEChunkMap storage = (IEChunkMap)chunkManager.field_17254;
        storage.ip_onDimensionRemove();
        ImmPtlChunkTracking.forceRemoveDimension(world);
    }

    private static Long2ObjectOpenHashMap<Object2ObjectOpenHashMap<class_3222, PlayerWatchRecord>> getDimChunkWatchRecords(class_5321<class_1937> dimension) {
        return chunkWatchRecords.computeIfAbsent(dimension, k -> new Long2ObjectOpenHashMap());
    }

    public static PlayerChunkLoading getPlayerInfo(class_3222 player) {
        return (PlayerChunkLoading)playerInfoMap.computeIfAbsent((Object)player, p -> new PlayerChunkLoading(((IEServerCommonPacketListenerImpl)p.field_13987).ip_getConnection().method_10756()));
    }

    public static void immediatelyUpdateForPlayer(class_3222 player) {
        ImmPtlChunkTracking.updateForPlayer(player);
        ImmPtlChunkTracking.getPlayerInfo(player).doChunkSending(player);
        EntitySync.update(player.field_13995);
    }

    public static void updateForPlayer(class_3222 player) {
        PlayerChunkLoading playerInfo = ImmPtlChunkTracking.getPlayerInfo(player);
        playerInfo.visibleDimensions.clear();
        int lastLoadedChunks = playerInfo.loadedChunks;
        playerInfo.loadedChunks = 0;
        ObjectOpenHashSet chunkLoaders = new ObjectOpenHashSet();
        ChunkVisibility.foreachBaseChunkLoaders(player, arg_0 -> ((ObjectOpenHashSet)chunkLoaders).add(arg_0));
        chunkLoaders.addAll(playerInfo.additionalChunkLoaders);
        MinecraftServer server = player.field_13995;
        for (ChunkLoader chunkLoader : chunkLoaders) {
            class_5321<class_1937> dimension = chunkLoader.dimension();
            Long2ObjectOpenHashMap<Object2ObjectOpenHashMap<class_3222, PlayerWatchRecord>> chunkRecordMap = ImmPtlChunkTracking.getDimChunkWatchRecords(dimension);
            class_3218 world = server.method_3847(dimension);
            if (world == null) {
                LOGGER.warn("Dimension not loaded {} in chunk loader {}", dimension, (Object)chunkLoader);
                return;
            }
            playerInfo.visibleDimensions.add(dimension);
            ImmPtlChunkTickets ticketInfo = ImmPtlChunkTickets.get(world);
            chunkLoader.foreachChunkPos((dim, x, z, distanceToSource) -> {
                long chunkPos = class_1923.method_8331((int)x, (int)z);
                Object2ObjectOpenHashMap records = (Object2ObjectOpenHashMap)chunkRecordMap.computeIfAbsent(chunkPos, k -> new Object2ObjectOpenHashMap());
                ticketInfo.markForLoading(chunkPos, distanceToSource, generationCounter);
                records.compute((Object)player, (k, record) -> {
                    boolean isBoundary;
                    boolean bl = isBoundary = distanceToSource == chunkLoader.radius();
                    if (record == null) {
                        PlayerWatchRecord newRecord = new PlayerWatchRecord(player, dimension, chunkPos, generationCounter, distanceToSource, false, isBoundary);
                        playerInfo.markPendingLoading(newRecord);
                        ++playerInfo.loadedChunks;
                        return newRecord;
                    }
                    int oldDistance = record.distanceToSource;
                    if (record.lastWatchGeneration == generationCounter) {
                        if (distanceToSource < oldDistance) {
                            record.distanceToSource = distanceToSource;
                            playerInfo.markPendingLoading((PlayerWatchRecord)record);
                        }
                        record.isBoundary = record.isBoundary && isBoundary;
                    } else {
                        ++playerInfo.loadedChunks;
                        if (distanceToSource < oldDistance) {
                            playerInfo.markPendingLoading((PlayerWatchRecord)record);
                        }
                        record.distanceToSource = distanceToSource;
                        record.lastWatchGeneration = generationCounter;
                        record.isBoundary = isBoundary;
                    }
                    return record;
                });
            });
        }
    }

    private static void purge(MinecraftServer server, Object2ObjectOpenHashMap<class_5321<class_1937>, LongOpenHashSet> additionalLoadedChunks) {
        chunkWatchRecords.forEach((dimension, chunkRecords) -> chunkRecords.long2ObjectEntrySet().removeIf(entry -> {
            long chunkPosLong = entry.getLongKey();
            Object2ObjectOpenHashMap dimChunkWatchRecords = (Object2ObjectOpenHashMap)entry.getValue();
            dimChunkWatchRecords.entrySet().removeIf(e -> {
                boolean shouldRemove;
                class_3222 player = (class_3222)e.getKey();
                if (player.method_31481()) {
                    return true;
                }
                PlayerWatchRecord record = (PlayerWatchRecord)e.getValue();
                int delayUnloadGenerations = ImmPtlChunkTracking.getDelayUnloadGenerationForPlayer(player);
                boolean bl = shouldRemove = generationCounter - record.lastWatchGeneration > delayUnloadGenerations;
                if (shouldRemove) {
                    if (record.isLoadedToPlayer) {
                        player.field_13987.method_14364(PacketRedirection.createRedirectedMessage(player.method_5682(), record.dimension, (class_2596<class_2602>)new class_2666(new class_1923(record.chunkPos))));
                    }
                    record.isValid = false;
                }
                return shouldRemove;
            });
            return dimChunkWatchRecords.isEmpty();
        }));
        playerInfoMap.entrySet().removeIf(e -> ((class_3222)e.getKey()).method_31481());
        for (class_3218 world : server.method_3738()) {
            class_5321 dimension2 = world.method_27983();
            @Nullable LongOpenHashSet additional = (LongOpenHashSet)additionalLoadedChunks.get((Object)dimension2);
            Long2ObjectOpenHashMap<Object2ObjectOpenHashMap<class_3222, PlayerWatchRecord>> watchRecs = chunkWatchRecords.get(dimension2);
            ImmPtlChunkTickets dimTicketManager = ImmPtlChunkTickets.get(world);
            dimTicketManager.purge(world, chunkPos -> {
                if (watchRecs != null && watchRecs.containsKey(chunkPos)) {
                    return true;
                }
                return additional != null && additional.contains(chunkPos);
            });
        }
    }

    private static int getDelayUnloadGenerationForPlayer(class_3222 player) {
        PlayerChunkLoading playerInfo = ImmPtlChunkTracking.getPlayerInfo(player);
        if (playerInfo == null) {
            return 4;
        }
        int loadedChunks = playerInfo.loadedChunks;
        if (loadedChunks > 2000) {
            return 1;
        }
        if (loadedChunks > 1200) {
            return 2;
        }
        return 4;
    }

    private static Object2ObjectOpenHashMap<class_5321<class_1937>, LongOpenHashSet> refreshAdditionalChunkLoaders(MinecraftServer server) {
        Object2ObjectOpenHashMap additionalLoadedChunks = new Object2ObjectOpenHashMap();
        additionalChunkLoaders.removeIf(chunkLoader -> {
            class_5321<class_1937> dimension = chunkLoader.dimension();
            class_3218 world = server.method_3847(dimension);
            if (world == null) {
                LOGGER.error("Missing dimension in chunk loader {}", (Object)dimension.method_29177());
                return true;
            }
            final ImmPtlChunkTickets dimTicketManager = ImmPtlChunkTickets.get(world);
            final LongOpenHashSet set = (LongOpenHashSet)additionalLoadedChunks.computeIfAbsent(dimension, k -> new LongOpenHashSet());
            chunkLoader.foreachChunkPos(new ChunkLoader.ChunkPosConsumer(){

                @Override
                public void consume(class_5321<class_1937> dimension, int x, int z, int distanceToSource) {
                    long chunkPos = class_1923.method_8331((int)x, (int)z);
                    dimTicketManager.markForLoading(chunkPos, distanceToSource, generationCounter);
                    set.add(chunkPos);
                }
            });
            return false;
        });
        return additionalLoadedChunks;
    }

    private static void tick(MinecraftServer server) {
        server.method_16044().method_15396("portal_chunk_tracking");
        boolean updates = false;
        long gameTime = server.method_30002().method_8510();
        for (class_3222 player : server.method_3760().method_14571()) {
            PlayerChunkLoading playerInfo = ImmPtlChunkTracking.getPlayerInfo(player);
            if (!playerInfo.shouldUpdateImmediately && (long)(player.method_5628() % 13) != gameTime % 13L) continue;
            playerInfo.shouldUpdateImmediately = false;
            ImmPtlChunkTracking.updateForPlayer(player);
            updates = true;
        }
        if (gameTime % 13L == 0L) {
            Object2ObjectOpenHashMap<class_5321<class_1937>, LongOpenHashSet> additionalLoadedChunks = ImmPtlChunkTracking.refreshAdditionalChunkLoaders(server);
            ImmPtlChunkTracking.purge(server, additionalLoadedChunks);
            ++generationCounter;
            updates = true;
        }
        for (class_3218 world : server.method_3738()) {
            ImmPtlChunkTickets dimTicketManager = ImmPtlChunkTickets.get(world);
            dimTicketManager.tick(world);
        }
        server.method_16044().method_15407();
        if (updates) {
            EntitySync.update(server);
        }
        EntitySync.tick(server);
    }

    public static boolean isPlayerWatchingChunk(class_3222 player, class_5321<class_1937> dimension, int x, int z, Predicate<PlayerWatchRecord> predicate) {
        long chunkPos = class_1923.method_8331((int)x, (int)z);
        Object2ObjectOpenHashMap recordMap = (Object2ObjectOpenHashMap)ImmPtlChunkTracking.getDimChunkWatchRecords(dimension).get(chunkPos);
        if (recordMap == null) {
            return false;
        }
        PlayerWatchRecord record = (PlayerWatchRecord)recordMap.get((Object)player);
        if (record == null) {
            return false;
        }
        if (!record.isLoadedToPlayer) {
            return false;
        }
        return predicate.test(record);
    }

    public static boolean isPlayerWatchingChunk(class_3222 player, class_5321<class_1937> dimension, int x, int z) {
        return ImmPtlChunkTracking.isPlayerWatchingChunk(player, dimension, x, z, r -> true);
    }

    public static boolean isPlayerWatchingChunkWithinRadius(class_3222 player, class_5321<class_1937> dimension, int x, int z, int radiusBlocks) {
        return ImmPtlChunkTracking.isPlayerWatchingChunk(player, dimension, x, z, r -> r.distanceToSource * 16 <= radiusBlocks);
    }

    private static void cleanup(MinecraftServer server) {
        chunkWatchRecords.clear();
        additionalChunkLoaders.clear();
        playerInfoMap.clear();
    }

    public static Stream<class_3222> getPlayersViewingChunk(class_5321<class_1937> dimension, int x, int z) {
        Object2ObjectOpenHashMap<class_3222, PlayerWatchRecord> records = ImmPtlChunkTracking.getWatchRecordForChunk(dimension, x, z);
        if (records == null) {
            return Stream.empty();
        }
        return records.values().stream().filter(e -> e.isLoadedToPlayer).map(e -> e.player);
    }

    public static List<class_3222> getPlayersViewingChunk(class_5321<class_1937> dimension, int x, int z, boolean boundaryOnly) {
        Object2ObjectOpenHashMap<class_3222, PlayerWatchRecord> recs = ImmPtlChunkTracking.getWatchRecordForChunk(dimension, x, z);
        if (recs == null) {
            return Collections.emptyList();
        }
        ArrayList<class_3222> result = new ArrayList<class_3222>();
        for (PlayerWatchRecord rec : recs.values()) {
            if (!rec.isLoadedToPlayer || boundaryOnly && !rec.isBoundary) continue;
            result.add(rec.player);
        }
        return result;
    }

    @Nullable
    public static Object2ObjectOpenHashMap<class_3222, PlayerWatchRecord> getWatchRecordForChunk(class_5321<class_1937> dimension, int x, int z) {
        return (Object2ObjectOpenHashMap)ImmPtlChunkTracking.getDimChunkWatchRecords(dimension).get(class_1923.method_8331((int)x, (int)z));
    }

    public static void forceRemovePlayer(class_3222 oldPlayer) {
        playerInfoMap.remove((Object)oldPlayer);
        chunkWatchRecords.forEach((dim, dimMap) -> dimMap.long2ObjectEntrySet().removeIf(e -> {
            long chunkPos = e.getLongKey();
            Object2ObjectOpenHashMap records = (Object2ObjectOpenHashMap)e.getValue();
            PlayerWatchRecord rec = (PlayerWatchRecord)records.remove((Object)oldPlayer);
            if (rec != null) {
                PacketRedirection.sendRedirectedMessage(oldPlayer, (class_5321<class_1937>)dim, (class_2596<class_2602>)new class_2666(new class_1923(chunkPos)));
            }
            return records.isEmpty();
        }));
    }

    public static void forceRemoveDimension(class_3218 world) {
        class_5321 dim = world.method_27983();
        MinecraftServer server = world.method_8503();
        Long2ObjectOpenHashMap<Object2ObjectOpenHashMap<class_3222, PlayerWatchRecord>> map = chunkWatchRecords.get(dim);
        if (map == null) {
            return;
        }
        map.forEach((chunkPos, records) -> {
            class_2596<class_2602> unloadPacket = PacketRedirection.createRedirectedMessage(server, (class_5321<class_1937>)dim, (class_2596<class_2602>)new class_2666(new class_1923(chunkPos.longValue())));
            for (PlayerWatchRecord record : records.values()) {
                if (record.isValid && record.isLoadedToPlayer) {
                    record.player.field_13987.method_14364(unloadPacket);
                }
                record.isValid = false;
            }
        });
        chunkWatchRecords.remove(dim);
        additionalChunkLoaders.removeIf(chunkLoader -> chunkLoader.dimension() == dim);
        for (PlayerChunkLoading playerInfo : playerInfoMap.values()) {
            playerInfo.additionalChunkLoaders.removeIf(l -> l.dimension() == dim);
        }
    }

    public static boolean shouldLoadDimension(class_5321<class_1937> dimension) {
        if (!chunkWatchRecords.containsKey(dimension)) {
            return false;
        }
        Long2ObjectOpenHashMap<Object2ObjectOpenHashMap<class_3222, PlayerWatchRecord>> map = chunkWatchRecords.get(dimension);
        return !map.isEmpty();
    }

    public static void addGlobalAdditionalChunkLoader(MinecraftServer server, ChunkLoader chunkLoader) {
        additionalChunkLoaders.add(chunkLoader);
        class_5321<class_1937> dimension = chunkLoader.dimension();
        class_3218 world = server.method_3847(dimension);
        if (world == null) {
            LOGGER.error("Missing dimension in chunk loader {}", (Object)dimension.method_29177());
            return;
        }
        ImmPtlChunkTickets dimTicketManager = ImmPtlChunkTickets.get(world);
        chunkLoader.foreachChunkPos((dim, x, z, distanceToSource) -> dimTicketManager.markForLoading(class_1923.method_8331((int)x, (int)z), distanceToSource, generationCounter));
    }

    public static void removeGlobalAdditionalChunkLoader(MinecraftServer server, ChunkLoader chunkLoader) {
        additionalChunkLoaders.removeIf(c -> c == chunkLoader);
    }

    public static int getLoadedChunkNum(class_5321<class_1937> dimension) {
        return ImmPtlChunkTracking.getDimChunkWatchRecords(dimension).size();
    }

    public static void addPerPlayerAdditionalChunkLoader(class_3222 player, ChunkLoader chunkLoader) {
        PlayerChunkLoading playerInfo = ImmPtlChunkTracking.getPlayerInfo(player);
        playerInfo.additionalChunkLoaders.add(chunkLoader);
        playerInfo.shouldUpdateImmediately = true;
    }

    public static void removePerPlayerAdditionalChunkLoader(class_3222 player, ChunkLoader chunkLoader) {
        ArrayList<ChunkLoader> chunkLoaderList = ImmPtlChunkTracking.getPlayerInfo((class_3222)player).additionalChunkLoaders;
        chunkLoaderList.removeIf(c -> c == chunkLoader);
    }

    public static Set<class_5321<class_1937>> getVisibleDimensions(class_3222 player) {
        return ImmPtlChunkTracking.getPlayerInfo((class_3222)player).visibleDimensions;
    }

    public static void syncBlockUpdateToClientImmediately(class_3218 world, IntBox box) {
        class_1923 lowPos = new class_1923(box.l);
        class_1923 highPos = new class_1923(box.h);
        HashSet<class_3222> playersViewingRegion = new HashSet<class_3222>();
        class_5321 dimension = world.method_27983();
        for (int x = lowPos.field_9181; x <= highPos.field_9181; ++x) {
            for (int z = lowPos.field_9180; z <= highPos.field_9180; ++z) {
                Object2ObjectOpenHashMap<class_3222, PlayerWatchRecord> rec = ImmPtlChunkTracking.getWatchRecordForChunk((class_5321<class_1937>)dimension, x, z);
                if (rec == null) continue;
                for (PlayerWatchRecord r : rec.values()) {
                    if (!r.isValid || r.isLoadedToPlayer) continue;
                    playersViewingRegion.add(r.player);
                }
            }
        }
        for (class_3222 player : playersViewingRegion) {
            ImmPtlChunkTracking.getPlayerInfo(player).doChunkSending(player);
        }
        IEChunkMap chunkMap = (IEChunkMap)world.method_14178().field_17254;
        for (int x = lowPos.field_9181; x <= highPos.field_9181; ++x) {
            for (int z = lowPos.field_9180; z <= highPos.field_9180; ++z) {
                class_2818 tickingChunk;
                long chunkPosLong = class_1923.method_8331((int)x, (int)z);
                class_3193 chunkHolder = chunkMap.ip_getChunkHolder(chunkPosLong);
                if (chunkHolder == null || (tickingChunk = chunkHolder.method_16144()) == null) continue;
                chunkHolder.method_14006(tickingChunk);
            }
        }
    }

    public static class PlayerWatchRecord {
        public final class_3222 player;
        public final class_5321<class_1937> dimension;
        public final long chunkPos;
        public int lastWatchGeneration;
        public int distanceToSource;
        public boolean isLoadedToPlayer;
        public boolean isValid = true;
        public boolean isBoundary = false;

        public PlayerWatchRecord(class_3222 player, class_5321<class_1937> dimension, long chunkPos, int lastWatchGeneration, int distanceToSource, boolean isLoadedToPlayer, boolean isBoundary) {
            this.player = player;
            this.dimension = dimension;
            this.chunkPos = chunkPos;
            this.lastWatchGeneration = lastWatchGeneration;
            this.distanceToSource = distanceToSource;
            this.isLoadedToPlayer = isLoadedToPlayer;
            this.isBoundary = isBoundary;
        }

        public String toString() {
            return String.format("%s (%d,%d) distance:%d valid:%s loaded:%s", this.dimension.method_29177(), class_1923.method_8325((long)this.chunkPos), class_1923.method_8332((long)this.chunkPos), this.distanceToSource, this.isValid, this.isLoadedToPlayer);
        }
    }

    public static class RemoteCallables {
        public static void acceptClientPerformanceInfo(class_3222 player, PerformanceLevel performanceLevel) {
            PlayerChunkLoading playerInfo = ImmPtlChunkTracking.getPlayerInfo(player);
            playerInfo.performanceLevel = performanceLevel;
        }
    }
}

