/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.chunk_loading;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2672;
import net.minecraft.class_2818;
import net.minecraft.class_3193;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3532;
import net.minecraft.class_3898;
import net.minecraft.class_5321;
import net.minecraft.class_8738;
import net.minecraft.class_8739;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.mutable.MutableInt;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.chunk_loading.ChunkLoader;
import qouteall.imm_ptl.core.chunk_loading.ImmPtlChunkTracking;
import qouteall.imm_ptl.core.chunk_loading.PerformanceLevel;
import qouteall.imm_ptl.core.ducks.IEChunkMap;
import qouteall.imm_ptl.core.miscellaneous.IPVanillaCopy;
import qouteall.imm_ptl.core.network.PacketRedirection;
import qouteall.q_misc_util.Helper;

public class PlayerChunkLoading {
    private static final Logger LOGGER = LogUtils.getLogger();
    public final Set<class_5321<class_1937>> visibleDimensions = new ObjectOpenHashSet();
    public final ArrayList<ChunkLoader> additionalChunkLoaders = new ArrayList();
    public final ArrayList<ObjectArrayList<ImmPtlChunkTracking.PlayerWatchRecord>> distanceToPendingChunks = new ArrayList();
    public int loadedChunks = 0;
    public boolean shouldUpdateImmediately = false;
    public PerformanceLevel performanceLevel = PerformanceLevel.bad;
    public final boolean isMemoryConnection;
    private float desiredChunksPerTick = 9.0f;
    private float batchQuota;
    private int unacknowledgedBatches;
    private int maxUnacknowledgedBatches = 1;

    public PlayerChunkLoading(boolean isMemoryConnection) {
        this.isMemoryConnection = isMemoryConnection;
    }

    public void markPendingLoading(ImmPtlChunkTracking.PlayerWatchRecord record) {
        Helper.arrayListComputeIfAbsent(this.distanceToPendingChunks, record.distanceToSource, ObjectArrayList::new).add((Object)record);
    }

    @IPVanillaCopy
    public void doChunkSending(class_3222 serverPlayer) {
        if (this.unacknowledgedBatches >= this.maxUnacknowledgedBatches) {
            return;
        }
        if (this.isMemoryConnection) {
            this.batchQuota = 256.0f;
        } else {
            this.batchQuota = Math.min(this.batchQuota + this.desiredChunksPerTick, Math.max(1.0f, this.desiredChunksPerTick));
            if (this.batchQuota < 1.0f) {
                return;
            }
        }
        class_3244 connection = serverPlayer.field_13987;
        MinecraftServer server = serverPlayer.field_13995;
        int maxSendNum = (int)Math.floor(this.batchQuota);
        Validate.isTrue((maxSendNum != 0 ? 1 : 0) != 0);
        MutableInt sentNum = new MutableInt(0);
        for (ObjectArrayList<ImmPtlChunkTracking.PlayerWatchRecord> recs : this.distanceToPendingChunks) {
            if (recs == null || recs.isEmpty()) continue;
            if (sentNum.getValue() >= maxSendNum) break;
            Helper.removeIfWithEarlyExit(recs, (record, shouldStop) -> {
                if (!record.isValid) {
                    return true;
                }
                if (record.isLoadedToPlayer) {
                    return true;
                }
                class_3218 world = server.method_3847(record.dimension);
                if (world == null) {
                    LOGGER.error("Missing dimension when flushing pending loading {}", (Object)record.dimension.method_29177());
                    return true;
                }
                class_3898 chunkMap = world.method_14178().field_17254;
                class_3193 chunkHolder = ((IEChunkMap)chunkMap).ip_getChunkHolder(record.chunkPos);
                if (chunkHolder == null) {
                    return false;
                }
                class_2818 tickingChunk = chunkHolder.method_16144();
                if (tickingChunk == null) {
                    return false;
                }
                record.isLoadedToPlayer = true;
                if (sentNum.getValue() == 0) {
                    ++this.unacknowledgedBatches;
                    connection.method_14364((class_2596)new class_8739());
                }
                sentNum.increment();
                PlayerChunkLoading.sendChunkPacket(connection, world, tickingChunk);
                if (sentNum.getValue() >= maxSendNum) {
                    shouldStop.setValue(true);
                }
                return true;
            });
        }
        if (sentNum.getValue() != 0) {
            connection.method_14364((class_2596)new class_8738(sentNum.getValue().intValue()));
        }
        this.batchQuota -= (float)sentNum.getValue().intValue();
    }

    @IPVanillaCopy
    private static void sendChunkPacket(class_3244 serverGamePacketListenerImpl, class_3218 serverLevel, class_2818 levelChunk) {
        serverGamePacketListenerImpl.method_14364(PacketRedirection.createRedirectedMessage(serverLevel.method_8503(), (class_5321<class_1937>)serverLevel.method_27983(), (class_2596<class_2602>)new class_2672(levelChunk, serverLevel.method_22336(), null, null)));
    }

    @IPVanillaCopy
    public void onChunkBatchReceivedByClient(float clientDesiredChunkPerTick) {
        --this.unacknowledgedBatches;
        float f = this.desiredChunksPerTick = Double.isNaN(clientDesiredChunkPerTick) ? 0.01f : class_3532.method_15363((float)clientDesiredChunkPerTick, (float)0.01f, (float)64.0f);
        if (this.unacknowledgedBatches == 0) {
            this.batchQuota = 1.0f;
        }
        this.maxUnacknowledgedBatches = 10;
    }
}

