/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.collision;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2784;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.compat.PehkuiInterface;
import qouteall.imm_ptl.core.ducks.IEEntity;
import qouteall.imm_ptl.core.miscellaneous.IPVanillaCopy;
import qouteall.imm_ptl.core.mixin.common.collision.IEEntity_Collision;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalLike;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorage;
import qouteall.imm_ptl.core.render.PortalGroup;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.my_util.LimitedLogger;

public class CollisionHelper {
    private static final LimitedLogger limitedLogger = new LimitedLogger(20);
    private static boolean thisTickStagnate = false;
    private static boolean lastTickStagnate = false;

    @Nullable
    public static class_238 clipBox(class_238 box, class_243 planePos, class_243 planeNormal) {
        boolean isPushedPosInFrontOfPlane;
        boolean xForward = planeNormal.field_1352 > 0.0;
        boolean yForward = planeNormal.field_1351 > 0.0;
        boolean zForward = planeNormal.field_1350 > 0.0;
        class_243 pushedPos = new class_243(xForward ? box.field_1323 : box.field_1320, yForward ? box.field_1322 : box.field_1325, zForward ? box.field_1321 : box.field_1324);
        class_243 staticPos = new class_243(xForward ? box.field_1320 : box.field_1323, yForward ? box.field_1325 : box.field_1322, zForward ? box.field_1324 : box.field_1321);
        double tOfPushedPos = Helper.getCollidingT(planePos, planeNormal, pushedPos, planeNormal);
        boolean bl = isPushedPosInFrontOfPlane = tOfPushedPos < 0.0;
        if (isPushedPosInFrontOfPlane) {
            return box;
        }
        boolean isStaticPosInFrontOfPlane = Helper.isInFrontOfPlane(staticPos, planePos, planeNormal);
        if (!isStaticPosInFrontOfPlane) {
            return null;
        }
        class_243 afterBeingPushed = pushedPos.method_1019(planeNormal.method_1021(tOfPushedPos));
        return new class_238(afterBeingPushed, staticPos);
    }

    public static boolean isBoxFullyBehindPlane(class_243 planePos, class_243 planeNormal, class_238 box) {
        boolean xForward = planeNormal.field_1352 > 0.0;
        boolean yForward = planeNormal.field_1351 > 0.0;
        boolean zForward = planeNormal.field_1350 > 0.0;
        class_243 testingPos = new class_243(xForward ? box.field_1320 : box.field_1323, yForward ? box.field_1325 : box.field_1322, zForward ? box.field_1324 : box.field_1321);
        return testingPos.method_1020(planePos).method_1026(planeNormal) < 0.0;
    }

    public static boolean canCollideWithPortal(class_1297 entity, Portal portal, float partialTick) {
        return CollisionHelper.mayEntityCollideWithPortal(entity, portal, entity.method_5836(partialTick), entity.method_5829());
    }

    public static boolean mayEntityCollideWithPortal(class_1297 entity, Portal portal, class_243 entityEyePos, class_238 entityBoundingBox) {
        if (!portal.canCollideWithEntity(entity)) {
            return false;
        }
        return portal.getPortalShape().canCollideWith(portal, portal.getThisSideState(), entityEyePos, entityBoundingBox);
    }

    public static double absMin(double a, double b) {
        return Math.abs(a) < Math.abs(b) ? a : b;
    }

    public static double fixCoordinateFloatingPointError(double attemptedMove, double result) {
        if (Math.abs(attemptedMove - result) < 0.001) {
            return attemptedMove;
        }
        if (Math.abs(result) < 1.0E-4) {
            return 0.0;
        }
        return result;
    }

    @Nullable
    public static class_265 clipVoxelShape(class_265 shape, class_243 clippingPlanePos, class_243 clippingPlaneNormal) {
        if (shape.method_1110()) {
            return null;
        }
        class_238 shapeBoundingBox = shape.method_1107();
        boolean boxBehindPlane = CollisionHelper.isBoxFullyBehindPlane(clippingPlanePos, clippingPlaneNormal, shapeBoundingBox);
        if (boxBehindPlane) {
            return null;
        }
        boolean isFullyInFrontOfPlane = CollisionHelper.isBoxFullyBehindPlane(clippingPlanePos, clippingPlaneNormal.method_1021(-1.0), shapeBoundingBox);
        if (isFullyInFrontOfPlane) {
            return shape;
        }
        class_238 clippedBoundingBox = CollisionHelper.clipBox(shapeBoundingBox, clippingPlanePos, clippingPlaneNormal);
        if (clippedBoundingBox == null) {
            return null;
        }
        class_265 result = class_259.method_1082((class_265)shape, (class_265)class_259.method_1078((class_238)clippedBoundingBox), (class_247)class_247.field_16896);
        return result;
    }

    private static class_243 refHandleCollisionWithShapeProcessor(class_1297 entity, class_243 attemptedMove, Function<class_265, class_265> filter) {
        class_238 boundingBox = entity.method_5829();
        List entityCollisions = entity.method_37908().method_20743(entity, boundingBox.method_18804(attemptedMove));
        BiFunction<class_243, class_238, class_243> collisionFunc = (attempt, bb) -> CollisionHelper.collideBoundingBox(entity, attempt, bb, entity.method_37908(), entityCollisions, filter);
        class_243 collidedMovement = attemptedMove.method_1027() == 0.0 ? attemptedMove : collisionFunc.apply(attemptedMove, boundingBox);
        boolean collideX = attemptedMove.field_1352 != collidedMovement.field_1352;
        boolean collideY = attemptedMove.field_1351 != collidedMovement.field_1351;
        boolean collideZ = attemptedMove.field_1350 != collidedMovement.field_1350;
        boolean collidesWithFloor = collideY && attemptedMove.field_1351 < 0.0;
        boolean touchGround = entity.method_24828() || collidesWithFloor;
        boolean collidesHorizontally = collideX || collideZ;
        float maxUpStep = entity.method_49476();
        if (maxUpStep > 0.0f && touchGround && collidesHorizontally) {
            class_243 horizontalMoveAfterVerticalStepping;
            class_243 stepping = collisionFunc.apply(new class_243(attemptedMove.field_1352, (double)maxUpStep, attemptedMove.field_1350), boundingBox);
            class_243 verticalStep = collisionFunc.apply(new class_243(0.0, (double)maxUpStep, 0.0), boundingBox.method_1012(attemptedMove.field_1352, 0.0, attemptedMove.field_1350));
            if (verticalStep.field_1351 < (double)maxUpStep && (horizontalMoveAfterVerticalStepping = collisionFunc.apply(new class_243(attemptedMove.field_1352, 0.0, attemptedMove.field_1350), boundingBox.method_997(verticalStep)).method_1019(verticalStep)).method_37268() > stepping.method_37268()) {
                stepping = horizontalMoveAfterVerticalStepping;
            }
            if (stepping.method_37268() > collidedMovement.method_37268()) {
                class_243 movingDown = collisionFunc.apply(new class_243(0.0, -stepping.field_1351 + attemptedMove.field_1351, 0.0), boundingBox.method_997(stepping));
                return stepping.method_1019(movingDown);
            }
        }
        return collidedMovement;
    }

    @IPVanillaCopy
    public static class_243 handleCollisionWithShapeProcessor(class_1297 entity, class_238 boundingBox, class_1937 world, class_243 attemptedMove, Function<class_265, class_265> filter, class_2350 gravity, double steppingScale) {
        class_2350 jumpDirection = gravity.method_10153();
        class_2350.class_2351 gravityAxis = gravity.method_10166();
        List entityCollisions = world.method_20743(entity, boundingBox.method_18804(attemptedMove));
        BiFunction<class_243, class_238, class_243> collisionFunc = (attempt, bb) -> CollisionHelper.collideBoundingBox(entity, attempt, bb, world, entityCollisions, filter);
        class_243 collidedMovement = attemptedMove.method_1027() == 0.0 ? attemptedMove : collisionFunc.apply(attemptedMove, boundingBox);
        class_243 collisionDelta = attemptedMove.method_1020(collidedMovement);
        boolean collidesOnGravityAxis = Helper.getCoordinate(collisionDelta, gravityAxis) != 0.0;
        boolean attemptToMoveAlongGravity = Helper.getSignedCoordinate(attemptedMove, gravity) > 0.0;
        boolean collidesWithFloor = collidesOnGravityAxis && attemptToMoveAlongGravity;
        boolean touchGround = entity.method_24828() || collidesWithFloor;
        boolean collidesHorizontally = CollisionHelper.movesOnNonGravityAxis(collisionDelta, gravityAxis);
        float maxUpStep = entity.method_49476() * PehkuiInterface.invoker.getBaseScale(entity);
        if (steppingScale > 1.0) {
            maxUpStep = (float)((double)maxUpStep * steppingScale);
        }
        if (maxUpStep > 0.0f && touchGround && collidesHorizontally) {
            class_243 horizontalMoveAfterVerticalStepping;
            class_243 stepping = collisionFunc.apply(Helper.putSignedCoordinate(attemptedMove, jumpDirection, maxUpStep), boundingBox);
            class_243 expandVec = Helper.putSignedCoordinate(attemptedMove, gravity, 0.0);
            class_243 verticalStep = collisionFunc.apply(Helper.putSignedCoordinate(class_243.field_1353, jumpDirection, maxUpStep), boundingBox.method_18804(expandVec));
            if (Helper.getSignedCoordinate(verticalStep, jumpDirection) < (double)maxUpStep + 0.001 && Helper.getDistanceSqrOnAxisPlane(horizontalMoveAfterVerticalStepping = collisionFunc.apply(expandVec, boundingBox.method_997(verticalStep)).method_1019(verticalStep), gravityAxis) > Helper.getDistanceSqrOnAxisPlane(stepping, gravityAxis)) {
                stepping = horizontalMoveAfterVerticalStepping;
            }
            if (Helper.getDistanceSqrOnAxisPlane(stepping, gravityAxis) > Helper.getDistanceSqrOnAxisPlane(collidedMovement, gravityAxis)) {
                double steppingVerticalLen = Helper.getSignedCoordinate(stepping, jumpDirection);
                double attemptMoveVerticalLen = Helper.getSignedCoordinate(attemptedMove, jumpDirection);
                class_243 movingDown = collisionFunc.apply(Helper.putSignedCoordinate(class_243.field_1353, jumpDirection, -steppingVerticalLen + attemptMoveVerticalLen), boundingBox.method_997(stepping));
                return stepping.method_1019(movingDown);
            }
        }
        return collidedMovement;
    }

    public static boolean movesOnNonGravityAxis(class_243 vec, class_2350.class_2351 gravityAxis) {
        return switch (gravityAxis) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.class_2351.field_11048 -> {
                if (vec.field_1351 != 0.0 || vec.field_1350 != 0.0) {
                    yield true;
                }
                yield false;
            }
            case class_2350.class_2351.field_11052 -> {
                if (vec.field_1352 != 0.0 || vec.field_1350 != 0.0) {
                    yield true;
                }
                yield false;
            }
            case class_2350.class_2351.field_11051 -> vec.field_1352 != 0.0 || vec.field_1351 != 0.0;
        };
    }

    @IPVanillaCopy
    public static class_243 collideBoundingBox(class_1297 entity, class_243 vec, class_238 collisionBox, class_1937 level, List<class_265> potentialHits, Function<class_265, class_265> shapeProcessor) {
        boolean addWorldBorderCollision;
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(potentialHits.size() + 1));
        for (class_265 potentialHit : potentialHits) {
            class_265 processed = shapeProcessor.apply(potentialHit);
            if (processed == null) continue;
            builder.add((Object)processed);
        }
        class_2784 worldBorder = level.method_8621();
        class_243 boundingBoxCenter = collisionBox.method_1005();
        boolean bl = addWorldBorderCollision = worldBorder.method_35317(boundingBoxCenter.field_1352, boundingBoxCenter.field_1350) && worldBorder.method_11961(boundingBoxCenter.field_1352, boundingBoxCenter.field_1350) < 32.0;
        if (addWorldBorderCollision) {
            builder.add((Object)worldBorder.method_17903());
        }
        Iterable blockCollisions = level.method_20812(entity, collisionBox.method_18804(vec));
        for (class_265 blockCollision : blockCollisions) {
            class_265 processed = shapeProcessor.apply(blockCollision);
            if (processed == null) continue;
            builder.add((Object)processed);
        }
        return IEEntity_Collision.ip_CollideWithShapes(vec, collisionBox, (List<class_265>)builder.build());
    }

    public static class_238 transformBox(PortalLike portal, class_238 originalBox) {
        if (portal.getRotation() == null && portal.getScale() == 1.0) {
            return originalBox.method_997(portal.getDestPos().method_1020(portal.getOriginPos()));
        }
        return Helper.transformBox(originalBox, portal::transformPoint);
    }

    @Deprecated
    public static class_1937 getWorld(boolean isClient, class_5321<class_1937> dimension) {
        if (isClient) {
            return CHelper.getClientWorld(dimension);
        }
        return MiscHelper.getServer().method_3847(dimension);
    }

    public static boolean isCollidingWithAnyPortal(class_1297 entity) {
        return ((IEEntity)entity).ip_getCollidingPortal() != null;
    }

    public static void updateCollidingPortalForWorld(class_1937 world, float tickDelta) {
        world.method_16107().method_15396("update_colliding_portal");
        List<Portal> globalPortals = GlobalPortalStorage.getGlobalPortals(world);
        Iterable<class_1297> worldEntityList = McHelper.getWorldEntityList(world);
        for (class_1297 entity : worldEntityList) {
            if (entity instanceof Portal) {
                Portal portal = (Portal)entity;
                CollisionHelper.notifyCollidingPortals(portal, tickDelta);
                continue;
            }
            class_238 entityBoundingBoxStretched = CollisionHelper.getStretchedBoundingBox(entity);
            for (Portal globalPortal : globalPortals) {
                class_238 globalPortalBoundingBox = globalPortal.method_5829();
                if (!entityBoundingBoxStretched.method_994(globalPortalBoundingBox) || !CollisionHelper.canCollideWithPortal(entity, globalPortal, tickDelta)) continue;
                ((IEEntity)entity).ip_notifyCollidingWithPortal(globalPortal);
            }
        }
        world.method_16107().method_15407();
    }

    public static void init() {
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            for (class_3218 world : server.method_3738()) {
                CollisionHelper.updateCollidingPortalForWorld((class_1937)world, 0.0f);
            }
        });
    }

    @Environment(value=EnvType.CLIENT)
    public static void initClient() {
        IPGlobal.POST_CLIENT_TICK_EVENT.register(CollisionHelper::tickClient);
    }

    @Environment(value=EnvType.CLIENT)
    public static void tickClient() {
        CollisionHelper.updateClientCollidingStatus();
        CollisionHelper.updateClientStagnateStatus();
    }

    @Environment(value=EnvType.CLIENT)
    private static void updateClientCollidingStatus() {
        if (ClientWorldLoader.getIsInitialized()) {
            for (class_638 world : ClientWorldLoader.getClientWorlds()) {
                CollisionHelper.updateCollidingPortalForWorld((class_1937)world, 0.0f);
            }
        }
    }

    public static void notifyCollidingPortals(Portal portal, float partialTick) {
        if (!portal.isTeleportable()) {
            return;
        }
        class_238 portalBoundingBox = portal.method_5829();
        McHelper.foreachEntitiesByBoxApproximateRegions(class_1297.class, portal.method_37908(), portalBoundingBox, 8.0, entity -> {
            if (entity instanceof Portal) {
                return;
            }
            class_238 entityBoxStretched = CollisionHelper.getStretchedBoundingBox(entity);
            if (!entityBoxStretched.method_994(portalBoundingBox)) {
                return;
            }
            boolean canCollideWithPortal = CollisionHelper.canCollideWithPortal(entity, portal, partialTick);
            if (!canCollideWithPortal) {
                return;
            }
            ((IEEntity)entity).ip_notifyCollidingWithPortal(portal);
        });
    }

    public static class_238 getStretchedBoundingBox(class_1297 entity) {
        class_243 backwardExpand = McHelper.lastTickPosOf(entity).method_1020(entity.method_19538());
        class_243 forwardExpand = McHelper.getWorldVelocity(entity);
        class_238 box = entity.method_5829().method_18804(forwardExpand.method_1021(1.2)).method_18804(backwardExpand);
        float scale = PehkuiInterface.invoker.getBaseScale(entity);
        if (scale > 4.0f) {
            box = box.method_1014((double)scale);
        }
        return box;
    }

    @Environment(value=EnvType.CLIENT)
    public static void informClientStagnant() {
        thisTickStagnate = true;
        limitedLogger.log("client movement stagnated");
    }

    @Environment(value=EnvType.CLIENT)
    private static void updateClientStagnateStatus() {
        if (thisTickStagnate && lastTickStagnate) {
            class_310.method_1551().field_1705.method_1758((class_2561)class_2561.method_43471((String)"imm_ptl.stagnate_movement"), false);
        } else if (!thisTickStagnate && lastTickStagnate) {
            class_310.method_1551().field_1705.method_1758((class_2561)class_2561.method_43470((String)""), false);
        }
        lastTickStagnate = thisTickStagnate;
        thisTickStagnate = false;
    }

    public static PortalLike getCollisionHandlingUnit(Portal portal) {
        if (portal.getIsGlobal()) {
            return portal;
        }
        if (portal.method_37908().method_8608()) {
            return CollisionHelper.getCollisionHandlingUnitClient(portal);
        }
        return portal;
    }

    @Environment(value=EnvType.CLIENT)
    public static PortalLike getCollisionHandlingUnitClient(Portal portal) {
        return PortalGroup.getPortalUnit(portal);
    }

    @Nullable
    public static class_238 getTotalBlockCollisionBox(class_1297 entity, class_238 box, Function<class_265, class_265> shapeFilter) {
        Iterable collisions = entity.method_37908().method_20812(entity, box);
        class_238 collisionUnion = null;
        for (class_265 c : collisions) {
            class_265 currCollision = shapeFilter.apply(c);
            if (currCollision == null || currCollision.method_1110()) continue;
            class_238 collisionBoundingBox = currCollision.method_1107();
            if (collisionUnion == null) {
                collisionUnion = collisionBoundingBox;
                continue;
            }
            collisionUnion = collisionUnion.method_991(collisionBoundingBox);
        }
        return collisionUnion;
    }
}

