/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.collision;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.collision.CollisionHelper;
import qouteall.imm_ptl.core.collision.PortalCollisionEntry;
import qouteall.imm_ptl.core.compat.GravityChangerInterface;
import qouteall.imm_ptl.core.ducks.IEEntity;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalLike;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.Plane;
import qouteall.q_misc_util.my_util.Range;

public class PortalCollisionHandler {
    private static final int maxCollidingPortals = 6;
    public long lastActiveTime;
    public final List<PortalCollisionEntry> portalCollisions = new ArrayList<PortalCollisionEntry>();

    public boolean isRecentlyCollidingWithPortal(class_1297 entity) {
        return (long)PortalCollisionHandler.getTiming(entity) - this.lastActiveTime < 20L;
    }

    public void update(class_1297 entity) {
        this.portalCollisions.removeIf(p -> {
            if (p.portal.method_37908() != entity.method_37908()) {
                return true;
            }
            class_238 stretchedBoundingBox = CollisionHelper.getStretchedBoundingBox(entity);
            if (!stretchedBoundingBox.method_1014(0.5).method_994(p.portal.method_5829())) {
                return true;
            }
            if (Math.abs((long)PortalCollisionHandler.getTiming(entity) - p.activeTime) >= 3L) {
                return true;
            }
            return !CollisionHelper.mayEntityCollideWithPortal(entity, p.portal, entity.method_5836(0.0f), entity.method_5829());
        });
    }

    private static int getTiming(class_1297 entity) {
        return entity.field_6012;
    }

    public class_243 handleCollision(class_1297 entity, class_243 attemptedMove) {
        if (this.portalCollisions.isEmpty()) {
            return attemptedMove;
        }
        entity.method_37908().method_16107().method_15396("cross_portal_collision");
        this.portalCollisions.sort(Comparator.comparingLong(p -> p.activeTime).reversed());
        class_243 result = PortalCollisionHandler.doHandleCollision(entity, attemptedMove, 1, this.portalCollisions, entity.method_5829());
        entity.method_37908().method_16107().method_15407();
        return result;
    }

    private static class_243 doHandleCollision(class_1297 entity, class_243 attemptedMove, int portalLayer, List<PortalCollisionEntry> portalCollisions, class_238 originalBoundingBox) {
        class_243 currentMove = attemptedMove;
        currentMove = PortalCollisionHandler.handleThisSideMove(entity, currentMove, originalBoundingBox, portalCollisions);
        for (PortalCollisionEntry portalCollision : portalCollisions) {
            Portal portal = portalCollision.portal;
            class_243 eyePos = entity.method_5836(0.0f);
            currentMove = PortalCollisionHandler.handleOtherSideMove(entity, currentMove, portal, originalBoundingBox, portal.transformPoint(eyePos), portalLayer);
        }
        class_243 r = new class_243(CollisionHelper.fixCoordinateFloatingPointError(attemptedMove.field_1352, currentMove.field_1352), CollisionHelper.fixCoordinateFloatingPointError(attemptedMove.field_1351, currentMove.field_1351), CollisionHelper.fixCoordinateFloatingPointError(attemptedMove.field_1350, currentMove.field_1350));
        return r;
    }

    private static class_243 handleOtherSideMove(class_1297 entity, class_243 attemptedMove, Portal collidingPortal, class_238 originalBoundingBox, class_243 transformedEyePos, int portalLayer) {
        if (!collidingPortal.getHasCrossPortalCollision()) {
            return attemptedMove;
        }
        if (portalLayer >= 5) {
            return attemptedMove;
        }
        class_243 transformedAttemptedMove = collidingPortal.transformLocalVec(attemptedMove);
        class_238 boxOtherSide = CollisionHelper.transformBox(collidingPortal, originalBoundingBox);
        if (boxOtherSide == null) {
            return attemptedMove;
        }
        if (PortalCollisionHandler.isBoxTooBig(boxOtherSide)) {
            return attemptedMove;
        }
        class_1937 destinationWorld = collidingPortal.getDestWorld();
        if (!destinationWorld.method_22340(class_2338.method_49638((class_2374)boxOtherSide.method_1005()))) {
            if (portalLayer <= 1) {
                return PortalCollisionHandler.handleOtherSideChunkNotLoaded(entity, attemptedMove, collidingPortal, originalBoundingBox);
            }
            return attemptedMove;
        }
        List<Portal> indirectCollidingPortals = McHelper.findEntitiesByBox(Portal.class, collidingPortal.getDestinationWorld(), boxOtherSide.method_18804(transformedAttemptedMove), IPGlobal.maxNormalPortalRadius, p -> CollisionHelper.mayEntityCollideWithPortal(entity, p, transformedEyePos, boxOtherSide) && collidingPortal.isOnDestinationSide(p.getOriginPos(), 0.1));
        PortalLike collisionHandlingUnit = CollisionHelper.getCollisionHandlingUnit(collidingPortal);
        class_2350 transformedGravityDirection = collidingPortal.getTransformedGravityDirection(GravityChangerInterface.invoker.getGravityDirection(entity));
        Plane innerClipping = collidingPortal.getInnerClipping();
        class_243 collided = transformedAttemptedMove;
        collided = CollisionHelper.handleCollisionWithShapeProcessor(entity, boxOtherSide, destinationWorld, collided, shape -> {
            class_265 current;
            class_265 class_2652 = current = innerClipping == null ? shape : CollisionHelper.clipVoxelShape(shape, innerClipping.pos(), innerClipping.normal());
            if (current == null) {
                return null;
            }
            if (!indirectCollidingPortals.isEmpty()) {
                current = PortalCollisionHandler.processThisSideCollisionShape(current, indirectCollidingPortals);
            }
            return current;
        }, transformedGravityDirection, collidingPortal.getScale());
        if (!indirectCollidingPortals.isEmpty()) {
            for (Portal indirectCollidingPortal : indirectCollidingPortals) {
                collided = PortalCollisionHandler.handleOtherSideMove(entity, collided, indirectCollidingPortal, boxOtherSide, collidingPortal.transformPoint(transformedEyePos), portalLayer + 1);
            }
        }
        collided = new class_243(CollisionHelper.fixCoordinateFloatingPointError(transformedAttemptedMove.field_1352, collided.field_1352), CollisionHelper.fixCoordinateFloatingPointError(transformedAttemptedMove.field_1351, collided.field_1351), CollisionHelper.fixCoordinateFloatingPointError(transformedAttemptedMove.field_1350, collided.field_1350));
        class_243 result = collidingPortal.inverseTransformLocalVec(collided);
        return result;
    }

    private static class_243 handleOtherSideChunkNotLoaded(class_1297 entity, class_243 attemptedMove, Portal collidingPortal, class_238 originalBoundingBox) {
        if (entity instanceof class_1657 && entity.method_37908().method_8608()) {
            CollisionHelper.informClientStagnant();
        }
        return collidingPortal.getPortalShape().getMovementForPushingEntityOutOfPortal(collidingPortal, collidingPortal.getThisSideState(), entity, attemptedMove);
    }

    private static class_243 handleThisSideMove(class_1297 entity, class_243 attemptedMove, class_238 originalBoundingBox, List<PortalCollisionEntry> portalCollisions) {
        class_2350 gravity = GravityChangerInterface.invoker.getGravityDirection(entity);
        return CollisionHelper.handleCollisionWithShapeProcessor(entity, entity.method_5829(), entity.method_37908(), attemptedMove, shape -> PortalCollisionHandler.processThisSideCollisionShape(shape, Helper.mappedListView(portalCollisions, e -> e.portal)), gravity, 1.0);
    }

    @Nullable
    private static class_265 processThisSideCollisionShape(class_265 originalShape, List<Portal> portalCollisions) {
        class_265 shape = originalShape;
        if (shape.method_1110()) {
            return shape;
        }
        class_238 shapeBounds = shape.method_1107();
        for (int i = 0; i < portalCollisions.size(); ++i) {
            class_265 exclusion;
            boolean boxFullyBehindPlane;
            Portal portal = portalCollisions.get(i);
            Plane clipping = portal.getPortalShape().getOuterClipping(portal.getThisSideState());
            if (clipping != null && !(boxFullyBehindPlane = CollisionHelper.isBoxFullyBehindPlane(clipping.pos(), clipping.normal(), shapeBounds)) || (exclusion = portal.getThisSideCollisionExclusion()) == null || exclusion.method_1110()) continue;
            if (Helper.boxContains(exclusion.method_1107(), shapeBounds)) {
                return null;
            }
            if ((shape = class_259.method_1082((class_265)shape, (class_265)exclusion, (class_247)class_247.field_16886)).method_1110()) {
                return shape;
            }
            shapeBounds = shape.method_1107();
        }
        return shape;
    }

    @Nullable
    public class_238 getActiveCollisionBox(class_1297 entity, class_238 rawBoundingBox) {
        class_238 currentBox = rawBoundingBox;
        for (PortalCollisionEntry portalCollision : this.portalCollisions) {
            Portal portal = portalCollision.portal;
            class_238 newBox = portal.getPortalShape().transformEntityActiveCollisionBox(portal, currentBox, entity);
            if (newBox == null) {
                return null;
            }
            currentBox = newBox;
        }
        return currentBox;
    }

    public static void updateCollidingPortalAfterTeleportation(class_1297 entity, class_243 newEyePos, class_243 newLastTickEyePos, float partialTicks) {
        ((IEEntity)entity).ip_clearCollidingPortal();
        McHelper.findEntitiesByBox(Portal.class, entity.method_37908(), CollisionHelper.getStretchedBoundingBox(entity), IPGlobal.maxNormalPortalRadius, p -> true).forEach(p -> CollisionHelper.notifyCollidingPortals(p, partialTicks));
        McHelper.setEyePos(entity, newEyePos, newLastTickEyePos);
        McHelper.updateBoundingBox(entity);
    }

    public boolean hasCollisionEntry() {
        return !this.portalCollisions.isEmpty();
    }

    public void notifyCollidingWithPortal(class_1297 entity, Portal portal) {
        if (this.portalCollisions.size() >= 6) {
            return;
        }
        long timing = PortalCollisionHandler.getTiming(entity);
        int i = Helper.indexOf(this.portalCollisions, p -> p.portal == portal);
        if (i == -1) {
            this.portalCollisions.add(new PortalCollisionEntry(portal, timing));
        } else {
            this.portalCollisions.get((int)i).activeTime = timing;
        }
        portal.onCollidingWithEntity(entity);
        this.lastActiveTime = timing;
    }

    public List<Portal> getCollidingPortals() {
        return Helper.mappedListView(this.portalCollisions, p -> p.portal);
    }

    public static class_243 getOffsetForPushingBoxOutOfAABB(class_238 boxToPush, class_238 portalBox) {
        double mx = Range.getPushRangeMovement(boxToPush.field_1323, boxToPush.field_1320, portalBox.field_1323, portalBox.field_1320);
        double my = Range.getPushRangeMovement(boxToPush.field_1322, boxToPush.field_1325, portalBox.field_1322, portalBox.field_1325);
        double mz = Range.getPushRangeMovement(boxToPush.field_1321, boxToPush.field_1324, portalBox.field_1321, portalBox.field_1324);
        if (mx != 0.0) {
            return new class_243(mx, 0.0, 0.0);
        }
        if (my != 0.0) {
            return new class_243(0.0, my, 0.0);
        }
        if (mz != 0.0) {
            return new class_243(0.0, 0.0, mz);
        }
        return class_243.field_1353;
    }

    public static class_243 getOffsetForConfiningBoxInsideAABB(class_238 boxToPush, class_238 portalBox) {
        return new class_243(Range.getConfineRangeMovement(boxToPush.field_1323, boxToPush.field_1320, portalBox.field_1323, portalBox.field_1320), Range.getConfineRangeMovement(boxToPush.field_1322, boxToPush.field_1325, portalBox.field_1322, portalBox.field_1325), Range.getConfineRangeMovement(boxToPush.field_1321, boxToPush.field_1324, portalBox.field_1321, portalBox.field_1324));
    }

    @Nullable
    public static class_243 getOffsetForPushingBoxOutOfPlane(class_243 origin, class_243 normal, class_238 movedBoundingBox) {
        class_243 innerDirection = normal.method_1021(-1.0);
        double innerSignedDistance = Arrays.stream(Helper.eightVerticesOf(movedBoundingBox)).mapToDouble(pos -> pos.method_1020(origin).method_1026(normal)).min().orElseThrow();
        if (innerSignedDistance < 0.0) {
            return normal.method_1021(-innerSignedDistance);
        }
        return null;
    }

    @NotNull
    public static class_243 getMovementForPushingEntityOutOfPortal(class_243 attemptedMove, class_243 origin, class_243 normal, class_238 originalBoundingBox) {
        class_243 innerDirection = normal.method_1021(-1.0);
        double innerSignedDistance = Arrays.stream(Helper.eightVerticesOf(originalBoundingBox)).mapToDouble(pos -> pos.method_1020(origin).method_1026(normal)).min().orElseThrow();
        class_243 attemptedMoveProjectedToInnerDirection = innerDirection.method_1021(innerDirection.method_1026(attemptedMove));
        if (innerSignedDistance < 0.0) {
            return attemptedMove.method_1019(normal.method_1021(-innerSignedDistance)).method_1020(attemptedMoveProjectedToInnerDirection);
        }
        return attemptedMove.method_1020(attemptedMoveProjectedToInnerDirection);
    }

    private static boolean isBoxTooBig(class_238 aabb) {
        return aabb.method_17939() > 100.0 || aabb.method_17940() > 100.0 || aabb.method_17941() > 100.0;
    }
}

