/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.commands;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2277;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import qouteall.imm_ptl.core.commands.PortalCommand;
import qouteall.imm_ptl.core.commands.TimingFunctionArgumentType;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalExtension;
import qouteall.imm_ptl.core.portal.PortalState;
import qouteall.imm_ptl.core.portal.animation.AnimationView;
import qouteall.imm_ptl.core.portal.animation.DeltaUnilateralPortalState;
import qouteall.imm_ptl.core.portal.animation.NormalAnimation;
import qouteall.imm_ptl.core.portal.animation.PortalAnimation;
import qouteall.imm_ptl.core.portal.animation.PortalAnimationDriver;
import qouteall.imm_ptl.core.portal.animation.RotationAnimation;
import qouteall.imm_ptl.core.portal.animation.TimingFunction;
import qouteall.imm_ptl.core.portal.animation.UnilateralPortalState;
import qouteall.q_misc_util.my_util.Access;
import qouteall.q_misc_util.my_util.Vec2d;

public class PortalAnimationCommand {
    static void registerPortalAnimationCommands(LiteralArgumentBuilder<class_2168> builder) {
        builder.then(class_2170.method_9247((String)"clear").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> {
            AnimationView animationView = portal.getAnimationView();
            animationView.getThisSideAnimations().clear();
            PortalCommand.reloadPortal(portal);
            ((class_2168)context.getSource()).method_9226(() -> PortalAnimationCommand.getAnimationInfo(portal), false);
        })));
        builder.then(class_2170.method_9247((String)"clear_both_sides").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> {
            AnimationView animationView = portal.getAnimationView();
            animationView.getThisSideAnimations().clear();
            animationView.getOtherSideAnimations().clear();
            PortalCommand.reloadPortal(portal);
            ((class_2168)context.getSource()).method_9226(() -> PortalAnimationCommand.getAnimationInfo(portal), false);
        })));
        builder.then(class_2170.method_9247((String)"pause").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> {
            PortalExtension.forClusterPortals(portal, Portal::pauseAnimation);
            PortalCommand.reloadPortal(portal);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Paused"), false);
        })));
        builder.then(class_2170.method_9247((String)"resume").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> {
            PortalExtension.forClusterPortals(portal, Portal::resumeAnimation);
            PortalCommand.reloadPortal(portal);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Resumed"), false);
        })));
        builder.then(class_2170.method_9247((String)"all_pause").executes(context -> {
            class_3218 level = ((class_2168)context.getSource()).method_9225();
            for (class_1297 entity : level.method_27909()) {
                if (!(entity instanceof Portal)) continue;
                Portal portal = (Portal)entity;
                PortalExtension.forClusterPortals(portal, Portal::pauseAnimation);
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Paused " + portal.toString())), false);
            }
            return 0;
        }));
        builder.then(class_2170.method_9247((String)"view").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> ((class_2168)context.getSource()).method_9226(() -> PortalAnimationCommand.getAnimationInfo(portal), false))));
        builder.then(class_2170.method_9247((String)"remove_at").then(class_2170.method_9244((String)"index", (ArgumentType)IntegerArgumentType.integer()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> {
            int index = IntegerArgumentType.getInteger((CommandContext)context, (String)"index");
            AnimationView animationView = portal.getAnimationView();
            List<PortalAnimationDriver> thisSideAnimations = animationView.getThisSideAnimations();
            if (index >= 0 && index < thisSideAnimations.size()) {
                thisSideAnimations.remove(index);
                PortalCommand.reloadPortal(portal);
                ((class_2168)context.getSource()).method_9226(() -> PortalAnimationCommand.getAnimationInfo(portal), false);
            } else {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Invalid index " + index)));
            }
        }))));
        builder.then(class_2170.method_9247((String)"remove_last").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> {
            AnimationView animationView = portal.getAnimationView();
            List<PortalAnimationDriver> thisSideAnimations = animationView.getThisSideAnimations();
            if (!thisSideAnimations.isEmpty()) {
                thisSideAnimations.remove(thisSideAnimations.size() - 1);
                PortalCommand.reloadPortal(portal);
                ((class_2168)context.getSource()).method_9226(() -> PortalAnimationCommand.getAnimationInfo(portal), false);
            } else {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"No animation"));
            }
        })));
        builder.then(class_2170.method_9247((String)"rotate_infinitely").then(class_2170.method_9244((String)"rotationCenterEntity", (ArgumentType)class_2186.method_9309()).then(class_2170.method_9244((String)"rotationAxis", (ArgumentType)class_2277.method_9735((boolean)false)).then(class_2170.method_9244((String)"degreesPerTick", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> {
            class_1297 rotationCenterEntity = class_2186.method_9313((CommandContext)context, (String)"rotationCenterEntity");
            class_243 rotationCenter = rotationCenterEntity.method_19538();
            class_243 axis = class_2277.method_9736((CommandContext)context, (String)"rotationAxis").method_1029();
            double angularVelocity = DoubleArgumentType.getDouble((CommandContext)context, (String)"degreesPerTick");
            PortalAnimationCommand.giveRotationAnimation(portal, rotationCenter, axis, angularVelocity);
            PortalCommand.reloadPortal(portal);
            ((class_2168)context.getSource()).method_9226(() -> PortalAnimationCommand.getAnimationInfo(portal), false);
        }))))));
        builder.then(class_2170.method_9247((String)"rotate_infinitely_random").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> {
            class_243 rotationCenter = ((class_2168)context.getSource()).method_9222();
            class_243 axis = new class_243(Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5).method_1029();
            double angularVelocity = Math.random() * 3.0;
            PortalAnimationCommand.giveRotationAnimation(portal, rotationCenter, axis, angularVelocity);
            PortalCommand.reloadPortal(portal);
            ((class_2168)context.getSource()).method_9226(() -> PortalAnimationCommand.getAnimationInfo(portal), false);
        })));
        builder.then(class_2170.method_9247((String)"rotate_portals_infinitely").then(class_2170.method_9244((String)"portals", (ArgumentType)class_2186.method_9306()).then(class_2170.method_9244((String)"rotationCenter", (ArgumentType)class_2277.method_9737()).then(class_2170.method_9244((String)"axis", (ArgumentType)class_2277.method_9735((boolean)false)).then(class_2170.method_9244((String)"degreesPerTick", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> {
            Portal portal;
            Collection portals = class_2186.method_9317((CommandContext)context, (String)"portals");
            class_243 rotationCenter = class_2277.method_9736((CommandContext)context, (String)"rotationCenter");
            class_243 axis = class_2277.method_9736((CommandContext)context, (String)"axis").method_1029();
            double angularVelocity = DoubleArgumentType.getDouble((CommandContext)context, (String)"degreesPerTick");
            for (class_1297 entity : portals) {
                if (entity instanceof Portal) {
                    portal = (Portal)entity;
                    PortalAnimationCommand.giveRotationAnimation(portal, rotationCenter, axis, angularVelocity);
                    PortalCommand.reloadPortal(portal);
                    continue;
                }
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"the entity is not a portal"));
            }
            for (class_1297 entity : portals) {
                if (!(entity instanceof Portal)) continue;
                portal = (Portal)entity;
                PortalCommand.reloadPortal(portal);
            }
            return 0;
        }))))));
        builder.then(class_2170.method_9247((String)"rotate_portals").then(class_2170.method_9244((String)"portals", (ArgumentType)class_2186.method_9306()).then(class_2170.method_9244((String)"rotationCenter", (ArgumentType)class_2277.method_9737()).then(class_2170.method_9244((String)"axis", (ArgumentType)class_2277.method_9735((boolean)false)).then(class_2170.method_9244((String)"degrees", (ArgumentType)DoubleArgumentType.doubleArg()).then(class_2170.method_9244((String)"duration", (ArgumentType)IntegerArgumentType.integer((int)1, (int)10000)).executes(context -> {
            Portal portal;
            Collection portals = class_2186.method_9317((CommandContext)context, (String)"portals");
            class_243 rotationCenter = class_2277.method_9736((CommandContext)context, (String)"rotationCenter");
            class_243 axis = class_2277.method_9736((CommandContext)context, (String)"axis").method_1029();
            double degrees = DoubleArgumentType.getDouble((CommandContext)context, (String)"degrees");
            int duration = IntegerArgumentType.getInteger((CommandContext)context, (String)"duration");
            for (class_1297 entity : portals) {
                if (entity instanceof Portal) {
                    portal = (Portal)entity;
                    PortalState endingState = portal.getAnimationEndingState();
                    long currTime = portal.method_37908().method_8510();
                    portal.addThisSideAnimationDriver(new RotationAnimation.Builder().setInitialOffset(endingState.fromPos.method_1020(rotationCenter)).setRotationAxis(axis).setDegreesPerTick(degrees / (double)duration).setStartGameTime(currTime).setEndGameTime(currTime + (long)duration).setTimingFunction(TimingFunction.sine).build());
                    PortalCommand.reloadPortal(portal);
                    continue;
                }
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"the entity is not a portal"));
            }
            for (class_1297 entity : portals) {
                if (!(entity instanceof Portal)) continue;
                portal = (Portal)entity;
                PortalCommand.reloadPortal(portal);
            }
            return 0;
        })))))));
        builder.then(class_2170.method_9247((String)"rotate_along_normal").then(class_2170.method_9244((String)"degreesPerTick", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> {
            double angularVelocity = DoubleArgumentType.getDouble((CommandContext)context, (String)"degreesPerTick");
            PortalAnimationCommand.giveRotationAnimation(portal, portal.getOriginPos(), portal.getNormal(), angularVelocity);
            PortalCommand.reloadPortal(portal);
            ((class_2168)context.getSource()).method_9226(() -> PortalAnimationCommand.getAnimationInfo(portal), false);
        }))));
        builder.then(class_2170.method_9247((String)"expand_from_center").then(class_2170.method_9244((String)"durationTicks", (ArgumentType)IntegerArgumentType.integer((int)0, (int)1000)).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> {
            int durationTicks = IntegerArgumentType.getInteger((CommandContext)context, (String)"durationTicks");
            double animationScale = 10.0;
            portal.addThisSideAnimationDriver(NormalAnimation.createSizeAnimation(portal, new Vec2d(1.0 / animationScale, 1.0 / animationScale), new Vec2d(1.0, 1.0), portal.getAnimationEffectiveTime(), durationTicks, TimingFunction.sine));
            PortalCommand.reloadPortal(portal);
            ((class_2168)context.getSource()).method_9226(() -> PortalAnimationCommand.getAnimationInfo(portal), false);
        }))));
        LiteralArgumentBuilder buildBuilder = class_2170.method_9247((String)"build");
        buildBuilder.then(class_2170.method_9247((String)"begin").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> {
            Portal animationHolder = portal.getAnimationHolder();
            if (animationHolder != null && animationHolder != portal) {
                PortalAnimationCommand.sendAnimationHolderFailure((CommandContext<class_2168>)context, animationHolder);
                return;
            }
            PortalAnimation animation = portal.animation;
            animation.setPaused(portal, true);
            PortalState portalState = portal.getPortalState();
            assert (portalState != null);
            if (animation.thisSideReferenceState != null && animation.otherSideReferenceState != null) {
                PortalState newState = UnilateralPortalState.combine(animation.thisSideReferenceState, animation.otherSideReferenceState);
                portal.setPortalState(newState);
            } else {
                animation.thisSideReferenceState = UnilateralPortalState.extractThisSide(portalState);
                animation.otherSideReferenceState = UnilateralPortalState.extractOtherSide(portalState);
            }
            NormalAnimation newNormalAnimation = new NormalAnimation.Builder().phases(List.of()).loopCount(1).startingGameTime(portal.getAnimationEffectiveTime()).isBuilding(true).build();
            animation.thisSideAnimations.add(newNormalAnimation);
            animation.otherSideAnimations.add(newNormalAnimation);
            PortalCommand.reloadPortal(portal);
            ((class_2168)context.getSource()).method_9226(() -> PortalAnimationCommand.getAnimationInfo(portal), false);
        })));
        buildBuilder.then(class_2170.method_9247((String)"append_phase").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"durationTicks", (ArgumentType)IntegerArgumentType.integer((int)0, (int)1000)).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> {
            int durationTicks = IntegerArgumentType.getInteger((CommandContext)context, (String)"durationTicks");
            PortalAnimationCommand.executeAppendPhase((CommandContext<class_2168>)context, portal, durationTicks, TimingFunction.sine);
        }))).then(class_2170.method_9244((String)"timingFunction", (ArgumentType)TimingFunctionArgumentType.instance).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> {
            int durationTicks = IntegerArgumentType.getInteger((CommandContext)context, (String)"durationTicks");
            TimingFunction timingFunction = TimingFunctionArgumentType.get(context, "timingFunction");
            PortalAnimationCommand.executeAppendPhase((CommandContext<class_2168>)context, portal, durationTicks, timingFunction);
        })))));
        buildBuilder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"finish").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> PortalAnimationCommand.finishBuildingNormalAnimation((CommandContext<class_2168>)context, portal, 100000)))).then(class_2170.method_9244((String)"loopCount", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100000)).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> {
            int loopCount = IntegerArgumentType.getInteger((CommandContext)context, (String)"loopCount");
            PortalAnimationCommand.finishBuildingNormalAnimation((CommandContext<class_2168>)context, portal, loopCount);
        }))));
        buildBuilder.then(class_2170.method_9247((String)"jump_to_phase").then(class_2170.method_9244((String)"index", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100000)).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> {
            int index = IntegerArgumentType.getInteger((CommandContext)context, (String)"index");
            Portal animationHolder = portal.getAnimationHolder();
            if (animationHolder != null && animationHolder != portal) {
                PortalAnimationCommand.sendAnimationHolderFailure((CommandContext<class_2168>)context, animationHolder);
                return;
            }
            PortalAnimation animation = portal.animation;
            AnimationBuilderContext animationBuilderContext = PortalAnimationCommand.getAnimationBuilderContext(portal);
            if (animationBuilderContext == null) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"No animation to build"));
                return;
            }
            NormalAnimation thisSideAnimation = animationBuilderContext.thisSideAnimation().get();
            List<NormalAnimation.Phase> phases = thisSideAnimation.phases;
            if (index >= phases.size()) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Index out of range"));
                return;
            }
            long totalTicksBefore = phases.stream().limit(index + 1).mapToLong(p -> p.durationTicks()).sum();
            long newStartingGameTime = portal.getAnimationEffectiveTime() - totalTicksBefore;
            animationBuilderContext.thisSideAnimation().set(new NormalAnimation.Builder().from(animationBuilderContext.thisSideAnimation().get()).startingGameTime(newStartingGameTime).isBuilding(false).build());
            animationBuilderContext.otherSideAnimation().set(new NormalAnimation.Builder().from(animationBuilderContext.otherSideAnimation().get()).startingGameTime(newStartingGameTime).isBuilding(false).build());
            PortalCommand.reloadPortal(portal);
            ((class_2168)context.getSource()).method_9226(() -> PortalAnimationCommand.getAnimationInfo(portal), false);
        }))));
        builder.then((ArgumentBuilder)buildBuilder);
    }

    private static void executeAppendPhase(CommandContext<class_2168> context, Portal portal, int durationTicks, TimingFunction timingFunction) {
        Portal animationHolder = portal.getAnimationHolder();
        if (animationHolder != null && animationHolder != portal) {
            PortalAnimationCommand.sendAnimationHolderFailure(context, animationHolder);
            return;
        }
        PortalAnimation animation = portal.animation;
        AnimationBuilderContext animationBuilderContext = PortalAnimationCommand.getAnimationBuilderContext(portal);
        if (animationBuilderContext == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"No animation to build"));
            return;
        }
        PortalState currentPortalState = portal.getPortalState();
        assert (currentPortalState != null);
        UnilateralPortalState thisSideReferenceState = animation.thisSideReferenceState;
        UnilateralPortalState otherSideReferenceState = animation.otherSideReferenceState;
        if (thisSideReferenceState == null || otherSideReferenceState == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"No reference state"));
            return;
        }
        DeltaUnilateralPortalState thisSideDelta = UnilateralPortalState.extractThisSide(currentPortalState).subtract(thisSideReferenceState);
        DeltaUnilateralPortalState otherSideDelta = UnilateralPortalState.extractOtherSide(currentPortalState).subtract(otherSideReferenceState);
        NormalAnimation thisSideAnimation = animationBuilderContext.thisSideAnimation().get();
        animationBuilderContext.thisSideAnimation().set(new NormalAnimation.Builder().phases((List<NormalAnimation.Phase>)ImmutableList.builder().addAll(thisSideAnimation.phases).add((Object)new NormalAnimation.Phase.Builder().durationTicks(durationTicks).timingFunction(timingFunction).delta(thisSideDelta).build()).build()).loopCount(thisSideAnimation.loopCount).startingGameTime(thisSideAnimation.startingGameTime).isBuilding(true).build());
        NormalAnimation otherSideAnimation = animationBuilderContext.otherSideAnimation().get();
        animationBuilderContext.otherSideAnimation().set(new NormalAnimation.Builder().phases((List<NormalAnimation.Phase>)ImmutableList.builder().addAll(otherSideAnimation.phases).add((Object)new NormalAnimation.Phase.Builder().durationTicks(durationTicks).timingFunction(timingFunction).delta(otherSideDelta).build()).build()).loopCount(otherSideAnimation.loopCount).startingGameTime(otherSideAnimation.startingGameTime).isBuilding(true).build());
        PortalCommand.reloadPortal(portal);
        ((class_2168)context.getSource()).method_9226(() -> PortalAnimationCommand.getAnimationInfo(portal), false);
    }

    private static AnimationBuilderContext getAnimationBuilderContext(Portal portal) {
        final PortalAnimation animation = portal.animation;
        if (animation.thisSideAnimations.isEmpty() || animation.otherSideAnimations.isEmpty()) {
            return null;
        }
        final int thisSideIndex = animation.thisSideAnimations.size() - 1;
        PortalAnimationDriver lastThisSideAnimation = animation.thisSideAnimations.get(thisSideIndex);
        if (!(lastThisSideAnimation instanceof NormalAnimation)) {
            return null;
        }
        final NormalAnimation thisSideNormalAnimation = (NormalAnimation)lastThisSideAnimation;
        final int otherSideIndex = animation.otherSideAnimations.size() - 1;
        PortalAnimationDriver lastOtherSideAnimation = animation.otherSideAnimations.get(otherSideIndex);
        if (!(lastOtherSideAnimation instanceof NormalAnimation)) {
            return null;
        }
        final NormalAnimation otherSideNormalAnimation = (NormalAnimation)lastOtherSideAnimation;
        return new AnimationBuilderContext(portal, new Access<NormalAnimation>(){

            @Override
            public NormalAnimation get() {
                return thisSideNormalAnimation;
            }

            @Override
            public void set(NormalAnimation normalAnimation) {
                animation.thisSideAnimations.set(thisSideIndex, normalAnimation);
            }
        }, new Access<NormalAnimation>(){

            @Override
            public NormalAnimation get() {
                return otherSideNormalAnimation;
            }

            @Override
            public void set(NormalAnimation normalAnimation) {
                animation.otherSideAnimations.set(otherSideIndex, normalAnimation);
            }
        });
    }

    private static void sendAnimationHolderFailure(CommandContext<class_2168> context, Portal animationHolder) {
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("This portal entity is not animation holder. Use this command to " + animationHolder)));
    }

    private static void finishBuildingNormalAnimation(CommandContext<class_2168> context, Portal portal, int loopCount) {
        Portal animationHolder = portal.getAnimationHolder();
        if (animationHolder != null && animationHolder != portal) {
            PortalAnimationCommand.sendAnimationHolderFailure(context, animationHolder);
            return;
        }
        PortalAnimation animation = portal.animation;
        AnimationBuilderContext animationBuilderContext = PortalAnimationCommand.getAnimationBuilderContext(portal);
        if (animationBuilderContext == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"No animation to build"));
            return;
        }
        ImmutableList thisSidePhases = animationBuilderContext.thisSideAnimation().get().phases;
        ImmutableList otherSidePhases = animationBuilderContext.otherSideAnimation().get().phases;
        if (thisSidePhases.isEmpty() || otherSidePhases.isEmpty()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"No phase"));
            return;
        }
        NormalAnimation.Phase lastThisSidePhase = thisSidePhases.get(thisSidePhases.size() - 1);
        DeltaUnilateralPortalState lastThisSidePhaseDelta = lastThisSidePhase.delta().purgeFPError();
        NormalAnimation.Phase lastOtherSidePhase = otherSidePhases.get(otherSidePhases.size() - 1);
        DeltaUnilateralPortalState lastOtherSidePhaseDelta = lastOtherSidePhase.delta().purgeFPError();
        if (loopCount > 1 && !lastThisSidePhaseDelta.isIdentity() || !lastOtherSidePhaseDelta.isIdentity()) {
            thisSidePhases = ImmutableList.builder().addAll(thisSidePhases).add((Object)new NormalAnimation.Phase.Builder().durationTicks(5L).timingFunction(TimingFunction.sine).delta(DeltaUnilateralPortalState.identity).build()).build();
            otherSidePhases = ImmutableList.builder().addAll(otherSidePhases).add((Object)new NormalAnimation.Phase.Builder().durationTicks(5L).timingFunction(TimingFunction.sine).delta(DeltaUnilateralPortalState.identity).build()).build();
        }
        animationBuilderContext.thisSideAnimation().set(new NormalAnimation.Builder().phases((List<NormalAnimation.Phase>)thisSidePhases).loopCount(loopCount).startingGameTime(animationBuilderContext.thisSideAnimation().get().startingGameTime).build());
        animationBuilderContext.otherSideAnimation().set(new NormalAnimation.Builder().phases((List<NormalAnimation.Phase>)otherSidePhases).loopCount(loopCount).startingGameTime(animationBuilderContext.otherSideAnimation().get().startingGameTime).build());
        animation.setBackToPausingState(portal);
        animation.setPaused(portal, false);
        PortalExtension.forClusterPortals(portal, Portal::reloadAndSyncToClientNextTick);
        ((class_2168)context.getSource()).method_9226(() -> PortalAnimationCommand.getAnimationInfo(portal), false);
    }

    private static void giveRotationAnimation(Portal portal, class_243 rotationCenter, class_243 axis, double angularVelocity) {
        portal.addThisSideAnimationDriver(new RotationAnimation.Builder().setInitialOffset(portal.getOriginPos().method_1020(rotationCenter)).setRotationAxis(axis).setDegreesPerTick(angularVelocity).setStartGameTime(portal.getAnimationEffectiveTime()).setEndGameTime(Long.MAX_VALUE).build());
    }

    private static class_2561 getAnimationInfo(Portal portal) {
        return portal.getAnimationView().getInfo();
    }

    public record AnimationBuilderContext(Portal portal, Access<NormalAnimation> thisSideAnimation, Access<NormalAnimation> otherSideAnimation) {
    }
}

