/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.mixin.client.render;

import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_765;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPCGlobal;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.ducks.IEGameRenderer;
import qouteall.imm_ptl.core.portal.animation.ClientPortalAnimationManagement;
import qouteall.imm_ptl.core.portal.animation.StableClientTimer;
import qouteall.imm_ptl.core.render.CrossPortalViewRendering;
import qouteall.imm_ptl.core.render.GuiPortalRendering;
import qouteall.imm_ptl.core.render.MyRenderHelper;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.imm_ptl.core.render.renderer.PortalRenderer;
import qouteall.imm_ptl.core.teleportation.ClientTeleportationManager;
import qouteall.q_misc_util.Helper;

@Mixin(value={class_757.class})
public abstract class MixinGameRenderer
implements IEGameRenderer {
    @Shadow
    @Final
    @Mutable
    private class_765 field_4028;
    @Shadow
    private boolean field_3992;
    @Shadow
    @Final
    @Mutable
    private class_4184 field_18765;
    @Shadow
    @Final
    private class_310 field_4015;
    @Shadow
    private boolean field_4001;
    private static boolean portal_isRenderingHand = false;

    @Shadow
    public abstract void method_22709(Matrix4f var1);

    @Shadow
    protected abstract void method_3186(class_4587 var1, float var2);

    @Inject(method={"Lnet/minecraft/client/renderer/GameRenderer;render(FJZ)V"}, at={@At(value="HEAD")})
    private void onFarBeforeRendering(float tickDelta, long nanoTime, boolean renderWorldIn, CallbackInfo ci) {
        this.field_4015.method_16011().method_15396("ip_pre_total_render");
        IPGlobal.PRE_TOTAL_RENDER_TASK_LIST.processTasks();
        this.field_4015.method_16011().method_15407();
        if (this.field_4015.field_1687 == null) {
            return;
        }
        if (!renderWorldIn) {
            return;
        }
        this.field_4015.method_16011().method_15396("ip_pre_render");
        RenderStates.updatePreRenderInfo(tickDelta);
        StableClientTimer.update(this.field_4015.field_1687.method_8510(), tickDelta);
        ClientPortalAnimationManagement.update();
        ClientTeleportationManager.manageTeleportation(false);
        ((Runnable)IPGlobal.PRE_GAME_RENDER_EVENT.invoker()).run();
        if (IPCGlobal.earlyRemoteUpload) {
            MyRenderHelper.earlyRemoteUpload();
        }
        this.field_4015.method_16011().method_15407();
        ++RenderStates.frameIndex;
    }

    @Inject(method={"Lnet/minecraft/client/renderer/GameRenderer;render(FJZ)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;renderLevel(FJLcom/mojang/blaze3d/vertex/PoseStack;)V")})
    private void onBeforeRenderingCenter(float float_1, long long_1, boolean boolean_1, CallbackInfo ci) {
        PortalRenderer.switchToCorrectRenderer();
        IPCGlobal.renderer.prepareRendering();
    }

    @Inject(method={"Lnet/minecraft/client/renderer/GameRenderer;render(FJZ)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;renderLevel(FJLcom/mojang/blaze3d/vertex/PoseStack;)V", shift=At.Shift.AFTER)})
    private void onAfterRenderingCenter(float float_1, long long_1, boolean boolean_1, CallbackInfo ci) {
        IPCGlobal.renderer.finishRendering();
        RenderStates.onTotalRenderEnd();
        GuiPortalRendering._onGameRenderEnd();
        if (IPCGlobal.lateClientLightUpdate) {
            this.field_4015.method_16011().method_15396("ip_late_update_light");
            MyRenderHelper.lateUpdateLight();
            this.field_4015.method_16011().method_15407();
        }
    }

    @Redirect(method={"Lnet/minecraft/client/renderer/GameRenderer;render(FJZ)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;renderLevel(FJLcom/mojang/blaze3d/vertex/PoseStack;)V"))
    private void redirectRenderingWorld(class_757 gameRenderer, float tickDelta, long limitTime, class_4587 matrix) {
        if (CrossPortalViewRendering.renderCrossPortalView()) {
            return;
        }
        gameRenderer.method_3188(tickDelta, limitTime, matrix);
    }

    @Inject(method={"Lnet/minecraft/client/renderer/GameRenderer;renderLevel(FJLcom/mojang/blaze3d/vertex/PoseStack;)V"}, at={@At(value="TAIL")})
    private void onRenderCenterEnded(float float_1, long long_1, class_4587 matrixStack_1, CallbackInfo ci) {
        IPCGlobal.renderer.onHandRenderingEnded(matrixStack_1);
    }

    @Inject(method={"Lnet/minecraft/client/renderer/GameRenderer;renderLevel(FJLcom/mojang/blaze3d/vertex/PoseStack;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderLevel(Lcom/mojang/blaze3d/vertex/PoseStack;FJZLnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lorg/joml/Matrix4f;)V", shift=At.Shift.AFTER)})
    private void onRightBeforeHandRendering(float tickDelta, long limitTime, class_4587 matrix, CallbackInfo ci) {
        IPCGlobal.renderer.onBeforeHandRendering(matrix);
    }

    @Inject(method={"Lnet/minecraft/client/renderer/GameRenderer;resize(II)V"}, at={@At(value="RETURN")})
    private void onOnResized(int int_1, int int_2, CallbackInfo ci) {
        if (ClientWorldLoader.getIsInitialized()) {
            ClientWorldLoader.WORLD_RENDERER_MAP.values().stream().filter(worldRenderer -> worldRenderer != this.field_4015.field_1769).forEach(worldRenderer -> worldRenderer.method_3242(int_1, int_2));
        }
    }

    @Inject(method={"Lnet/minecraft/client/renderer/GameRenderer;renderItemInHand(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/Camera;F)V"}, at={@At(value="HEAD")})
    private void onRenderHandBegins(class_4587 matrices, class_4184 camera, float tickDelta, CallbackInfo ci) {
        portal_isRenderingHand = true;
    }

    @Inject(method={"Lnet/minecraft/client/renderer/GameRenderer;renderItemInHand(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/Camera;F)V"}, at={@At(value="RETURN")})
    private void onRenderHandEnds(class_4587 matrices, class_4184 camera, float tickDelta, CallbackInfo ci) {
        portal_isRenderingHand = false;
    }

    @ModifyArg(method={"bobView"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;translate(FFF)V"), index=0)
    private float modifyBobViewTranslateX(float f) {
        if (portal_isRenderingHand) {
            return f;
        }
        return (float)((double)f * RenderStates.getViewBobbingOffsetMultiplier());
    }

    @ModifyArg(method={"bobView"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;translate(FFF)V"), index=1)
    private float modifyBobViewTranslateY(float f) {
        if (portal_isRenderingHand) {
            return f;
        }
        return (float)((double)f * RenderStates.getViewBobbingOffsetMultiplier());
    }

    @ModifyArg(method={"bobView"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;translate(FFF)V"), index=2)
    private float modifyBobViewTranslateZ(float f) {
        if (portal_isRenderingHand) {
            return f;
        }
        return (float)((double)f * RenderStates.getViewBobbingOffsetMultiplier());
    }

    @Redirect(method={"Lnet/minecraft/client/renderer/GameRenderer;renderLevel(FJLcom/mojang/blaze3d/vertex/PoseStack;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;getProjectionMatrix(D)Lorg/joml/Matrix4f;", ordinal=0))
    private Matrix4f redirectGetBasicProjectionMatrix(class_757 instance, double fov) {
        Matrix4f result;
        if (PortalRendering.isRendering()) {
            if (RenderStates.basicProjectionMatrix != null) {
                return RenderStates.basicProjectionMatrix;
            }
            Helper.err("projection matrix state abnormal");
        }
        RenderStates.basicProjectionMatrix = result = instance.method_22973(fov);
        return result;
    }

    @Override
    public void ip_setLightmapTextureManager(class_765 manager) {
        this.field_4028 = manager;
    }

    @Override
    public boolean ip_getDoRenderHand() {
        return this.field_3992;
    }

    @Override
    public void ip_setCamera(class_4184 camera_) {
        this.field_18765 = camera_;
    }

    @Override
    public void ip_setIsRenderingPanorama(boolean cond) {
        this.field_4001 = cond;
    }

    @Override
    public void portal_bobView(class_4587 matrixStack, float tickDelta) {
        this.method_3186(matrixStack, tickDelta);
    }
}

