/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.network;

import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientLoginConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.minecraft.class_124;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_8605;
import net.minecraft.class_8610;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.IPMcHelper;
import qouteall.imm_ptl.core.mixin.common.other_sync.IEServerConfigurationPacketListenerImpl;
import qouteall.imm_ptl.core.platform_specific.IPConfig;
import qouteall.imm_ptl.core.platform_specific.O_O;

public class ImmPtlNetworkConfig {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static ModVersion immPtlVersion;
    @Nullable
    private static ModVersion serverVersion;

    public static void init() {
        immPtlVersion = O_O.getImmPtlVersion();
        LOGGER.info("Immersive Portals Core version {}", (Object)immPtlVersion);
        ServerConfigurationConnectionEvents.CONFIGURE.register((handler, server) -> {
            if (ServerConfigurationNetworking.canSend((class_8610)handler, S2CConfigStartPacket.TYPE)) {
                handler.addTask((class_8605)new ImmPtlConfigurationTask());
            } else if (server.method_3816()) {
                if (IPConfig.getConfig().serverRejectClientWithoutImmPtl) {
                    handler.method_52396((class_2561)class_2561.method_43470((String)"The server detected that client does not install Immersive Portals mod.\nA server with Immersive Portals mod only works with the clients that have it.\n\n(Note: The networking sync may be interfered by Essential mod or other mods. When you are using these mods, the detection may malfunction. In this case, you can disable networking check in the server side by changing `serverRejectClientWithoutImmPtl` to `false` in the server's config file `config/immersive_portals.json` and restart.)\n"));
                } else {
                    GameProfile gameProfile = ((IEServerConfigurationPacketListenerImpl)handler).ip_getGameProfile();
                    LOGGER.warn("Fabric API's sendable channel sync detected that client does not install ImmPtl. {} {}", (Object)gameProfile.getName(), (Object)gameProfile.getId());
                }
            } else {
                LOGGER.error("ImmPtl configuration channel is non-sendable from Fabric API in integrated server. Fabric API sendable channel sync is interfered.");
            }
        });
        ServerConfigurationNetworking.registerGlobalReceiver(C2SConfigCompletePacket.TYPE, C2SConfigCompletePacket::handle);
    }

    @Environment(value=EnvType.CLIENT)
    public static void initClient() {
        ClientConfigurationNetworking.registerGlobalReceiver(S2CConfigStartPacket.TYPE, S2CConfigStartPacket::handle);
        ClientLoginConnectionEvents.INIT.register((handler, client) -> {
            LOGGER.info("Client login init");
            serverVersion = null;
        });
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> ImmPtlNetworkConfig.onClientJoin());
    }

    private static void onClientJoin() {
        if (serverVersion == null) {
            ImmPtlNetworkConfig.warnServerMissingImmPtl();
        } else if (serverVersion.isNormalVersion() && immPtlVersion.isNormalVersion() && !serverVersion.equals(immPtlVersion) && IPConfig.getConfig().shouldDisplayWarning("mod_version_mismatch")) {
            class_5250 text = class_2561.method_43469((String)"imm_ptl.mod_patch_version_mismatch", (Object[])new Object[]{class_2561.method_43470((String)serverVersion.toString()).method_27692(class_124.field_1065), class_2561.method_43470((String)immPtlVersion.toString()).method_27692(class_124.field_1065)}).method_10852(IPMcHelper.getDisableWarningText("mod_version_mismatch"));
            CHelper.printChat((class_2561)text);
        }
    }

    public static boolean doesServerHaveImmPtl() {
        return serverVersion != null;
    }

    private static void warnServerMissingImmPtl() {
        class_310.method_1551().execute(() -> CHelper.printChat((class_2561)class_2561.method_43471((String)"imm_ptl.server_missing_immptl")));
    }

    static {
        serverVersion = null;
    }

    public record ModVersion(int major, int minor, int patch) {
        public static final ModVersion OTHER = new ModVersion(0, 0, 0);

        public static ModVersion read(class_2540 buf) {
            int major = buf.method_10816();
            int minor = buf.method_10816();
            int patch = buf.method_10816();
            return new ModVersion(major, minor, patch);
        }

        public void write(class_2540 buf) {
            buf.method_10804(this.major);
            buf.method_10804(this.minor);
            buf.method_10804(this.patch);
        }

        @Override
        public String toString() {
            return "%d.%d.%d".formatted(this.major, this.minor, this.patch);
        }

        public boolean isNormalVersion() {
            return !OTHER.equals(this);
        }

        public boolean isCompatibleWith(ModVersion another) {
            return this.major == another.major && this.minor == another.minor;
        }
    }

    public record C2SConfigCompletePacket(ModVersion versionFromClient, boolean clientTolerantVersionMismatch) implements FabricPacket
    {
        public static final PacketType<C2SConfigCompletePacket> TYPE = PacketType.create((class_2960)new class_2960("iportal:configure_complete"), C2SConfigCompletePacket::read);

        public static C2SConfigCompletePacket read(class_2540 buf) {
            ModVersion info = ModVersion.read(buf);
            boolean clientTolerantVersionMismatch = buf.readBoolean();
            return new C2SConfigCompletePacket(info, clientTolerantVersionMismatch);
        }

        public void write(class_2540 buf) {
            this.versionFromClient.write(buf);
            buf.method_52964(this.clientTolerantVersionMismatch);
        }

        public PacketType<?> getType() {
            return TYPE;
        }

        public void handle(class_8610 networkHandler, PacketSender responseSender) {
            GameProfile gameProfile = ((IEServerConfigurationPacketListenerImpl)networkHandler).ip_getGameProfile();
            LOGGER.info("Server received ImmPtl config packet. Mod version: {} Player: {} {}", new Object[]{this.versionFromClient, gameProfile.getName(), gameProfile.getId()});
            if (this.versionFromClient.isNormalVersion() && immPtlVersion.isNormalVersion() && (this.versionFromClient.major != ImmPtlNetworkConfig.immPtlVersion.major || this.versionFromClient.minor != ImmPtlNetworkConfig.immPtlVersion.minor) && !IPConfig.getConfig().serverTolerantVersionMismatchWithClient && !this.clientTolerantVersionMismatch) {
                networkHandler.method_52396((class_2561)class_2561.method_43469((String)"imm_ptl.mod_major_minor_version_mismatch", (Object[])new Object[]{immPtlVersion.toString(), this.versionFromClient.toString()}));
                LOGGER.info("Disconnecting client because of ImmPtl version difference (only patch version difference is tolerated).\nGame Profile: {}\nClient ImmPtl version: {}\nServer ImmPtl version: {}", new Object[]{gameProfile, this.versionFromClient, immPtlVersion});
                return;
            }
            networkHandler.completeTask(ImmPtlConfigurationTask.TYPE);
        }
    }

    public record S2CConfigStartPacket(ModVersion versionFromServer) implements FabricPacket
    {
        public static final PacketType<S2CConfigStartPacket> TYPE = PacketType.create((class_2960)new class_2960("iportal:config_packet"), S2CConfigStartPacket::read);

        public static S2CConfigStartPacket read(class_2540 buf) {
            ModVersion info = ModVersion.read(buf);
            return new S2CConfigStartPacket(info);
        }

        public void write(class_2540 buf) {
            this.versionFromServer.write(buf);
        }

        public PacketType<?> getType() {
            return TYPE;
        }

        @Environment(value=EnvType.CLIENT)
        public void handle(PacketSender responseSender) {
            LOGGER.info("Client received ImmPtl config packet. Server mod version: {}", (Object)this.versionFromServer);
            serverVersion = this.versionFromServer;
            responseSender.sendPacket((FabricPacket)new C2SConfigCompletePacket(immPtlVersion, IPConfig.getConfig().clientTolerantVersionMismatchWithServer));
        }
    }

    public record ImmPtlConfigurationTask() implements class_8605
    {
        public static final class_8605.class_8606 TYPE = new class_8605.class_8606("iportal:config");

        public void method_52376(Consumer<class_2596<?>> consumer) {
            consumer.accept(ServerConfigurationNetworking.createS2CPacket((FabricPacket)new S2CConfigStartPacket(immPtlVersion)));
        }

        @NotNull
        public class_8605.class_8606 method_52375() {
            return TYPE;
        }
    }
}

