/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.network;

import com.mojang.logging.LogUtils;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2359;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_7923;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.api.PortalAPI;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorage;
import qouteall.imm_ptl.core.teleportation.ServerTeleportationManager;

public class ImmPtlNetworking {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void init() {
        ServerPlayNetworking.registerGlobalReceiver(TeleportPacket.TYPE, (packet, player, responseSender) -> packet.handle(player));
    }

    public static void initClient() {
        ClientPlayNetworking.registerGlobalReceiver(GlobalPortalSyncPacket.TYPE, (packet, player, responseSender) -> packet.handle());
        ClientPlayNetworking.registerGlobalReceiver(PortalSyncPacket.TYPE, (packet, player, responseSender) -> packet.handle());
    }

    public record TeleportPacket(int dimensionId, class_243 eyePosBeforeTeleportation, UUID portalId) implements FabricPacket
    {
        public static final PacketType<TeleportPacket> TYPE = PacketType.create((class_2960)new class_2960("imm_ptl:teleport"), TeleportPacket::read);

        public static TeleportPacket read(class_2540 buf) {
            int dimId = buf.method_10816();
            class_243 pos = new class_243(buf.readDouble(), buf.readDouble(), buf.readDouble());
            UUID portalId = buf.method_10790();
            return new TeleportPacket(dimId, pos, portalId);
        }

        public void write(class_2540 buf) {
            buf.method_10804(this.dimensionId);
            buf.method_52940(this.eyePosBeforeTeleportation.field_1352);
            buf.method_52940(this.eyePosBeforeTeleportation.field_1351);
            buf.method_52940(this.eyePosBeforeTeleportation.field_1350);
            buf.method_10797(this.portalId);
        }

        public PacketType<?> getType() {
            return TYPE;
        }

        public void handle(class_3222 player) {
            class_5321<class_1937> dim = PortalAPI.serverIntToDimKey(player.field_13995, this.dimensionId);
            ServerTeleportationManager.of(player.field_13995).onPlayerTeleportedInClient(player, dim, this.eyePosBeforeTeleportation, this.portalId);
        }
    }

    public record GlobalPortalSyncPacket(int dimensionId, class_2487 data) implements FabricPacket
    {
        public static final PacketType<GlobalPortalSyncPacket> TYPE = PacketType.create((class_2960)new class_2960("imm_ptl:upd_glb_ptl"), GlobalPortalSyncPacket::read);

        public static GlobalPortalSyncPacket read(class_2540 buf) {
            int dimId = buf.method_10816();
            class_2487 compoundTag = buf.method_10798();
            return new GlobalPortalSyncPacket(dimId, compoundTag);
        }

        public void write(class_2540 buf) {
            buf.method_10804(this.dimensionId);
            buf.method_10794((class_2520)this.data);
        }

        public PacketType<?> getType() {
            return TYPE;
        }

        @Environment(value=EnvType.CLIENT)
        public void handle() {
            class_5321<class_1937> dim = PortalAPI.clientIntToDimKey(this.dimensionId);
            GlobalPortalStorage.receiveGlobalPortalSync(dim, this.data);
        }
    }

    public record PortalSyncPacket(int id, UUID uuid, class_1299<?> type, int dimensionId, double x, double y, double z, class_2487 extraData) implements FabricPacket
    {
        public static final PacketType<PortalSyncPacket> TYPE = PacketType.create((class_2960)new class_2960("imm_ptl:spawn_portal"), PortalSyncPacket::read);

        public void write(class_2540 buf) {
            buf.method_10804(this.id);
            buf.method_10797(this.uuid);
            buf.method_42065((class_2359)class_7923.field_41177, this.type);
            buf.method_10804(this.dimensionId);
            buf.method_52940(this.x);
            buf.method_52940(this.y);
            buf.method_52940(this.z);
            buf.method_10794((class_2520)this.extraData);
        }

        public static PortalSyncPacket read(class_2540 buf) {
            int id = buf.method_10816();
            UUID uuid = buf.method_10790();
            class_1299 type = (class_1299)buf.method_42064((class_2359)class_7923.field_41177);
            int dimensionId = buf.method_10816();
            double x = buf.readDouble();
            double y = buf.readDouble();
            double z = buf.readDouble();
            class_2487 extraData = buf.method_10798();
            return new PortalSyncPacket(id, uuid, type, dimensionId, x, y, z, extraData);
        }

        public PacketType<?> getType() {
            return TYPE;
        }

        @Environment(value=EnvType.CLIENT)
        public void handle() {
            class_5321<class_1937> dimension = PortalAPI.clientIntToDimKey(this.dimensionId);
            class_638 world = ClientWorldLoader.getWorld(dimension);
            class_1297 existing = world.method_8469(this.id);
            if (existing instanceof Portal) {
                Portal existingPortal = (Portal)existing;
                if (!Objects.equals(existingPortal.method_5667(), this.uuid)) {
                    LOGGER.error("UUID mismatch when syncing portal {} {}", (Object)existingPortal, (Object)this.uuid);
                    return;
                }
                if (existingPortal.method_5864() != this.type) {
                    LOGGER.error("Entity type mismatch when syncing portal {} {}", (Object)existingPortal, this.type);
                    return;
                }
                existingPortal.acceptDataSync(new class_243(this.x, this.y, this.z), this.extraData);
            } else {
                class_1297 entity = this.type.method_5883((class_1937)world);
                Validate.notNull((Object)entity, (String)"Entity type is null", (Object[])new Object[0]);
                if (!(entity instanceof Portal)) {
                    LOGGER.error("Spawned entity is not a portal. {} {}", (Object)entity, this.type);
                    return;
                }
                Portal portal = (Portal)entity;
                entity.method_5838(this.id);
                entity.method_5826(this.uuid);
                entity.method_43391(this.x, this.y, this.z);
                entity.method_24203(this.x, this.y, this.z);
                portal.readPortalDataFromNbt(this.extraData);
                world.method_53875(entity);
                ClientWorldLoader.getWorld(portal.getDestDim());
                ((Consumer)Portal.CLIENT_PORTAL_SPAWN_EVENT.invoker()).accept(portal);
                if (IPGlobal.clientPortalLoadDebug) {
                    LOGGER.info("Portal loaded to client {}", (Object)portal);
                }
            }
        }
    }
}

