/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.platform_specific;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.apache.commons.lang3.Validate;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.compat.PehkuiInterface;
import qouteall.imm_ptl.core.ducks.IECamera;
import qouteall.imm_ptl.core.portal.Portal;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleTypes;
import virtuoel.pehkui.util.ScaleUtils;

public class PehkuiInterfaceInitializer {
    public static void init() {
        PehkuiInterface.invoker = new OnPehkuiPresent();
    }

    @Environment(value=EnvType.CLIENT)
    private static void onPlayerTeleportedClient(Portal portal) {
        if (portal.hasScaling() && portal.isTeleportChangesScale()) {
            class_310 client = class_310.method_1551();
            class_746 player = client.field_1724;
            Validate.notNull((Object)player);
            PehkuiInterfaceInitializer.doScalingForEntity((class_1297)player, portal);
            IECamera camera = (IECamera)client.field_1773.method_19418();
            camera.ip_setCameraY((float)((double)camera.ip_getCameraY() * portal.getScaling()), (float)((double)camera.ip_getLastCameraY() * portal.getScaling()));
        }
    }

    private static void onEntityTeleportedServer(class_1297 entity, Portal portal) {
        if (portal.hasScaling() && portal.isTeleportChangesScale()) {
            PehkuiInterfaceInitializer.doScalingForEntity(entity, portal);
            if (entity.method_5854() != null) {
                PehkuiInterfaceInitializer.doScalingForEntity(entity.method_5854(), portal);
            }
        }
    }

    private static void doScalingForEntity(class_1297 entity, Portal portal) {
        class_243 eyePos = McHelper.getEyePos(entity);
        class_243 lastTickEyePos = McHelper.getLastTickEyePos(entity);
        float oldScale = PehkuiInterface.invoker.getBaseScale(entity);
        float newScale = PehkuiInterfaceInitializer.transformScale(portal, oldScale);
        if (!entity.method_37908().field_9236 && PehkuiInterfaceInitializer.isScaleIllegal(newScale)) {
            newScale = 1.0f;
            entity.method_43496((class_2561)class_2561.method_43470((String)"Scale out of range"));
        }
        PehkuiInterface.invoker.setBaseScale(entity, newScale);
        if (!entity.method_37908().field_9236) {
            McHelper.setEyePos(entity, eyePos, lastTickEyePos);
            McHelper.updateBoundingBox(entity);
            float scaleTest = ScaleUtils.getEyeHeightScale((class_1297)entity, (float)0.5f);
            Validate.isTrue(((double)scaleTest > 1.0E-4 ? 1 : 0) != 0);
        } else {
            McHelper.setEyePos(entity, eyePos, lastTickEyePos);
            McHelper.updateBoundingBox(entity);
        }
    }

    private static float transformScale(Portal portal, float oldScale) {
        float result = (float)((double)oldScale * portal.getScaling());
        if (Math.abs(result - 1.0f) < 1.0E-4f) {
            result = 1.0f;
        }
        return result;
    }

    private static boolean isScaleIllegal(float scale) {
        return scale > (float)IPGlobal.scaleLimit || scale < 1.0f / (float)(IPGlobal.scaleLimit * 2);
    }

    public static class OnPehkuiPresent
    extends PehkuiInterface.Invoker {
        private boolean loggedErrorMessage = false;

        @Override
        public boolean isPehkuiPresent() {
            return true;
        }

        @Override
        public void onClientPlayerTeleported(Portal portal) {
            PehkuiInterfaceInitializer.onPlayerTeleportedClient(portal);
        }

        @Override
        public void onServerEntityTeleported(class_1297 entity, Portal portal) {
            PehkuiInterfaceInitializer.onEntityTeleportedServer(entity, portal);
        }

        private void logErrorMessage(class_1297 entity, Throwable e, String situation) {
            e.printStackTrace();
            entity.method_43496((class_2561)class_2561.method_43470((String)("Something went wrong with Pehkui (" + situation + ")")));
        }

        @Override
        public float getBaseScale(class_1297 entity, float tickDelta) {
            try {
                return ScaleTypes.BASE.getScaleData(entity).getBaseScale(tickDelta);
            }
            catch (Throwable e) {
                if (!this.loggedErrorMessage) {
                    this.loggedErrorMessage = true;
                    this.logErrorMessage(entity, e, "getting scale");
                }
                return super.getBaseScale(entity, tickDelta);
            }
        }

        @Override
        public void setBaseScale(class_1297 entity, float scale) {
            block2: {
                try {
                    ScaleData data = ScaleTypes.BASE.getScaleData(entity);
                    data.setScale(scale);
                }
                catch (Throwable e) {
                    if (this.loggedErrorMessage) break block2;
                    this.loggedErrorMessage = true;
                    this.logErrorMessage(entity, e, "setting scale");
                }
            }
        }

        @Override
        public float computeThirdPersonScale(class_1297 entity, float tickDelta) {
            try {
                return ScaleTypes.THIRD_PERSON.getScaleData(entity).getScale(tickDelta);
            }
            catch (Throwable e) {
                if (!this.loggedErrorMessage) {
                    this.loggedErrorMessage = true;
                    this.logErrorMessage(entity, e, "getting third person scale");
                }
                return super.computeThirdPersonScale(entity, tickDelta);
            }
        }

        @Override
        public float computeBlockReachScale(class_1297 entity, float tickDelta) {
            try {
                return ScaleTypes.BLOCK_REACH.getScaleData(entity).getScale(tickDelta);
            }
            catch (Throwable e) {
                if (!this.loggedErrorMessage) {
                    this.loggedErrorMessage = true;
                    this.logErrorMessage(entity, e, "getting reach scale");
                }
                return super.computeBlockReachScale(entity, tickDelta);
            }
        }

        @Override
        public float computeMotionScale(class_1297 entity, float tickDelta) {
            try {
                return ScaleTypes.MOTION.getScaleData(entity).getScale(tickDelta);
            }
            catch (Throwable e) {
                if (!this.loggedErrorMessage) {
                    this.loggedErrorMessage = true;
                    this.logErrorMessage(entity, e, "getting motion scale");
                }
                return super.computeMotionScale(entity, tickDelta);
            }
        }
    }
}

