/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.platform_specific;

import java.lang.reflect.Method;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.apache.commons.lang3.Validate;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.teleportation.ClientTeleportationManager;
import qouteall.imm_ptl.core.teleportation.ServerTeleportationManager;
import qouteall.q_misc_util.Helper;

public class RequiemCompat {
    private static boolean isRequiemPresent = false;
    private static Class class_RequiemPlayer;
    private static Class class_PossessionComponent;
    private static Method method_asPossessor;
    private static Method method_getPossessedEntity;

    public static boolean getIsRequiemPresent() {
        return isRequiemPresent;
    }

    public static void init() {
        isRequiemPresent = FabricLoader.getInstance().isModLoaded("requiem");
        if (!isRequiemPresent) {
            return;
        }
        class_RequiemPlayer = Helper.noError(() -> Class.forName("ladysnake.requiem.api.v1.RequiemPlayer"));
        class_PossessionComponent = Helper.noError(() -> Class.forName("ladysnake.requiem.api.v1.possession.PossessionComponent"));
        method_asPossessor = Helper.noError(() -> class_RequiemPlayer.getDeclaredMethod("asPossessor", new Class[0]));
        method_getPossessedEntity = Helper.noError(() -> class_PossessionComponent.getDeclaredMethod("getPossessedEntity", new Class[0]));
    }

    public static class_1308 getPossessedEntity(class_1657 player) {
        Validate.isTrue((boolean)isRequiemPresent);
        Object possessionComponent = Helper.noError(() -> method_asPossessor.invoke((Object)player, new Object[0]));
        Object possessedEntity = Helper.noError(() -> method_getPossessedEntity.invoke(possessionComponent, new Object[0]));
        return (class_1308)possessedEntity;
    }

    @Environment(value=EnvType.CLIENT)
    public static void onPlayerTeleportedClient() {
        if (!isRequiemPresent) {
            return;
        }
        class_746 player = class_310.method_1551().field_1724;
        class_1308 possessedEntity = RequiemCompat.getPossessedEntity((class_1657)player);
        if (possessedEntity != null && possessedEntity.method_37908() != player.method_37908()) {
            Helper.LOGGER.info("Move Requiem Possessed Entity at Client");
            ClientTeleportationManager.moveClientEntityAcrossDimension((class_1297)possessedEntity, (class_638)player.method_37908(), player.method_19538());
        }
    }

    public static void onPlayerTeleportedServer(class_3222 player) {
        if (!isRequiemPresent) {
            return;
        }
        class_1308 possessedEntity = RequiemCompat.getPossessedEntity((class_1657)player);
        if (possessedEntity != null && possessedEntity.method_37908() != player.method_37908()) {
            Helper.log("Move Requiem Posessed Entity at Server");
            ServerTeleportationManager.of(player.field_13995).changeEntityDimension((class_1297)possessedEntity, (class_5321<class_1937>)player.method_37908().method_27983(), McHelper.getEyePos((class_1297)player), false);
        }
    }
}

