/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal;

import com.google.common.collect.Streams;
import com.mojang.datafixers.util.Pair;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorage;
import qouteall.q_misc_util.my_util.RayTraceResult;

public class PortalUtils {
    @NotNull
    public static Optional<Pair<Portal, RayTraceResult>> raytracePortals(class_1937 world, class_243 from, class_243 to, boolean includeGlobalPortal, Predicate<Portal> predicate) {
        return PortalUtils.lenientRayTracePortals(world, from, to, includeGlobalPortal, predicate, 0.001);
    }

    @NotNull
    public static Optional<Pair<Portal, RayTraceResult>> lenientRayTracePortals(class_1937 world, class_243 from, class_243 to, boolean includeGlobalPortal, Predicate<Portal> predicate, double leniency) {
        Stream portalStream = McHelper.getEntitiesNearby(world, from, Portal.class, from.method_1022(to)).stream();
        if (includeGlobalPortal) {
            List<Portal> globalPortals = GlobalPortalStorage.getGlobalPortals(world);
            portalStream = Streams.concat((Stream[])new Stream[]{portalStream, globalPortals.stream()});
        }
        return portalStream.map(portal -> new Pair(portal, (Object)portal.generalRayTrace(from, to, leniency))).filter(portalAndHitPos -> portalAndHitPos.getSecond() != null && predicate.test((Portal)portalAndHitPos.getFirst())).min(Comparator.comparingDouble(portalAndHitPos -> ((RayTraceResult)portalAndHitPos.getSecond()).hitPos().method_1025(from)));
    }

    public static Optional<Pair<Portal, RayTraceResult>> raytracePortalFromEntityView(class_1297 player, float tickDelta, double maxDistance, boolean includeGlobalPortal, Predicate<Portal> predicate) {
        class_243 from = player.method_5836(tickDelta);
        class_243 to = from.method_1019(player.method_5828(tickDelta).method_1021(maxDistance));
        class_1937 world = player.method_37908();
        return PortalUtils.raytracePortals(world, from, to, includeGlobalPortal, predicate);
    }

    @Nullable
    public static PortalAwareRaytraceResult portalAwareRayTrace(class_1297 entity, double maxDistance) {
        return PortalUtils.portalAwareRayTrace(entity.method_37908(), entity.method_33571(), entity.method_5828(1.0f), maxDistance, entity);
    }

    @Nullable
    public static PortalAwareRaytraceResult portalAwareRayTrace(class_1937 world, class_243 startingPoint, class_243 direction, double maxDistance, class_1297 entity) {
        return PortalUtils.portalAwareRayTrace(world, startingPoint, direction, maxDistance, entity, List.of());
    }

    @Nullable
    public static PortalAwareRaytraceResult portalAwareRayTrace(class_1937 world, class_243 startingPoint, class_243 direction, double maxDistance, class_1297 entity, class_3959.class_3960 clipContextBlock) {
        return PortalUtils.portalAwareRayTrace(world, startingPoint, direction, maxDistance, entity, clipContextBlock, List.of());
    }

    @Nullable
    public static PortalAwareRaytraceResult portalAwareRayTrace(class_1937 world, class_243 startingPoint, class_243 direction, double maxDistance, class_1297 entity, @NotNull List<Portal> portalsPassingThrough) {
        return PortalUtils.portalAwareRayTrace(world, startingPoint, direction, maxDistance, entity, class_3959.class_3960.field_17559, portalsPassingThrough);
    }

    @Nullable
    public static PortalAwareRaytraceResult portalAwareRayTrace(class_1937 world, class_243 startingPoint, class_243 direction, double maxDistance, class_1297 entity, class_3959.class_3960 clipContextBlock, @NotNull List<Portal> portalsPassingThrough) {
        return PortalUtils.portalAwareRayTraceFull(world, startingPoint, direction, maxDistance, entity, clipContextBlock, class_3959.class_242.field_1348, portalsPassingThrough, 5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static PortalAwareRaytraceResult portalAwareRayTraceFull(class_1937 world, class_243 startingPoint, class_243 direction, double maxDistance, class_1297 entity, class_3959.class_3960 clipContextBlock, class_3959.class_242 clipContextFluid, @NotNull List<Portal> portalsPassingThrough, int maxPortalLayer) {
        double portalDistance;
        RayTraceResult rtResult;
        if (portalsPassingThrough.size() > maxPortalLayer) {
            return null;
        }
        class_243 endingPoint = startingPoint.method_1019(direction.method_1021(maxDistance));
        Optional<Pair<Portal, RayTraceResult>> portalHit = PortalUtils.raytracePortals(world, startingPoint, endingPoint, true, p -> {
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                return p.isInteractableBy(player);
            }
            return p.isVisible();
        });
        class_3959 context = new class_3959(startingPoint, endingPoint, clipContextBlock, clipContextFluid, entity);
        class_3965 blockHitResult = world.method_17742(context);
        boolean portalHitFound = portalHit.isPresent();
        boolean blockHitFound = blockHitResult.method_17783() == class_239.class_240.field_1332;
        boolean shouldContinueRaytraceInsidePortal = false;
        if (portalHitFound && blockHitFound) {
            double blockDistance;
            rtResult = (RayTraceResult)portalHit.get().getSecond();
            portalDistance = rtResult.hitPos().method_1022(startingPoint);
            if (!(portalDistance < (blockDistance = blockHitResult.method_17784().method_1022(startingPoint)) + 1.0E-4)) return new PortalAwareRaytraceResult(world, blockHitResult, portalsPassingThrough);
            shouldContinueRaytraceInsidePortal = true;
        } else {
            if (!portalHitFound && blockHitFound) {
                return new PortalAwareRaytraceResult(world, blockHitResult, portalsPassingThrough);
            }
            if (portalHitFound && !blockHitFound) {
                shouldContinueRaytraceInsidePortal = true;
            }
        }
        if (!shouldContinueRaytraceInsidePortal) return null;
        rtResult = (RayTraceResult)portalHit.get().getSecond();
        portalDistance = rtResult.hitPos().method_1022(startingPoint);
        Portal portal = (Portal)portalHit.get().getFirst();
        class_243 newStartingPoint = portal.transformPoint(rtResult.hitPos()).method_1019(rtResult.surfaceNormal().method_1021(-0.001));
        class_243 newDirection = portal.transformLocalVecNonScale(direction);
        double restDistance = maxDistance - portalDistance;
        if (!(restDistance < 0.0)) return PortalUtils.portalAwareRayTraceFull(portal.getDestinationWorld(), newStartingPoint, newDirection, restDistance, entity, clipContextBlock, clipContextFluid, Stream.concat(portalsPassingThrough.stream(), Stream.of(portal)).collect(Collectors.toList()), maxPortalLayer);
        return null;
    }

    public record PortalAwareRaytraceResult(class_1937 world, @NotNull class_3965 hitResult, List<Portal> portalsPassingThrough) {
    }
}

