/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.animation;

import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3d;
import org.joml.Matrix3dc;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import qouteall.imm_ptl.core.portal.PortalManipulation;
import qouteall.imm_ptl.core.portal.PortalState;
import qouteall.imm_ptl.core.portal.animation.DeltaUnilateralPortalState;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.DQuaternion;
import qouteall.q_misc_util.my_util.animation.Animated;

public record UnilateralPortalState(class_5321<class_1937> dimension, class_243 position, DQuaternion orientation, double width, double height, double thickness, Matrix3dc orientationMatrix, Matrix3dc orientationMatrixReverse) {
    public static final Animated.TypeInfo<UnilateralPortalState> ANIMATION_TYPE_INFO = new Animated.TypeInfo<UnilateralPortalState>(){

        @Override
        public UnilateralPortalState interpolate(UnilateralPortalState start, UnilateralPortalState end, double progress) {
            if (start.dimension() != end.dimension()) {
                return end;
            }
            Pair<RectInvariant, UnilateralPortalState> p = start.turnToClosestTo(end.orientation());
            start = (UnilateralPortalState)p.getSecond();
            return new UnilateralPortalState(start.dimension(), start.position().method_35590(end.position(), progress), DQuaternion.interpolate(start.orientation(), end.orientation(), progress), class_3532.method_16436((double)progress, (double)start.width(), (double)end.width()), class_3532.method_16436((double)progress, (double)start.height(), (double)end.height()), class_3532.method_16436((double)progress, (double)start.thickness(), (double)end.thickness()));
        }

        @Override
        public boolean isClose(UnilateralPortalState a, UnilateralPortalState b) {
            return a.dimension() == b.dimension() && a.position().method_1025(b.position()) < 1.0E-4 && DQuaternion.isClose(a.orientation(), b.orientation()) && Math.abs(a.width() - b.width()) < 0.001 && Math.abs(a.height() - b.height()) < 0.001 && Math.abs(a.thickness() - b.thickness()) < 0.001;
        }
    };

    public UnilateralPortalState(class_5321<class_1937> dimension, class_243 position, DQuaternion orientation, double width, double height) {
        this(dimension, position, orientation, width, height, 0.0);
    }

    public UnilateralPortalState(class_5321<class_1937> dimension, class_243 position, DQuaternion orientation, double width, double height, double thickness) {
        this(dimension, position, orientation, width, height, thickness, (Matrix3dc)new Matrix3d().set((Quaternionfc)orientation.toMcQuaternion()), (Matrix3dc)new Matrix3d().set((Quaternionfc)orientation.toMcQuaternion().conjugate()));
    }

    public static UnilateralPortalState extractThisSide(PortalState portalState) {
        return new UnilateralPortalState(portalState.fromWorld, portalState.fromPos, portalState.orientation, portalState.width, portalState.height, portalState.thickness);
    }

    public static UnilateralPortalState extractOtherSide(PortalState portalState) {
        DQuaternion otherSideOrientation = portalState.rotation.hamiltonProduct(portalState.orientation).hamiltonProduct(portalState.isMirror ? DQuaternion.identity : PortalManipulation.flipAxisW);
        return new UnilateralPortalState(portalState.toWorld, portalState.toPos, otherSideOrientation, portalState.width * portalState.scaling, portalState.height * portalState.scaling, portalState.thickness * portalState.scaling);
    }

    public static PortalState combine(UnilateralPortalState thisSide, UnilateralPortalState otherSide) {
        DQuaternion otherSideOrientation = otherSide.orientation;
        DQuaternion thisSideOrientation = thisSide.orientation;
        DQuaternion rotation = PortalManipulation.computeDeltaTransformation(thisSideOrientation, otherSideOrientation);
        double scale = otherSide.width / thisSide.width;
        PortalState result = new PortalState(thisSide.dimension, thisSide.position, otherSide.dimension, otherSide.position, scale, rotation, thisSide.orientation, thisSide.width, thisSide.height, thisSide.thickness, false);
        return result;
    }

    public static UnilateralPortalState interpolate(UnilateralPortalState from, UnilateralPortalState to, double progress) {
        return new UnilateralPortalState(from.dimension, Helper.interpolatePos(from.position, to.position, progress), DQuaternion.interpolate(from.orientation, to.orientation, progress), class_3532.method_16436((double)progress, (double)from.width, (double)to.width), class_3532.method_16436((double)progress, (double)from.height, (double)to.height), class_3532.method_16436((double)progress, (double)from.thickness, (double)to.thickness));
    }

    public class_2487 toTag() {
        class_2487 tag = new class_2487();
        tag.method_10582("dimension", this.dimension.method_29177().toString());
        Helper.putVec3d(tag, "position", this.position);
        tag.method_10566("orientation", this.orientation.toTag());
        tag.method_10549("width", this.width);
        tag.method_10549("height", this.height);
        tag.method_10549("thickness", this.thickness);
        return tag;
    }

    public static UnilateralPortalState fromTag(class_2487 tag) {
        class_5321<class_1937> dimension = Helper.dimIdToKey(tag.method_10558("dimension"));
        class_243 point = Helper.getVec3d(tag, "position");
        DQuaternion orientation = DQuaternion.fromTag((class_2520)tag.method_10562("orientation"));
        double width = tag.method_10574("width");
        double height = tag.method_10574("height");
        double thickness = tag.method_10574("thickness");
        return new UnilateralPortalState(dimension, point, orientation, width, height, thickness);
    }

    public DeltaUnilateralPortalState subtract(UnilateralPortalState other) {
        return DeltaUnilateralPortalState.fromDiff(other, this);
    }

    public UnilateralPortalState apply(DeltaUnilateralPortalState thisSideDelta) {
        return new Builder().from(this).apply(thisSideDelta).build();
    }

    public class_243 getAxisW() {
        return new class_243(this.orientationMatrix.m00(), this.orientationMatrix.m01(), this.orientationMatrix.m02());
    }

    public class_243 getAxisH() {
        return new class_243(this.orientationMatrix.m10(), this.orientationMatrix.m11(), this.orientationMatrix.m12());
    }

    public class_243 getNormal() {
        return new class_243(this.orientationMatrix.m20(), this.orientationMatrix.m21(), this.orientationMatrix.m22());
    }

    public class_243 pointOnPlane(double x, double y) {
        return this.transformLocalToGlobal(x, y, 0.0);
    }

    public class_243 transformLocalToGlobal(double x, double y, double z) {
        Vector3d v = new Vector3d(x, y, z);
        this.orientationMatrix.transform(v);
        v.add(this.position.method_10216(), this.position.method_10214(), this.position.method_10215());
        return new class_243(v.x, v.y, v.z);
    }

    public class_243 transformLocalToGlobal(class_243 vec3) {
        return this.transformLocalToGlobal(vec3.field_1352, vec3.field_1351, vec3.field_1350);
    }

    public class_243 transformGlobalToLocal(double x, double y, double z) {
        Vector3d v = new Vector3d(x, y, z);
        v.sub(this.position.method_10216(), this.position.method_10214(), this.position.method_10215());
        this.orientationMatrixReverse.transform(v);
        return new class_243(v.x, v.y, v.z);
    }

    public class_243 transformGlobalToLocal(class_243 vec3) {
        return this.transformGlobalToLocal(vec3.field_1352, vec3.field_1351, vec3.field_1350);
    }

    public class_243 transformVecLocalToGlobal(class_243 vec3) {
        Vector3d v = new Vector3d(vec3.field_1352, vec3.field_1351, vec3.field_1350);
        this.orientationMatrix.transform(v);
        return new class_243(v.x, v.y, v.z);
    }

    public class_243 transformVecGlobalToLocal(class_243 vec3) {
        Vector3d v = new Vector3d(vec3.field_1352, vec3.field_1351, vec3.field_1350);
        this.orientationMatrixReverse.transform(v);
        return new class_243(v.x, v.y, v.z);
    }

    public Pair<RectInvariant, UnilateralPortalState> turnToClosestTo(DQuaternion targetOrientation) {
        return Arrays.stream(RectInvariant.values()).map(inv -> Pair.of((Object)inv, (Object)inv.getVariantOf(this))).min(Comparator.comparingDouble(p -> DQuaternion.distanceSq(((UnilateralPortalState)p.getSecond()).orientation(), targetOrientation))).orElseThrow();
    }

    public static class Builder {
        public class_5321<class_1937> dimension;
        public class_243 position;
        public DQuaternion orientation;
        public double width;
        public double height;
        public double thickness;

        public UnilateralPortalState build() {
            Validate.notNull(this.dimension, (String)"dimension is null", (Object[])new Object[0]);
            Validate.notNull((Object)this.position, (String)"position is null", (Object[])new Object[0]);
            Validate.notNull((Object)this.orientation, (String)"orientation is null", (Object[])new Object[0]);
            Validate.isTrue((this.width > 0.0 ? 1 : 0) != 0, (String)"invalid width %s", (double)this.width);
            Validate.isTrue((this.height > 0.0 ? 1 : 0) != 0, (String)"invalid height %s", (double)this.height);
            return new UnilateralPortalState(this.dimension, this.position, this.orientation, this.width, this.height, this.thickness);
        }

        public Builder dimension(class_5321<class_1937> dimension) {
            this.dimension = dimension;
            return this;
        }

        public Builder position(class_243 point) {
            this.position = point;
            return this;
        }

        public Builder orientation(DQuaternion orientation) {
            this.orientation = orientation;
            return this;
        }

        public Builder width(double width) {
            this.width = width;
            return this;
        }

        public Builder height(double height) {
            this.height = height;
            return this;
        }

        public Builder thickness(double thickness) {
            this.thickness = thickness;
            return this;
        }

        @NotNull
        public Builder from(UnilateralPortalState other) {
            this.dimension = other.dimension;
            this.position = other.position;
            this.orientation = other.orientation;
            this.width = other.width;
            this.height = other.height;
            this.thickness = other.thickness;
            return this;
        }

        public Builder offset(class_243 offset) {
            this.position = this.position.method_1019(offset);
            return this;
        }

        public Builder rotate(DQuaternion rotation) {
            this.orientation = rotation.hamiltonProduct(this.orientation);
            return this;
        }

        public Builder scaleWidth(double scale) {
            this.width *= scale;
            return this;
        }

        public Builder scaleHeight(double scale) {
            this.height *= scale;
            return this;
        }

        public Builder scaleThickness(double scale) {
            this.thickness *= scale;
            return this;
        }

        public Builder apply(DeltaUnilateralPortalState delta) {
            if (delta.offset() != null) {
                this.position = this.position.method_1019(delta.offset());
            }
            if (delta.rotation() != null) {
                this.orientation = delta.rotation().hamiltonProduct(this.orientation);
            }
            if (delta.sizeScaling() != null) {
                this.width *= delta.sizeScaling().method_10216();
                this.height *= delta.sizeScaling().method_10214();
                this.thickness *= delta.sizeScaling().method_10215();
            }
            return this;
        }
    }

    public static enum RectInvariant {
        IDENTITY,
        ROTATE_90,
        ROTATE_180,
        ROTATE_270,
        FLIP_X,
        FLIP_X_ROTATE_90,
        FLIP_X_ROTATE_180,
        FLIP_X_ROTATE_270;


        public UnilateralPortalState getVariantOf(UnilateralPortalState state) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case IDENTITY -> state;
                case ROTATE_90 -> new UnilateralPortalState(state.dimension, state.position, state.orientation.hamiltonProduct(DQuaternion.rotationByDegrees(new class_243(0.0, 0.0, 1.0), 90.0)), state.height, state.width);
                case ROTATE_180 -> new UnilateralPortalState(state.dimension, state.position, state.orientation.hamiltonProduct(DQuaternion.rotationByDegrees(new class_243(0.0, 0.0, 1.0), 180.0)), state.width, state.height);
                case ROTATE_270 -> new UnilateralPortalState(state.dimension, state.position, state.orientation.hamiltonProduct(DQuaternion.rotationByDegrees(new class_243(0.0, 0.0, 1.0), 270.0)), state.height, state.width);
                case FLIP_X -> new UnilateralPortalState(state.dimension, state.position, state.orientation.hamiltonProduct(DQuaternion.rotationByDegrees(new class_243(1.0, 0.0, 0.0), 180.0)), state.width, state.height);
                case FLIP_X_ROTATE_90 -> new UnilateralPortalState(state.dimension, state.position, state.orientation.hamiltonProduct(DQuaternion.rotationByDegrees(new class_243(0.0, 0.0, 1.0), 90.0)).hamiltonProduct(DQuaternion.rotationByDegrees(new class_243(1.0, 0.0, 0.0), 180.0)), state.height, state.width);
                case FLIP_X_ROTATE_180 -> new UnilateralPortalState(state.dimension, state.position, state.orientation.hamiltonProduct(DQuaternion.rotationByDegrees(new class_243(0.0, 0.0, 1.0), 180.0)).hamiltonProduct(DQuaternion.rotationByDegrees(new class_243(1.0, 0.0, 0.0), 180.0)), state.width, state.height);
                case FLIP_X_ROTATE_270 -> new UnilateralPortalState(state.dimension, state.position, state.orientation.hamiltonProduct(DQuaternion.rotationByDegrees(new class_243(0.0, 0.0, 1.0), 270.0)).hamiltonProduct(DQuaternion.rotationByDegrees(new class_243(1.0, 0.0, 0.0), 180.0)), state.height, state.width);
            };
        }

        public boolean switchesWidthAndHeight() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case IDENTITY, ROTATE_180, FLIP_X, FLIP_X_ROTATE_180 -> false;
                case ROTATE_90, ROTATE_270, FLIP_X_ROTATE_90, FLIP_X_ROTATE_270 -> true;
            };
        }
    }
}

