/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.custom_portal_gen;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.registry.DynamicRegistries;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.IPPerServerInfo;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.mc_utils.ServerTaskList;
import qouteall.imm_ptl.core.portal.custom_portal_gen.CustomPortalGeneration;
import qouteall.imm_ptl.core.portal.custom_portal_gen.PortalGenTrigger;
import qouteall.q_misc_util.my_util.WithDim;

public class CustomPortalGenManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Multimap<class_1792, CustomPortalGeneration> useItemGen = HashMultimap.create();
    private final Multimap<class_1792, CustomPortalGeneration> throwItemGen = HashMultimap.create();
    private final ArrayList<CustomPortalGeneration> convGen = new ArrayList();
    private final Map<UUID, WithDim<class_243>> playerPosBeforeTravel = new HashMap<UUID, WithDim<class_243>>();

    public static void init() {
        DynamicRegistries.register(CustomPortalGeneration.REGISTRY_KEY, CustomPortalGeneration.CODEC);
        DynamicRegistries.register(CustomPortalGeneration.LEGACY_REGISTRY_KEY, CustomPortalGeneration.CODEC);
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.register((server, resourceManager, success) -> CustomPortalGenManager.onDataPackReloaded(server));
        ServerLifecycleEvents.SERVER_STARTED.register(CustomPortalGenManager::onDataPackReloaded);
    }

    private static void onDataPackReloaded(MinecraftServer server) {
        if (!IPGlobal.enableDatapackPortalGen) {
            return;
        }
        LOGGER.info("Processing custom portal generation");
        CustomPortalGenManager manager = new CustomPortalGenManager();
        class_2378 registry = server.method_30611().method_30530(CustomPortalGeneration.REGISTRY_KEY);
        class_2378 legacyRegistry = server.method_30611().method_30530(CustomPortalGeneration.LEGACY_REGISTRY_KEY);
        for (Map.Entry entry : registry.method_29722()) {
            manager.addEntry(server, (class_5321<CustomPortalGeneration>)((class_5321)entry.getKey()), (CustomPortalGeneration)entry.getValue());
        }
        for (Map.Entry entry : legacyRegistry.method_29722()) {
            manager.addEntry(server, (class_5321<CustomPortalGeneration>)((class_5321)entry.getKey()), (CustomPortalGeneration)entry.getValue());
        }
        IPPerServerInfo perServerInfo = IPPerServerInfo.of(server);
        perServerInfo.customPortalGenManager = manager;
    }

    private void addEntry(MinecraftServer server, class_5321<CustomPortalGeneration> key, CustomPortalGeneration gen) {
        gen.identifier = key.method_29177();
        CustomPortalGeneration.InitializationResult r1 = gen.initAndCheck(server);
        if (!(r1 instanceof CustomPortalGeneration.InitializationOk)) {
            LOGGER.info("Custom portal generation is not activated: {}\n{}", (Object)r1, (Object)gen.toString());
            return;
        }
        LOGGER.info("Loaded Custom Portal Generation {}", (Object)key.method_29177());
        this.load(gen);
        if (gen.reversible) {
            CustomPortalGeneration reverse = gen.getReverse();
            if (reverse != null) {
                reverse.identifier = key.method_29177();
                CustomPortalGeneration.InitializationResult r2 = reverse.initAndCheck(server);
                if (!(r2 instanceof CustomPortalGeneration.InitializationOk)) {
                    LOGGER.info("Reverse custom portal generation is not activated: {}\n{}", (Object)r2, (Object)reverse.toString());
                    return;
                }
            } else {
                McHelper.sendMessageToFirstLoggedPlayer(server, (class_2561)class_2561.method_43470((String)("Cannot create reverse generation of " + gen)));
            }
        }
    }

    private void load(CustomPortalGeneration gen) {
        PortalGenTrigger trigger = gen.trigger;
        if (trigger instanceof PortalGenTrigger.UseItemTrigger) {
            this.useItemGen.put((Object)((PortalGenTrigger.UseItemTrigger)trigger).item, (Object)gen);
        } else if (trigger instanceof PortalGenTrigger.ThrowItemTrigger) {
            this.throwItemGen.put((Object)((PortalGenTrigger.ThrowItemTrigger)trigger).item, (Object)gen);
        } else if (trigger instanceof PortalGenTrigger.ConventionalDimensionChangeTrigger) {
            this.convGen.add(gen);
        }
    }

    public void onItemUse(class_1838 context, class_1269 actionResult) {
        if (context.method_8045().method_8608()) {
            return;
        }
        MinecraftServer server = context.method_8045().method_8503();
        class_1792 item = context.method_8041().method_7909();
        if (this.useItemGen.containsKey((Object)item)) {
            ServerTaskList.of(server).addTask(() -> {
                for (CustomPortalGeneration gen : this.useItemGen.get((Object)item)) {
                    PortalGenTrigger.UseItemTrigger trigger;
                    boolean result = gen.perform((class_3218)context.method_8045(), context.method_8037().method_10093(context.method_8038()), (class_1297)context.method_8036());
                    if (!result) continue;
                    PortalGenTrigger patt7309$temp = gen.trigger;
                    if (!(patt7309$temp instanceof PortalGenTrigger.UseItemTrigger) || !(trigger = (PortalGenTrigger.UseItemTrigger)patt7309$temp).shouldConsume(context)) break;
                    context.method_8041().method_7934(1);
                    break;
                }
                return true;
            });
        }
    }

    public void onItemTick(class_1542 entity) {
        Validate.isTrue((!entity.method_37908().method_8608() ? 1 : 0) != 0);
        if (!entity.method_6977()) {
            return;
        }
        class_1792 item = entity.method_6983().method_7909();
        Collection gens = this.throwItemGen.get((Object)item);
        if (gens.isEmpty()) {
            return;
        }
        ServerTaskList.of(entity.method_5682()).addTask(() -> {
            for (CustomPortalGeneration gen : gens) {
                boolean result = gen.perform((class_3218)entity.method_37908(), entity.method_24515(), (class_1297)entity);
                if (!result) continue;
                entity.method_6983().method_7934(1);
                break;
            }
            return true;
        });
    }

    public void onBeforeConventionalDimensionChange(class_3222 player) {
        this.playerPosBeforeTravel.put(player.method_5667(), new WithDim<class_243>((class_5321<class_1937>)player.method_37908().method_27983(), player.method_19538()));
    }

    public void onAfterConventionalDimensionChange(class_3222 player) {
        UUID uuid = player.method_5667();
        if (this.playerPosBeforeTravel.containsKey(uuid)) {
            WithDim<class_243> startCoord = this.playerPosBeforeTravel.get(uuid);
            class_3218 startWorld = player.field_13995.method_3847(startCoord.dimension());
            if (startWorld == null) {
                LOGGER.error("Cannot find world {}", startCoord.dimension());
                return;
            }
            class_2338 startPos = class_2338.method_49638((class_2374)((class_2374)startCoord.value()));
            for (CustomPortalGeneration gen : this.convGen) {
                boolean succeeded = gen.perform(startWorld, startPos, (class_1297)player);
                if (!succeeded) continue;
                this.playerPosBeforeTravel.remove(uuid);
                return;
            }
        }
        this.playerPosBeforeTravel.remove(uuid);
    }
}

