/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.custom_portal_gen.form;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.ListCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.IntStream;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalExtension;
import qouteall.imm_ptl.core.portal.PortalManipulation;
import qouteall.imm_ptl.core.portal.PortalPlaceholderBlock;
import qouteall.imm_ptl.core.portal.custom_portal_gen.CustomPortalGeneration;
import qouteall.imm_ptl.core.portal.custom_portal_gen.SimpleBlockPredicate;
import qouteall.imm_ptl.core.portal.custom_portal_gen.form.PortalGenForm;
import qouteall.imm_ptl.core.portal.nether_portal.BlockPortalShape;
import qouteall.imm_ptl.core.portal.nether_portal.GeneralBreakablePortal;
import qouteall.imm_ptl.core.portal.nether_portal.NetherPortalGeneration;
import qouteall.q_misc_util.my_util.DQuaternion;
import qouteall.q_misc_util.my_util.IntBox;

public class FlippingFloorSquareForm
extends PortalGenForm {
    public static final ListCodec<class_2248> blockListCodec = new ListCodec(class_7923.field_41175.method_39673());
    public static final Codec<FlippingFloorSquareForm> codec = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("length").forGetter(o -> o.length), (App)SimpleBlockPredicate.CODEC.fieldOf("frame_block").forGetter(o -> o.frameBlock), (App)SimpleBlockPredicate.CODEC.fieldOf("area_block").forGetter(o -> o.areaBlock), (App)SimpleBlockPredicate.CODEC.optionalFieldOf("up_frame_block", (Object)SimpleBlockPredicate.pass).forGetter(o -> o.upFrameBlock), (App)SimpleBlockPredicate.CODEC.optionalFieldOf("bottom_block", (Object)SimpleBlockPredicate.pass).forGetter(o -> o.bottomBlock)).apply((Applicative)instance, instance.stable(FlippingFloorSquareForm::new)));
    public final int length;
    public final SimpleBlockPredicate frameBlock;
    public final SimpleBlockPredicate areaBlock;
    public final SimpleBlockPredicate upFrameBlock;
    public final SimpleBlockPredicate bottomBlock;

    public FlippingFloorSquareForm(int length, SimpleBlockPredicate frameBlock, SimpleBlockPredicate areaBlock, SimpleBlockPredicate upFrameBlock, SimpleBlockPredicate bottomBlock) {
        this.length = length;
        this.frameBlock = frameBlock;
        this.areaBlock = areaBlock;
        this.upFrameBlock = upFrameBlock;
        this.bottomBlock = bottomBlock;
    }

    @Override
    public Codec<? extends PortalGenForm> getCodec() {
        return codec;
    }

    @Override
    public PortalGenForm getReverse() {
        return this;
    }

    @Override
    public boolean perform(CustomPortalGeneration cpg, class_3218 fromWorld, class_2338 startingPos, class_3218 toWorld, @Nullable class_1297 triggeringEntity) {
        SimpleBlockPredicate areaPredicate = this.areaBlock;
        SimpleBlockPredicate framePredicate = this.frameBlock;
        SimpleBlockPredicate bottomPredicate = this.bottomBlock;
        if (!areaPredicate.test(fromWorld.method_8320(startingPos))) {
            return false;
        }
        if (!bottomPredicate.test(fromWorld.method_8320(startingPos.method_10074()))) {
            return false;
        }
        BlockPortalShape fromShape = BlockPortalShape.findArea(startingPos, class_2350.class_2351.field_11052, blockPos -> areaPredicate.test(fromWorld.method_8320(blockPos)), blockPos -> framePredicate.test(fromWorld.method_8320(blockPos)));
        if (fromShape == null) {
            return false;
        }
        if (!this.checkFromShape(fromWorld, fromShape)) {
            return false;
        }
        class_2338 areaSize = fromShape.innerAreaBox.getSize();
        class_2338 toPos = cpg.mapPosition(fromShape.innerAreaBox.l, fromWorld, toWorld);
        IntBox placingBox = FlippingFloorSquareForm.findPortalPlacement(toWorld, areaSize, toPos);
        class_2338 offset = placingBox.l.method_10059((class_2382)fromShape.innerAreaBox.l);
        BlockPortalShape toShape = fromShape.getShapeWithMovedAnchor(fromShape.anchor.method_10081((class_2382)offset));
        fromShape.frameAreaWithoutCorner.forEach(fromWorldPos -> {
            class_2338 toWorldPos = fromWorldPos.method_10081((class_2382)offset);
            toWorld.method_8501(toWorldPos, fromWorld.method_8320(fromWorldPos));
            toWorld.method_8501(toWorldPos.method_10084(), fromWorld.method_8320(fromWorldPos.method_10084()));
        });
        NetherPortalGeneration.fillInPlaceHolderBlocks(fromWorld, fromShape);
        NetherPortalGeneration.fillInPlaceHolderBlocks(toWorld, toShape);
        Portal[] portals = FlippingFloorSquareForm.createPortals(fromWorld, toWorld, fromShape, toShape);
        cpg.onPortalsGenerated(portals);
        return true;
    }

    public boolean checkFromShape(class_3218 fromWorld, BlockPortalShape fromShape) {
        boolean areaSizeTest = BlockPortalShape.isSquareShape(fromShape, this.length);
        if (!areaSizeTest) {
            return false;
        }
        return fromShape.frameAreaWithoutCorner.stream().allMatch(blockPos -> this.upFrameBlock.test(fromWorld.method_8320(blockPos.method_10084()))) && fromShape.area.stream().allMatch(blockPos -> this.bottomBlock.test(fromWorld.method_8320(blockPos.method_10074())));
    }

    public static IntBox findPortalPlacement(class_3218 toWorld, class_2338 areaSize, class_2338 toPos) {
        return IntStream.range(toPos.method_10263() - 8, toPos.method_10263() + 8).boxed().flatMap(x -> IntStream.range(toPos.method_10260() - 8, toPos.method_10260() + 8).boxed().flatMap(z -> IntStream.range(McHelper.getMinY((class_1936)toWorld) + 5, McHelper.getMaxContentYExclusive((class_1936)toWorld) - 5).map(y -> McHelper.getMaxContentYExclusive((class_1936)toWorld) - y).mapToObj(y -> new class_2338(x.intValue(), y, z.intValue())))).map(blockPos -> IntBox.fromBasePointAndSize(blockPos, areaSize)).filter(intBox -> intBox.stream().allMatch(pos -> {
            class_2680 blockState = toWorld.method_8320(pos);
            return !blockState.method_26216((class_1922)toWorld, pos) && blockState.method_26204() != PortalPlaceholderBlock.instance && blockState.method_26227().method_15769();
        })).filter(intBox -> intBox.getSurfaceLayer(class_2350.field_11033).getMoved(class_2350.field_11033.method_10163()).stream().allMatch(blockPos -> {
            class_2680 blockState = toWorld.method_8320(blockPos);
            return !blockState.method_26215() && blockState.method_26204() != PortalPlaceholderBlock.instance;
        })).findFirst().orElseGet(() -> IntBox.fromBasePointAndSize(toPos, areaSize)).getMoved(class_2350.field_11033.method_10163());
    }

    public static GeneralBreakablePortal[] createPortals(class_3218 fromWorld, class_3218 toWorld, BlockPortalShape fromShape, BlockPortalShape toShape) {
        GeneralBreakablePortal pa = (GeneralBreakablePortal)GeneralBreakablePortal.ENTITY_TYPE.method_5883((class_1937)fromWorld);
        fromShape.initPortalPosAxisShape(pa, class_2350.class_2352.field_11056);
        pa.setDestination(toShape.innerAreaBox.getCenterVec());
        pa.setDestDim((class_5321<class_1937>)toWorld.method_27983());
        pa.setRotation(DQuaternion.rotationByDegrees(new class_243(1.0, 0.0, 0.0), 180.0));
        GeneralBreakablePortal pb = PortalManipulation.createReversePortal(pa, GeneralBreakablePortal.ENTITY_TYPE);
        pa.blockPortalShape = fromShape;
        pb.blockPortalShape = toShape;
        pa.reversePortalId = pb.method_5667();
        pb.reversePortalId = pa.method_5667();
        PortalExtension.get((Portal)pa).motionAffinity = 0.1;
        PortalExtension.get((Portal)pb).motionAffinity = 0.1;
        McHelper.spawnServerEntity(pa);
        McHelper.spawnServerEntity(pb);
        return new GeneralBreakablePortal[]{pa, pb};
    }
}

