/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.custom_portal_gen.form;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3233;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.portal.custom_portal_gen.PortalGenInfo;
import qouteall.imm_ptl.core.portal.custom_portal_gen.form.NetherPortalLikeForm;
import qouteall.imm_ptl.core.portal.custom_portal_gen.form.PortalGenForm;
import qouteall.imm_ptl.core.portal.nether_portal.BlockPortalShape;
import qouteall.imm_ptl.core.portal.nether_portal.NetherPortalGeneration;
import qouteall.q_misc_util.my_util.IntBox;

public class ScalingSquareForm
extends NetherPortalLikeForm {
    public static final Codec<ScalingSquareForm> codec = RecordCodecBuilder.create(instance -> instance.group((App)class_7923.field_41175.method_39673().fieldOf("from_frame_block").forGetter(o -> o.fromFrameBlock), (App)class_7923.field_41175.method_39673().fieldOf("area_block").forGetter(o -> o.areaBlock), (App)class_7923.field_41175.method_39673().fieldOf("to_frame_block").forGetter(o -> o.toFrameBlock), (App)Codec.INT.fieldOf("from_length").forGetter(o -> o.fromLength), (App)Codec.INT.fieldOf("to_length").forGetter(o -> o.toLength), (App)Codec.BOOL.fieldOf("generate_frame_if_not_found").forGetter(o -> o.generateFrameIfNotFound)).apply((Applicative)instance, instance.stable(ScalingSquareForm::new)));
    public final class_2248 fromFrameBlock;
    public final class_2248 areaBlock;
    public final class_2248 toFrameBlock;
    public final int fromLength;
    public final int toLength;

    public ScalingSquareForm(class_2248 fromFrameBlock, class_2248 areaBlock, class_2248 toFrameBlock, int fromLength, int toLength, boolean generateFrameIfNotFound) {
        super(generateFrameIfNotFound);
        this.fromFrameBlock = fromFrameBlock;
        this.areaBlock = areaBlock;
        this.toFrameBlock = toFrameBlock;
        this.fromLength = fromLength;
        this.toLength = toLength;
    }

    @Override
    public Codec<? extends PortalGenForm> getCodec() {
        return codec;
    }

    @Override
    public PortalGenForm getReverse() {
        return new ScalingSquareForm(this.toFrameBlock, this.areaBlock, this.fromFrameBlock, this.toLength, this.fromLength, this.generateFrameIfNotFound);
    }

    @Override
    public boolean testThisSideShape(class_3218 fromWorld, BlockPortalShape fromShape) {
        boolean isSquareShape = BlockPortalShape.isSquareShape(fromShape, this.fromLength);
        return isSquareShape;
    }

    @Override
    public Function<class_3233, Function<class_2338.class_2339, PortalGenInfo>> getFrameMatchingFunc(class_3218 fromWorld, class_3218 toWorld, BlockPortalShape fromShape) {
        BlockPortalShape template = this.getTemplateToShape(fromShape);
        Predicate<class_2680> areaPredicate = this.getAreaPredicate();
        Predicate<class_2680> otherSideFramePredicate = this.getOtherSideFramePredicate();
        class_2338.class_2339 temp2 = new class_2338.class_2339();
        return region -> blockPos -> {
            BlockPortalShape result = template.matchShapeWithMovedFirstFramePos(pos -> areaPredicate.test(region.method_8320(pos)), pos -> otherSideFramePredicate.test(region.method_8320(pos)), (class_2338)blockPos, temp2);
            if (result != null && (fromWorld != toWorld || fromShape.anchor != result.anchor)) {
                return new PortalGenInfo((class_5321<class_1937>)fromWorld.method_27983(), (class_5321<class_1937>)toWorld.method_27983(), fromShape, result, null, this.getScale());
            }
            return null;
        };
    }

    private double getScale() {
        return (double)this.toLength / (double)this.fromLength;
    }

    private BlockPortalShape getTemplateToShape(BlockPortalShape fromShape) {
        return BlockPortalShape.getSquareShapeTemplate(fromShape.axis, this.toLength);
    }

    @Override
    public void generateNewFrame(class_3218 fromWorld, BlockPortalShape fromShape, class_3218 toWorld, BlockPortalShape toShape) {
        for (class_2338 blockPos : toShape.frameAreaWithCorner) {
            toWorld.method_8501(blockPos, this.toFrameBlock.method_9564());
        }
    }

    @Override
    public PortalGenInfo getNewPortalPlacement(class_3218 toWorld, class_2338 toPos, class_3218 fromWorld, BlockPortalShape fromShape, @Nullable class_1297 triggeringEntity) {
        BlockPortalShape templateShape = this.getTemplateToShape(fromShape);
        IntBox airCubePlacement = NetherPortalGeneration.findAirCubePlacement(toWorld, toPos, templateShape.axis, templateShape.totalAreaBox.getSize(), true);
        BlockPortalShape placedShape = templateShape.getShapeWithMovedTotalAreaBox(airCubePlacement);
        return new PortalGenInfo((class_5321<class_1937>)fromWorld.method_27983(), (class_5321<class_1937>)toWorld.method_27983(), fromShape, placedShape, null, this.getScale());
    }

    @Override
    public Predicate<class_2680> getOtherSideFramePredicate() {
        return s -> s.method_26204() == this.toFrameBlock;
    }

    @Override
    public Predicate<class_2680> getThisSideFramePredicate() {
        return s -> s.method_26204() == this.fromFrameBlock;
    }

    @Override
    public Predicate<class_2680> getAreaPredicate() {
        return s -> s.method_26204() == this.areaBlock;
    }
}

