/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.global_portals;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8705;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import qouteall.dimlib.api.DimensionAPI;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPCGlobal;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.api.PortalAPI;
import qouteall.imm_ptl.core.ducks.IEClientWorld;
import qouteall.imm_ptl.core.network.ImmPtlNetworking;
import qouteall.imm_ptl.core.platform_specific.O_O;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;

public class GlobalPortalStorage
extends class_18 {
    public List<Portal> data;
    public final WeakReference<class_3218> world;
    private int version = 1;
    private boolean shouldReSync = false;
    @Nullable
    public class_2680 bedrockReplacement;

    public static void init() {
        ServerTickEvents.END_SERVER_TICK.register(server -> server.method_3738().forEach(world1 -> {
            GlobalPortalStorage gps = GlobalPortalStorage.get(world1);
            gps.tick();
        }));
        IPGlobal.SERVER_CLEANUP_EVENT.register(s -> {
            for (class_3218 world : s.method_3738()) {
                GlobalPortalStorage.get(world).onServerClose();
            }
        });
        DimensionAPI.SERVER_DIMENSION_DYNAMIC_UPDATE_EVENT.register((server, dims) -> {
            for (class_3218 world : server.method_3738()) {
                GlobalPortalStorage gps = GlobalPortalStorage.get(world);
                gps.clearAbnormalPortals();
                gps.syncToAllPlayers();
            }
        });
        if (!O_O.isDedicatedServer()) {
            GlobalPortalStorage.initClient();
        }
    }

    public static GlobalPortalStorage get(class_3218 world) {
        return (GlobalPortalStorage)world.method_17983().method_17924(new class_18.class_8645(() -> {
            Helper.log("Global portal storage initialized " + world.method_27983().method_29177());
            return new GlobalPortalStorage(world);
        }, nbt -> {
            GlobalPortalStorage globalPortalStorage = new GlobalPortalStorage(world);
            globalPortalStorage.fromNbt((class_2487)nbt);
            return globalPortalStorage;
        }, null), "global_portal");
    }

    @Environment(value=EnvType.CLIENT)
    private static void initClient() {
        IPCGlobal.CLIENT_CLEANUP_EVENT.register(GlobalPortalStorage::onClientCleanup);
    }

    @Environment(value=EnvType.CLIENT)
    private static void onClientCleanup() {
        if (ClientWorldLoader.getIsInitialized()) {
            for (class_638 clientWorld : ClientWorldLoader.getClientWorlds()) {
                for (Portal globalPortal : GlobalPortalStorage.getGlobalPortals((class_1937)clientWorld)) {
                    globalPortal.method_5650(class_1297.class_5529.field_27000);
                }
            }
        }
    }

    public GlobalPortalStorage(class_3218 world_) {
        this.world = new WeakReference<class_3218>(world_);
        this.data = new ArrayList<Portal>();
    }

    public static void onPlayerLoggedIn(class_3222 player) {
        MiscHelper.getServer().method_3738().forEach(world -> {
            GlobalPortalStorage storage = GlobalPortalStorage.get(world);
            if (!storage.data.isEmpty()) {
                class_2596<class_8705> packet = GlobalPortalStorage.createSyncPacket(world, storage);
                player.field_13987.method_14364(packet);
            }
        });
    }

    public static class_2596<class_8705> createSyncPacket(class_3218 world, GlobalPortalStorage storage) {
        return ServerPlayNetworking.createS2CPacket((FabricPacket)new ImmPtlNetworking.GlobalPortalSyncPacket(PortalAPI.serverDimKeyToInt(world.method_8503(), (class_5321<class_1937>)world.method_27983()), storage.method_75(new class_2487())));
    }

    public void onDataChanged() {
        this.method_78(true);
        this.shouldReSync = true;
    }

    public void removePortal(Portal portal) {
        this.data.remove(portal);
        portal.method_5650(class_1297.class_5529.field_26998);
        this.onDataChanged();
    }

    public void addPortal(Portal portal) {
        Validate.isTrue((!this.data.contains(portal) ? 1 : 0) != 0);
        Validate.isTrue((boolean)portal.isPortalValid());
        portal.isGlobalPortal = true;
        portal.myUnsetRemoved();
        this.data.add(portal);
        this.onDataChanged();
    }

    public void removePortals(Predicate<Portal> predicate) {
        this.data.removeIf(portal -> {
            boolean shouldRemove = predicate.test((Portal)portal);
            if (shouldRemove) {
                portal.method_5650(class_1297.class_5529.field_26998);
            }
            return shouldRemove;
        });
        this.onDataChanged();
    }

    private void syncToAllPlayers() {
        class_3218 currWorld = (class_3218)this.world.get();
        Validate.notNull((Object)currWorld);
        class_2596<class_8705> packet = GlobalPortalStorage.createSyncPacket(currWorld, this);
        McHelper.getRawPlayerList().forEach(player -> player.field_13987.method_14364(packet));
    }

    public void fromNbt(class_2487 tag) {
        class_3218 currWorld = (class_3218)this.world.get();
        Validate.notNull((Object)currWorld);
        List<Portal> newData = GlobalPortalStorage.getPortalsFromTag(tag, (class_1937)currWorld);
        this.data = newData;
        if (tag.method_10545("version")) {
            this.version = tag.method_10550("version");
        }
        this.bedrockReplacement = tag.method_10545("bedrockReplacement") ? class_2512.method_10681((class_7871)currWorld.method_45448(class_7924.field_41254), (class_2487)tag.method_10562("bedrockReplacement")) : null;
        this.clearAbnormalPortals();
    }

    private static List<Portal> getPortalsFromTag(class_2487 tag, class_1937 currWorld) {
        class_2499 listTag = tag.method_10554("data", 10);
        ArrayList<Portal> newData = new ArrayList<Portal>();
        for (int i = 0; i < listTag.size(); ++i) {
            class_2487 compoundTag = listTag.method_10602(i);
            Portal e = GlobalPortalStorage.readPortalFromTag(currWorld, compoundTag);
            if (e != null) {
                newData.add(e);
                continue;
            }
            Helper.err("error reading portal" + compoundTag);
        }
        return newData;
    }

    private static Portal readPortalFromTag(class_1937 currWorld, class_2487 compoundTag) {
        class_2960 entityId = new class_2960(compoundTag.method_10558("entity_type"));
        class_1299 entityType = (class_1299)class_7923.field_41177.method_10223(entityId);
        class_1297 e = entityType.method_5883(currWorld);
        e.method_5651(compoundTag);
        ((Portal)e).isGlobalPortal = true;
        ((Portal)e).updateCache();
        return (Portal)e;
    }

    public class_2487 method_75(class_2487 tag) {
        if (this.data == null) {
            return tag;
        }
        class_2499 listTag = new class_2499();
        class_3218 currWorld = (class_3218)this.world.get();
        Validate.notNull((Object)currWorld);
        for (Portal portal : this.data) {
            Validate.isTrue((portal.method_37908() == currWorld ? 1 : 0) != 0);
            class_2487 portalTag = new class_2487();
            portal.method_5647(portalTag);
            portalTag.method_10582("entity_type", class_1299.method_5890((class_1299)portal.method_5864()).toString());
            listTag.add((Object)portalTag);
        }
        tag.method_10566("data", (class_2520)listTag);
        tag.method_10569("version", this.version);
        if (this.bedrockReplacement != null) {
            tag.method_10566("bedrockReplacement", (class_2520)class_2512.method_10686((class_2680)this.bedrockReplacement));
        }
        return tag;
    }

    public void tick() {
        if (this.shouldReSync) {
            this.syncToAllPlayers();
            this.shouldReSync = false;
        }
        if (this.version <= 1) {
            GlobalPortalStorage.upgradeData((class_3218)this.world.get());
            this.version = 2;
            this.method_78(true);
        }
    }

    public void clearAbnormalPortals() {
        this.data.removeIf(e -> {
            class_5321<class_1937> dimensionTo = e.getDestDim();
            if (MiscHelper.getServer().method_3847(dimensionTo) == null) {
                Helper.err("Missing Dimension for global portal " + dimensionTo.method_29177());
                return true;
            }
            return false;
        });
    }

    private static void upgradeData(class_3218 world) {
    }

    @Environment(value=EnvType.CLIENT)
    public static void receiveGlobalPortalSync(class_5321<class_1937> dimension, class_2487 compoundTag) {
        class_638 world = ClientWorldLoader.getWorld(dimension);
        List<Portal> oldGlobalPortals = ((IEClientWorld)world).ip_getGlobalPortals();
        if (oldGlobalPortals != null) {
            for (Portal p : oldGlobalPortals) {
                p.method_5650(class_1297.class_5529.field_26998);
            }
        }
        List<Portal> newPortals = GlobalPortalStorage.getPortalsFromTag(compoundTag, (class_1937)world);
        for (Portal p : newPortals) {
            p.myUnsetRemoved();
            p.isGlobalPortal = true;
            Validate.isTrue((boolean)p.isPortalValid());
            ClientWorldLoader.getWorld(p.getDestDim());
        }
        ((IEClientWorld)world).ip_setGlobalPortals(newPortals);
        Helper.log("Global Portals Updated " + dimension.method_29177());
    }

    public static void convertNormalPortalIntoGlobalPortal(Portal portal) {
        Validate.isTrue((!portal.getIsGlobal() ? 1 : 0) != 0);
        Validate.isTrue((!portal.method_37908().method_8608() ? 1 : 0) != 0);
        portal.setPortalShapeToDefault();
        portal.method_5650(class_1297.class_5529.field_26998);
        Portal newPortal = McHelper.copyEntity(portal);
        GlobalPortalStorage.get((class_3218)portal.method_37908()).addPortal(newPortal);
    }

    public static void convertGlobalPortalIntoNormalPortal(Portal portal) {
        Validate.isTrue((boolean)portal.getIsGlobal());
        Validate.isTrue((!portal.method_37908().method_8608() ? 1 : 0) != 0);
        GlobalPortalStorage.get((class_3218)portal.method_37908()).removePortal(portal);
        Portal newPortal = McHelper.copyEntity(portal);
        McHelper.spawnServerEntity(newPortal);
    }

    private void onServerClose() {
        for (Portal portal : this.data) {
            portal.method_5650(class_1297.class_5529.field_27000);
        }
    }

    @NotNull
    public static List<Portal> getGlobalPortals(class_1937 world) {
        List<Portal> result = world.method_8608() ? CHelper.getClientGlobalPortal(world) : (world instanceof class_3218 ? GlobalPortalStorage.get((class_3218)((class_3218)world)).data : null);
        return result != null ? result : Collections.emptyList();
    }
}

