/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.nether_portal;

import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_2338;
import qouteall.q_misc_util.my_util.IntBox;

public class BlockTraverse {
    public static <T> T searchFromTo(int from, int to, IntFunc<T> func) {
        if (from > to) {
            for (int i = from; i >= to; --i) {
                T obj = func.eval(i);
                if (obj == null) continue;
                return obj;
            }
        } else {
            for (int i = from; i <= to; ++i) {
                T obj = func.eval(i);
                if (obj == null) continue;
                return obj;
            }
        }
        return null;
    }

    public static <T> T searchOnPlane(int centerX, int centerZ, int range, BiIntFunc<T> func) {
        T centerResult = func.eval(centerX, centerZ);
        if (centerResult != null) {
            return centerResult;
        }
        for (int layer = 1; layer < range; ++layer) {
            T obj;
            int w;
            for (w = 0; w < layer * 2; ++w) {
                obj = func.eval(layer + centerX, w + 1 - layer + centerZ);
                if (obj == null) continue;
                return obj;
            }
            for (w = 0; w < layer * 2; ++w) {
                obj = func.eval(-w + layer - 1 + centerX, layer + centerZ);
                if (obj == null) continue;
                return obj;
            }
            for (w = 0; w < layer * 2; ++w) {
                obj = func.eval(-layer + centerX, -w + layer - 1 + centerZ);
                if (obj == null) continue;
                return obj;
            }
            for (w = 0; w < layer * 2; ++w) {
                obj = func.eval(w + 1 - layer + centerX, -layer + centerZ);
                if (obj == null) continue;
                return obj;
            }
        }
        return null;
    }

    public static <T> T searchColumnedRaw(int centerX, int centerZ, int range, int startY, int endY, TriIntFunc<T> func) {
        return (T)BlockTraverse.searchOnPlane(centerX, centerZ, range, (x, z) -> BlockTraverse.searchFromTo(startY, endY, y -> func.eval(x, y, z)));
    }

    public static <T> T searchColumned(int centerX, int centerZ, int range, int startY, int endY, Function<class_2338, T> func) {
        class_2338.class_2339 temp = new class_2338.class_2339();
        return (T)BlockTraverse.searchColumnedRaw(centerX, centerZ, range, startY, endY, (x, y, z) -> {
            temp.method_10103(x, y, z);
            return func.apply((class_2338)temp);
        });
    }

    public static <T> T searchInBox(IntBox box, TriIntFunc<T> func) {
        for (int x = box.l.method_10263(); x <= box.h.method_10263(); ++x) {
            for (int y = box.l.method_10264(); y <= box.h.method_10264(); ++y) {
                for (int z = box.l.method_10260(); z <= box.h.method_10260(); ++z) {
                    T obj = func.eval(x, y, z);
                    if (obj == null) continue;
                    return obj;
                }
            }
        }
        return null;
    }

    public static <T> T searchInBox(IntBox box, Function<class_2338, T> func) {
        class_2338.class_2339 temp = new class_2338.class_2339();
        return (T)BlockTraverse.searchInBox(box, (int x, int y, int z) -> {
            temp.method_10103(x, y, z);
            return func.apply((class_2338)temp);
        });
    }

    public static boolean boxAllMatch(IntBox box, Predicate<class_2338> predicate) {
        Boolean result = BlockTraverse.searchInBox(box, (class_2338 mutable) -> {
            if (predicate.test((class_2338)mutable)) {
                return Boolean.TRUE;
            }
            return null;
        });
        return result != null;
    }

    public static interface IntFunc<T> {
        public T eval(int var1);
    }

    public static interface BiIntFunc<T> {
        public T eval(int var1, int var2);
    }

    public static interface TriIntFunc<T> {
        public T eval(int var1, int var2, int var3);
    }
}

