/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.nether_portal;

import java.util.List;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.mc_utils.ServerTaskList;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalPlaceholderBlock;
import qouteall.imm_ptl.core.portal.nether_portal.BlockPortalShape;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.DQuaternion;
import qouteall.q_misc_util.my_util.LimitedLogger;

public abstract class BreakablePortalEntity
extends Portal {
    public BlockPortalShape blockPortalShape;
    public UUID reversePortalId;
    public boolean unbreakable = false;
    private boolean isNotified = true;
    private boolean shouldBreakPortal = false;
    @Nullable
    protected OverlayInfo overlayInfo;
    private static final LimitedLogger limitedLogger = new LimitedLogger(20);

    public BreakablePortalEntity(class_1299<?> entityType_1, class_1937 world_1) {
        super(entityType_1, world_1);
    }

    @Override
    public boolean isPortalValid() {
        if (this.method_37908().field_9236) {
            return super.isPortalValid();
        }
        return super.isPortalValid() && this.blockPortalShape != null && this.reversePortalId != null;
    }

    @Override
    protected void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        if (compoundTag.method_10545("netherPortalShape")) {
            this.blockPortalShape = new BlockPortalShape(compoundTag.method_10562("netherPortalShape"));
        }
        this.reversePortalId = Helper.getUuid(compoundTag, "reversePortalId");
        if (this.reversePortalId == null) {
            Helper.err("missing reverse portal id " + compoundTag);
            this.reversePortalId = class_156.field_25140;
        }
        this.unbreakable = compoundTag.method_10577("unbreakable");
        if (compoundTag.method_10545("overlayBlockState")) {
            class_2680 overlayBlockState = class_2512.method_10681((class_7871)this.method_37908().method_45448(class_7924.field_41254), (class_2487)compoundTag.method_10562("overlayBlockState"));
            if (overlayBlockState.method_26215()) {
                this.overlayInfo = null;
            } else {
                double overlayOpacity = compoundTag.method_10574("overlayOpacity");
                if (overlayOpacity == 0.0) {
                    overlayOpacity = 0.5;
                }
                double overlayOffset = compoundTag.method_10574("overlayOffset");
                DQuaternion rotation = Helper.getQuaternion(compoundTag, "overlayRotation");
                this.overlayInfo = new OverlayInfo(overlayBlockState, overlayOpacity, overlayOffset, rotation);
            }
        } else {
            this.overlayInfo = null;
        }
    }

    @Override
    protected void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        if (this.blockPortalShape != null) {
            compoundTag.method_10566("netherPortalShape", (class_2520)this.blockPortalShape.toTag());
        }
        Helper.putUuid(compoundTag, "reversePortalId", this.reversePortalId);
        compoundTag.method_10556("unbreakable", this.unbreakable);
        if (this.overlayInfo != null) {
            compoundTag.method_10566("overlayBlockState", (class_2520)class_2512.method_10686((class_2680)this.overlayInfo.blockState));
            compoundTag.method_10549("overlayOpacity", this.overlayInfo.opacity);
            compoundTag.method_10549("overlayOffset", this.overlayInfo.offset);
            Helper.putQuaternion(compoundTag, "overlayRotation", this.overlayInfo.rotation);
        }
    }

    private void breakPortalOnThisSide() {
        this.blockPortalShape.area.forEach(blockPos -> {
            if (this.method_37908().method_8320(blockPos).method_26204() == PortalPlaceholderBlock.instance) {
                this.method_37908().method_8501(blockPos, class_2246.field_10124.method_9564());
            }
        });
        this.method_5650(class_1297.class_5529.field_26998);
        Helper.log("Broke " + this);
    }

    public void notifyPlaceholderUpdate() {
        this.isNotified = true;
    }

    private BreakablePortalEntity getReversePortal() {
        class_3218 world = this.method_5682().method_3847(this.getDestDim());
        class_1297 entity = world.method_14190(this.reversePortalId);
        if (entity instanceof BreakablePortalEntity) {
            return (BreakablePortalEntity)entity;
        }
        return null;
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (this.method_37908().method_8608()) {
            this.addSoundAndParticle();
        } else if (!this.unbreakable) {
            if (this.isNotified || this.method_37908().method_8510() % 233L == (long)(this.method_5628() % 233)) {
                this.isNotified = false;
                this.checkPortalIntegrity();
            }
            if (this.shouldBreakPortal) {
                this.breakPortalOnThisSide();
            }
        }
    }

    private void checkPortalIntegrity() {
        Validate.isTrue((!this.method_37908().field_9236 ? 1 : 0) != 0);
        if (!this.isPortalValid()) {
            this.method_5650(class_1297.class_5529.field_26998);
            return;
        }
        if (!this.isPortalIntactOnThisSide()) {
            this.markShouldBreak();
        } else if (!this.isPortalPaired()) {
            Helper.err("Break portal because of abnormal pairing");
            this.markShouldBreak();
        }
    }

    protected abstract boolean isPortalIntactOnThisSide();

    @Environment(value=EnvType.CLIENT)
    protected abstract void addSoundAndParticle();

    public boolean isPortalPaired() {
        Validate.isTrue((!this.method_37908().method_8608() ? 1 : 0) != 0);
        if (this.isOneWay()) {
            return true;
        }
        if (!this.isOtherSideChunkLoaded()) {
            return true;
        }
        List<BreakablePortalEntity> revs = BreakablePortalEntity.findReversePortals(this);
        if (revs.size() == 1) {
            BreakablePortalEntity reversePortal = revs.get(0);
            return !(reversePortal.getDestPos().method_1025(this.getOriginPos()) > 1.0);
        }
        return revs.size() <= 1;
    }

    public void markShouldBreak() {
        this.shouldBreakPortal = true;
        if (this.isOneWay()) {
            return;
        }
        BreakablePortalEntity reversePortal = this.getReversePortal();
        if (reversePortal != null) {
            reversePortal.shouldBreakPortal = true;
        } else {
            int[] counter = new int[]{30};
            ServerTaskList.of(this.method_5682()).addTask(() -> {
                BreakablePortalEntity reversePortal1 = this.getReversePortal();
                if (reversePortal1 != null) {
                    reversePortal1.shouldBreakPortal = true;
                    return true;
                }
                counter[0] = counter[0] - 1;
                return counter[0] >= 0;
            });
        }
    }

    public static <T extends Portal> List<T> findReversePortals(T portal) {
        List<Portal> revs = McHelper.findEntitiesByBox(portal.getClass(), portal.getDestinationWorld(), new class_238(class_2338.method_49638((class_2374)portal.getDestPos())), 10.0, e -> e.getOriginPos().method_1025(portal.getDestPos()) < 0.1 && e.getContentDirection().method_1026(portal.getNormal()) > 0.6);
        return revs;
    }

    public boolean isOneWay() {
        return this.reversePortalId.equals(class_156.field_25140);
    }

    public void markOneWay() {
        this.reversePortalId = class_156.field_25140;
    }

    public OverlayInfo getActualOverlay() {
        return this.overlayInfo;
    }

    public record OverlayInfo(class_2680 blockState, double opacity, double offset, @Nullable DQuaternion rotation) {
    }
}

