/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_276;
import net.minecraft.class_284;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_5321;
import net.minecraft.class_5912;
import net.minecraft.class_5944;
import net.minecraft.class_757;
import org.apache.commons.lang3.Validate;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.miscellaneous.IPVanillaCopy;
import qouteall.imm_ptl.core.portal.PortalLike;
import qouteall.imm_ptl.core.render.PortalRenderable;
import qouteall.imm_ptl.core.render.ViewAreaRenderer;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.imm_ptl.core.render.context_management.WorldRenderInfo;
import qouteall.q_misc_util.my_util.SignalBiArged;

public class MyRenderHelper {
    public static final class_310 client = class_310.method_1551();
    public static final SignalBiArged<class_5912, Consumer<class_5944>> loadShaderSignal = new SignalBiArged();
    public static DrawFbInAreaShader drawFbInAreaShader;
    public static class_5944 portalAreaShader;
    public static class_5944 blitScreenNoBlendShader;
    private static boolean debugEnabled;

    public static void init() {
        loadShaderSignal.connect((resourceManager, resultConsumer) -> {
            try {
                DrawFbInAreaShader shader = new DrawFbInAreaShader(MyRenderHelper.getResourceFactory(resourceManager), "portal_draw_fb_in_area", class_290.field_1576);
                resultConsumer.accept(shader);
                drawFbInAreaShader = shader;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        loadShaderSignal.connect((resourceManager, resultConsumer) -> {
            try {
                class_5944 shader = new class_5944(MyRenderHelper.getResourceFactory(resourceManager), "portal_area", class_290.field_1576);
                resultConsumer.accept(shader);
                portalAreaShader = shader;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        loadShaderSignal.connect((resourceManager, resultConsumer) -> {
            try {
                class_5944 shader = new class_5944(MyRenderHelper.getResourceFactory(resourceManager), "blit_screen_noblend", class_290.field_1575);
                resultConsumer.accept(shader);
                blitScreenNoBlendShader = shader;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static class_5912 getResourceFactory(final class_5912 resourceManager) {
        class_5912 resourceFactory = new class_5912(){

            public Optional<class_3298> method_14486(class_2960 resourceLocation) {
                class_2960 corrected = new class_2960("immersive_portals", resourceLocation.method_12832());
                return resourceManager.method_14486(corrected);
            }
        };
        return resourceFactory;
    }

    public static void drawPortalAreaWithFramebuffer(PortalRenderable portal, class_276 textureProvider, Matrix4f modelViewMatrix, Matrix4f projectionMatrix) {
        GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager._enableDepthTest();
        GlStateManager._depthMask((boolean)true);
        GlStateManager._viewport((int)0, (int)0, (int)textureProvider.field_1482, (int)textureProvider.field_1481);
        DrawFbInAreaShader shader = drawFbInAreaShader;
        shader.method_34583("DiffuseSampler", textureProvider.method_30277());
        shader.loadWidthHeight(textureProvider.field_1482, textureProvider.field_1481);
        if (shader.field_29470 != null) {
            shader.field_29470.method_1250(modelViewMatrix);
        }
        if (shader.field_29471 != null) {
            shader.field_29471.method_1250(projectionMatrix);
        }
        shader.method_34586();
        ViewAreaRenderer.buildPortalViewAreaTrianglesBuffer(class_243.field_1353, portal, CHelper.getCurrentCameraPos(), RenderStates.getPartialTick());
        shader.method_34585();
    }

    public static void renderScreenTriangle() {
        MyRenderHelper.renderScreenTriangle(255, 255, 255, 255);
    }

    public static void renderScreenTriangle(class_243 color) {
        MyRenderHelper.renderScreenTriangle((int)(color.field_1352 * 255.0), (int)(color.field_1351 * 255.0), (int)(color.field_1350 * 255.0), 255);
    }

    public static void testOneTriangle(int r, int g, int b, int a) {
        class_5944 shader = class_757.method_34540();
        Validate.notNull((Object)shader);
        Matrix4f identityMatrix = new Matrix4f();
        identityMatrix.identity();
        shader.field_29470.method_1250(identityMatrix);
        shader.field_29471.method_1250(identityMatrix);
        shader.method_34586();
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27379, class_290.field_1576);
        bufferBuilder.method_22912(-1.0, 1.0, 0.0).method_1336(r, g, b, a).method_1344();
        bufferBuilder.method_22912(-1.0, -1.0, 0.0).method_1336(r, g, b, a).method_1344();
        bufferBuilder.method_22912(1.0, -1.0, 0.0).method_1336(r, g, b, a).method_1344();
        bufferBuilder.method_22912(1.0, 0.0, 0.0).method_1336(r, g, b, a).method_1344();
        bufferBuilder.method_22912(0.0, 1.0, 0.0).method_1336(r, g, b, a).method_1344();
        bufferBuilder.method_22912(-1.0, 0.0, 0.0).method_1336(r, g, b, a).method_1344();
        class_286.method_43437((class_287.class_7433)bufferBuilder.method_1326());
        shader.method_34585();
    }

    @IPVanillaCopy
    public static void renderScreenTriangle(int r, int g, int b, int a) {
        class_5944 shader = class_757.method_34540();
        Validate.notNull((Object)shader);
        Matrix4f identityMatrix = new Matrix4f();
        identityMatrix.identity();
        shader.field_29470.method_1250(identityMatrix);
        shader.field_29471.method_1250(identityMatrix);
        shader.method_34586();
        class_289 tessellator = RenderSystem.renderThreadTesselator();
        class_287 bufferBuilder = tessellator.method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27379, class_290.field_1576);
        bufferBuilder.method_22912(1.0, -1.0, 0.0).method_1336(r, g, b, a).method_1344();
        bufferBuilder.method_22912(1.0, 1.0, 0.0).method_1336(r, g, b, a).method_1344();
        bufferBuilder.method_22912(-1.0, 1.0, 0.0).method_1336(r, g, b, a).method_1344();
        bufferBuilder.method_22912(-1.0, 1.0, 0.0).method_1336(r, g, b, a).method_1344();
        bufferBuilder.method_22912(-1.0, -1.0, 0.0).method_1336(r, g, b, a).method_1344();
        bufferBuilder.method_22912(1.0, -1.0, 0.0).method_1336(r, g, b, a).method_1344();
        class_286.method_43437((class_287.class_7433)bufferBuilder.method_1326());
        shader.method_34585();
    }

    public static void drawScreenFrameBuffer(class_276 textureProvider, boolean doUseAlphaBlend, boolean doEnableModifyAlpha) {
        float right = textureProvider.field_1480;
        float up = textureProvider.field_1477;
        float left = 0.0f;
        float bottom = 0.0f;
        int viewportWidth = textureProvider.field_1480;
        int viewportHeight = textureProvider.field_1477;
        MyRenderHelper.drawFramebufferWithViewport(textureProvider, doUseAlphaBlend, doEnableModifyAlpha, left, right, bottom, up, viewportWidth, viewportHeight);
    }

    public static void drawFramebuffer(class_276 textureProvider, boolean doUseAlphaBlend, boolean doEnableModifyAlpha, float xMin, double xMax, float yMin, double yMax) {
        MyRenderHelper.drawFramebufferWithViewport(textureProvider, doUseAlphaBlend, doEnableModifyAlpha, xMin, xMax, yMin, yMax, client.method_22683().method_4489(), client.method_22683().method_4506());
    }

    @IPVanillaCopy
    public static void drawFramebufferWithViewport(class_276 textureProvider, boolean doUseAlphaBlend, boolean doEnableModifyAlpha, float left, double right, float bottom, double up, int viewportWidth, int viewportHeight) {
        CHelper.checkGlError();
        GlStateManager._disableDepthTest();
        GlStateManager._depthMask((boolean)false);
        GlStateManager._viewport((int)0, (int)0, (int)viewportWidth, (int)viewportHeight);
        if (doUseAlphaBlend) {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ZERO, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
        } else {
            RenderSystem.disableBlend();
        }
        if (doEnableModifyAlpha) {
            GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        } else {
            GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        }
        class_5944 shader = doUseAlphaBlend ? MyRenderHelper.client.field_1773.field_29403 : blitScreenNoBlendShader;
        shader.method_34583("DiffuseSampler", (Object)textureProvider.method_30277());
        Matrix4f projectionMatrix = new Matrix4f().setOrtho(0.0f, (float)viewportWidth, (float)viewportHeight, 0.0f, 1000.0f, 3000.0f);
        shader.field_29470.method_1250(new Matrix4f().translation(0.0f, 0.0f, -2000.0f));
        shader.field_29471.method_1250(projectionMatrix);
        shader.method_34586();
        float textureXScale = (float)viewportWidth / (float)textureProvider.field_1482;
        float textureYScale = (float)viewportHeight / (float)textureProvider.field_1481;
        class_289 tessellator = RenderSystem.renderThreadTesselator();
        class_287 bufferBuilder = tessellator.method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
        bufferBuilder.method_22912((double)left, up, 0.0).method_22913(0.0f, 0.0f).method_1336(255, 255, 255, 255).method_1344();
        bufferBuilder.method_22912(right, up, 0.0).method_22913(textureXScale, 0.0f).method_1336(255, 255, 255, 255).method_1344();
        bufferBuilder.method_22912(right, (double)bottom, 0.0).method_22913(textureXScale, textureYScale).method_1336(255, 255, 255, 255).method_1344();
        bufferBuilder.method_22912((double)left, (double)bottom, 0.0).method_22913(0.0f, textureYScale).method_1336(255, 255, 255, 255).method_1344();
        class_286.method_43437((class_287.class_7433)bufferBuilder.method_1326());
        shader.method_34585();
        GlStateManager._depthMask((boolean)true);
        GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        CHelper.checkGlError();
    }

    public static void lateUpdateLight() {
        if (!ClientWorldLoader.getIsInitialized()) {
            return;
        }
        ClientWorldLoader.getClientWorlds().forEach(world -> {
            if (!RenderStates.isDimensionRendered((class_5321<class_1937>)world.method_27983())) {
                world.method_2935().method_12130().method_15516();
            }
        });
    }

    public static void earlyRemoteUpload() {
        if (!ClientWorldLoader.getIsInitialized()) {
            return;
        }
        ClientWorldLoader.WORLD_RENDERER_MAP.forEach((dim, worldRenderer) -> {
            if (MyRenderHelper.client.field_1687.method_27983() != dim) {
                worldRenderer.method_34810().method_22761();
            }
        });
    }

    public static void applyMirrorFaceCulling() {
        GL11.glCullFace((int)1028);
    }

    public static void recoverFaceCulling() {
        GL11.glCullFace((int)1029);
    }

    public static void clearAlphaTo1(class_276 mcFrameBuffer) {
        mcFrameBuffer.method_1235(true);
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)true);
        RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderSystem.clear((int)16384, (boolean)true);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }

    public static void restoreViewPort() {
        class_310 client = class_310.method_1551();
        GlStateManager._viewport((int)0, (int)0, (int)client.method_22683().method_4489(), (int)client.method_22683().method_4506());
    }

    public static float transformFogDistance(float value) {
        PortalLike renderingPortal;
        if (!WorldRenderInfo.isFogEnabled()) {
            return value * 23333.0f;
        }
        if (PortalRendering.isRendering() && (renderingPortal = PortalRendering.getRenderingPortal()).isFuseView()) {
            return value * 23333.0f;
        }
        return value;
    }

    public static void debugFramebufferDepth() {
        if (!debugEnabled) {
            return;
        }
        debugEnabled = false;
        int width = MyRenderHelper.client.method_1522().field_1482;
        int height = MyRenderHelper.client.method_1522().field_1481;
        ByteBuffer directBuffer = ByteBuffer.allocateDirect(width * height * 4).order(ByteOrder.LITTLE_ENDIAN);
        FloatBuffer floatBuffer = directBuffer.asFloatBuffer();
        GL11.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6402, (int)5126, (FloatBuffer)floatBuffer);
        float[] data = new float[width * height];
        floatBuffer.rewind();
        floatBuffer.get(data);
        float maxValue = (float)IntStream.range(0, data.length).mapToDouble(i -> data[i]).max().getAsDouble();
        float minValue = (float)IntStream.range(0, data.length).mapToDouble(i -> data[i]).min().getAsDouble();
        byte[] grayData = new byte[width * height];
        for (int i2 = 0; i2 < data.length; ++i2) {
            float datum = data[i2];
            datum = (datum - minValue) / (maxValue - minValue);
            grayData[i2] = (byte)(datum * 255.0f);
        }
        BufferedImage bufferedImage = new BufferedImage(width, height, 10);
        bufferedImage.setData(Raster.createRaster(bufferedImage.getSampleModel(), new DataBufferByte(grayData, grayData.length), new Point()));
        System.out.println("oops");
    }

    public static void debugFramebufferColorRed() {
        if (!debugEnabled) {
            return;
        }
        debugEnabled = false;
        int width = MyRenderHelper.client.method_1522().field_1482;
        int height = MyRenderHelper.client.method_1522().field_1481;
        ByteBuffer directBuffer = ByteBuffer.allocateDirect(width * height * 4).order(ByteOrder.LITTLE_ENDIAN);
        FloatBuffer floatBuffer = directBuffer.asFloatBuffer();
        GL11.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6403, (int)5126, (FloatBuffer)floatBuffer);
        float[] data = new float[width * height];
        floatBuffer.rewind();
        floatBuffer.get(data);
        float maxValue = (float)IntStream.range(0, data.length).mapToDouble(i -> data[i]).max().getAsDouble();
        float minValue = (float)IntStream.range(0, data.length).mapToDouble(i -> data[i]).min().getAsDouble();
        byte[] grayData = new byte[width * height];
        for (int i2 = 0; i2 < data.length; ++i2) {
            float datum = data[i2];
            datum = (datum - minValue) / (maxValue - minValue);
            grayData[i2] = (byte)(datum * 255.0f);
        }
        BufferedImage bufferedImage = new BufferedImage(width, height, 10);
        bufferedImage.setData(Raster.createRaster(bufferedImage.getSampleModel(), new DataBufferByte(grayData, grayData.length), new Point()));
        System.out.println("oops");
    }

    static {
        debugEnabled = false;
    }

    public static class DrawFbInAreaShader
    extends class_5944 {
        public final class_284 uniformW = this.method_34582("w");
        public final class_284 uniformH = this.method_34582("h");

        public DrawFbInAreaShader(class_5912 factory, String name, class_293 format) throws IOException {
            super(factory, name, format);
        }

        void loadWidthHeight(int w, int h) {
            this.uniformW.method_1251((float)w);
            this.uniformH.method_1251((float)h);
        }
    }
}

