/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_5819;
import net.minecraft.class_776;
import net.minecraft.class_777;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.system.MemoryStack;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.compat.iris_compatibility.IrisInterface;
import qouteall.imm_ptl.core.compat.sodium_compatibility.SodiumInterface;
import qouteall.imm_ptl.core.miscellaneous.IPVanillaCopy;
import qouteall.imm_ptl.core.portal.PortalLike;
import qouteall.imm_ptl.core.portal.nether_portal.BlockPortalShape;
import qouteall.imm_ptl.core.portal.nether_portal.BreakablePortalEntity;
import qouteall.imm_ptl.core.render.context_management.RenderStates;

@Environment(value=EnvType.CLIENT)
public class OverlayRendering {
    private static final class_5819 random = class_5819.method_43047();
    private static boolean shaderOverlayWarned = false;

    public static boolean shouldRenderOverlay(PortalLike portal) {
        BreakablePortalEntity breakablePortalEntity;
        if (portal instanceof BreakablePortalEntity && (breakablePortalEntity = (BreakablePortalEntity)portal).getActualOverlay() != null) {
            return breakablePortalEntity.isInFrontOfPortal(CHelper.getCurrentCameraPos());
        }
        return false;
    }

    public static void onRenderPortalEntity(PortalLike portal, class_4587 matrixStack, class_4597 vertexConsumerProvider) {
        if (IrisInterface.invoker.isShaders()) {
            if (!shaderOverlayWarned) {
                shaderOverlayWarned = true;
                CHelper.printChat("[Immersive Portals] Portal overlay cannot be rendered with shaders");
            }
            return;
        }
        if (portal instanceof BreakablePortalEntity) {
            OverlayRendering.renderBreakablePortalOverlay((BreakablePortalEntity)portal, RenderStates.getPartialTick(), matrixStack, vertexConsumerProvider);
        }
    }

    public static List<class_777> getQuads(class_1087 model, class_2680 blockState, class_243 portalNormal) {
        class_2350 facing = class_2350.method_10142((double)portalNormal.field_1352, (double)portalNormal.field_1351, (double)portalNormal.field_1350);
        ArrayList<class_777> result = new ArrayList<class_777>();
        result.addAll(model.method_4707(blockState, facing, random));
        result.addAll(model.method_4707(blockState, null, random));
        if (result.isEmpty()) {
            for (class_2350 direction : class_2350.values()) {
                result.addAll(model.method_4707(blockState, direction, random));
            }
        }
        return result;
    }

    private static void renderBreakablePortalOverlay(BreakablePortalEntity portal, float tickDelta, class_4587 matrixStack, class_4597 vertexConsumerProvider) {
        BreakablePortalEntity.OverlayInfo overlay = portal.getActualOverlay();
        class_2680 blockState = overlay.blockState();
        class_243 cameraPos = CHelper.getCurrentCameraPos();
        if (blockState == null) {
            return;
        }
        class_776 blockRenderManager = class_310.method_1551().method_1541();
        BlockPortalShape blockPortalShape = portal.blockPortalShape;
        if (blockPortalShape == null) {
            return;
        }
        matrixStack.method_22903();
        class_243 offset = portal.getNormal().method_1021(overlay.offset());
        class_243 pos = portal.method_19538();
        matrixStack.method_22904(offset.field_1352, offset.field_1351, offset.field_1350);
        class_1087 model = blockRenderManager.method_3349(blockState);
        class_1921 renderLayer = class_4722.method_24076();
        class_4588 buffer = vertexConsumerProvider.getBuffer(renderLayer);
        List<class_777> quads = OverlayRendering.getQuads(model, blockState, portal.getNormal());
        random.method_43052(0L);
        for (class_2338 blockPos : blockPortalShape.area) {
            matrixStack.method_22903();
            matrixStack.method_22904((double)blockPos.method_10263() - pos.field_1352, (double)blockPos.method_10264() - pos.field_1351, (double)blockPos.method_10260() - pos.field_1350);
            if (overlay.rotation() != null) {
                matrixStack.method_22907(overlay.rotation().toMcQuaternion());
            }
            for (class_777 quad : quads) {
                SodiumInterface.invoker.markSpriteActive(quad.method_35788());
                OverlayRendering.renderQuad(buffer, matrixStack.method_23760(), quad, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, 1.0f, 1.0f, 1.0f, new int[]{0xE000F0, 0xE000F0, 0xE000F0, 0xE000F0}, class_4608.field_21444, true, (float)overlay.opacity());
            }
            matrixStack.method_22909();
        }
        matrixStack.method_22909();
    }

    @IPVanillaCopy
    public static void renderQuad(class_4588 vertexConsumer, class_4587.class_4665 poseEntry, class_777 quad, float[] colorMuls, float red, float green, float blue, int[] combinedLights, int combinedOverlay, boolean mulColor, float alpha) {
        float[] fs = new float[]{colorMuls[0], colorMuls[1], colorMuls[2], colorMuls[3]};
        int[] is = new int[]{combinedLights[0], combinedLights[1], combinedLights[2], combinedLights[3]};
        int[] js = quad.method_3357();
        class_2382 vec3i = quad.method_3358().method_10163();
        Vector3f vector3f = new Vector3f((float)vec3i.method_10263(), (float)vec3i.method_10264(), (float)vec3i.method_10260());
        Matrix4f matrix4f = poseEntry.method_23761();
        poseEntry.method_23762().transform(vector3f);
        int i = 8;
        int j = js.length / 8;
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            ByteBuffer byteBuffer = memoryStack.malloc(class_290.field_1590.method_1362());
            IntBuffer intBuffer = byteBuffer.asIntBuffer();
            for (int k = 0; k < j; ++k) {
                float q;
                float p;
                float o;
                float n;
                float m;
                intBuffer.clear();
                intBuffer.put(js, k * 8, 8);
                float f = byteBuffer.getFloat(0);
                float g = byteBuffer.getFloat(4);
                float h = byteBuffer.getFloat(8);
                if (mulColor) {
                    float l = (float)(byteBuffer.get(12) & 0xFF) / 255.0f;
                    m = (float)(byteBuffer.get(13) & 0xFF) / 255.0f;
                    n = (float)(byteBuffer.get(14) & 0xFF) / 255.0f;
                    o = l * fs[k] * red;
                    p = m * fs[k] * green;
                    q = n * fs[k] * blue;
                } else {
                    o = fs[k] * red;
                    p = fs[k] * green;
                    q = fs[k] * blue;
                }
                int r = is[k];
                m = byteBuffer.getFloat(16);
                n = byteBuffer.getFloat(20);
                Vector4f vector4f = new Vector4f(f, g, h, 1.0f);
                matrix4f.transform(vector4f);
                vertexConsumer.method_23919(vector4f.x(), vector4f.y(), vector4f.z(), o, p, q, alpha, m, n, combinedOverlay, r, vector3f.x(), vector3f.y(), vector3f.z());
            }
        }
    }
}

