/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render;

import java.util.List;
import java.util.Set;
import me.shedaniel.cloth.clothconfig.shadowed.org.yaml.snakeyaml.Yaml;
import net.minecraft.class_281;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.q_misc_util.Helper;

public class ShaderCodeTransformation {
    private static List<Config> configs;

    private static boolean matches(ShaderType me, class_281.class_282 type) {
        if (type == class_281.class_282.field_1531) {
            return me == ShaderType.fs;
        }
        if (type == class_281.class_282.field_1530) {
            return me == ShaderType.vs;
        }
        return false;
    }

    public static void init() {
        if (IPGlobal.enableClippingMechanism) {
            Yaml yaml = new Yaml();
            String yamlStr = McHelper.readTextResource(new class_2960("immersive_portals:shaders/shader_transformation.yaml"));
            ConfigsObj configsObj = (ConfigsObj)yaml.loadAs(yamlStr, ConfigsObj.class);
            configs = configsObj.configs;
            Helper.log("Loaded Shader Code Transformation");
        } else {
            Helper.log("Shader Transformation Disabled");
        }
    }

    public static String transform(class_281.class_282 type, String shaderId, String inputCode) {
        if (configs == null) {
            Helper.log("Shader Transform Skipping " + shaderId);
            return inputCode;
        }
        Config selected = ShaderCodeTransformation.getConfig(type, shaderId);
        if (selected == null) {
            return inputCode;
        }
        String result = inputCode;
        for (TransformationEntry entry : selected.transformations) {
            String replacement = String.join((CharSequence)"\n", entry.replacement);
            result = result.replaceAll(entry.pattern, replacement);
        }
        if (selected.debugOutput) {
            Helper.log("Shader Transformed " + shaderId + "\n" + result);
        }
        return result;
    }

    @Nullable
    private static Config getConfig(class_281.class_282 type, String shaderId) {
        return configs.stream().filter(config -> ShaderCodeTransformation.matches(config.type, type) && config.affectedShaders.contains(shaderId)).findFirst().orElse(null);
    }

    public static boolean shouldAddUniform(String shaderName) {
        if (configs == null) {
            Helper.log("Shader Transform Skipping " + shaderName);
            return false;
        }
        return configs.stream().anyMatch(config -> config.affectedShaders.contains(shaderName));
    }

    public static enum ShaderType {
        vs,
        fs;

    }

    public static class ConfigsObj {
        public List<Config> configs;
    }

    public static class Config {
        public String comment;
        public ShaderType type;
        public Set<String> affectedShaders;
        public List<TransformationEntry> transformations;
        public boolean debugOutput;
    }

    public static class TransformationEntry {
        public String comment;
        public String pattern;
        public String replacement;
    }
}

