/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import qouteall.imm_ptl.core.compat.GravityChangerInterface;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.imm_ptl.core.render.context_management.WorldRenderInfo;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.DQuaternion;

@Environment(value=EnvType.CLIENT)
public class TransformationManager {
    private static DQuaternion animationDeltaStart;
    private static long interpolationStartTime;
    private static long interpolationEndTime;
    public static final class_310 client;
    public static boolean isIsometricView;
    public static float isometricViewLength;
    public static boolean isCalculatingViewBobbingOffset;

    public static DQuaternion getPlayerCameraRotation() {
        class_746 player = TransformationManager.client.field_1724;
        if (player == null) {
            return DQuaternion.identity;
        }
        class_2350 gravity = GravityChangerInterface.invoker.getGravityDirection((class_1297)player);
        return TransformationManager.getCameraRotationWithGravity(gravity, player.method_36455(), player.method_36454());
    }

    private static DQuaternion getCameraRotationWithGravity(class_2350 gravityDirection, float pitch, float yaw) {
        DQuaternion gravity = GravityChangerInterface.invoker.getExtraCameraRotation(gravityDirection);
        DQuaternion rawCameraRotation = DQuaternion.getCameraRotation(pitch, yaw);
        if (gravity == null) {
            return rawCameraRotation;
        }
        return rawCameraRotation.hamiltonProduct(gravity);
    }

    @Nullable
    private static DQuaternion getCurrentAnimationDelta() {
        Double animationProgress = TransformationManager.getAnimationProgress();
        if (animationProgress != null) {
            double progress = animationProgress;
            return DQuaternion.interpolate(animationDeltaStart, DQuaternion.identity, TransformationManager.mapProgress(progress));
        }
        return null;
    }

    public static void processTransformation(class_4184 camera, class_4587 matrixStack) {
        DQuaternion currentAnimationDelta = TransformationManager.getCurrentAnimationDelta();
        if (currentAnimationDelta != null) {
            matrixStack.method_22907(currentAnimationDelta.toMcQuaternion());
        }
        WorldRenderInfo.applyAdditionalTransformations(matrixStack);
    }

    public static boolean isAnimationRunning() {
        return TransformationManager.getAnimationProgress() != null;
    }

    @Nullable
    public static Double getAnimationProgress() {
        if (interpolationStartTime == 0L) {
            return null;
        }
        if (animationDeltaStart == null) {
            return null;
        }
        double progress = (double)(RenderStates.renderStartNanoTime - interpolationStartTime) / ((double)interpolationEndTime - (double)interpolationStartTime);
        if (progress >= 0.0 && progress <= 1.0) {
            return progress;
        }
        return null;
    }

    public static double mapProgress(double progress) {
        return Math.sin(progress * 1.5707963267948966);
    }

    public static void managePlayerRotationAndChangeGravity(Portal portal) {
        if (portal.getRotation() != null) {
            class_746 player = TransformationManager.client.field_1724;
            class_2350 oldGravityDir = GravityChangerInterface.invoker.getGravityDirection((class_1297)player);
            DQuaternion oldCameraRotation = TransformationManager.getCameraRotationWithGravity(oldGravityDir, player.method_5695(RenderStates.getPartialTick()), player.method_5705(RenderStates.getPartialTick()));
            DQuaternion currentAnimationDelta = TransformationManager.getCurrentAnimationDelta();
            if (currentAnimationDelta != null) {
                oldCameraRotation = oldCameraRotation.hamiltonProduct(currentAnimationDelta);
            }
            DQuaternion immediateFinalRot = oldCameraRotation.hamiltonProduct(portal.getRotation().getConjugated());
            class_2350 oldBaseGravityDir = GravityChangerInterface.invoker.getBaseGravityDirection((class_1297)player);
            class_2350 newBaseGravityDir = portal.getTeleportedGravityDirection(oldBaseGravityDir);
            if (newBaseGravityDir != oldBaseGravityDir) {
                GravityChangerInterface.invoker.setClientPlayerGravityDirection((class_1657)player, newBaseGravityDir);
            }
            class_2350 immediateNewGravityDir = GravityChangerInterface.invoker.getGravityDirection((class_1297)player);
            DQuaternion newGravityRot = DQuaternion.fromNullable(GravityChangerInterface.invoker.getExtraCameraRotation(immediateNewGravityDir));
            DQuaternion newRawCameraRotation = immediateFinalRot.hamiltonProduct(newGravityRot.getConjugated());
            class_3545<Double, Double> pitchYaw = DQuaternion.getPitchYawFromRotation(newRawCameraRotation);
            float finalYaw = (float)((Double)pitchYaw.method_15441()).doubleValue();
            float finalPitch = (float)((Double)pitchYaw.method_15442()).doubleValue();
            if (finalPitch > 90.0f) {
                finalPitch = 90.0f - (finalPitch - 90.0f);
            } else if (finalPitch < -90.0f) {
                finalPitch = -90.0f + (-90.0f - finalPitch);
            }
            player.method_36456(finalYaw);
            player.method_36457(finalPitch);
            player.field_5982 = finalYaw;
            player.field_6004 = finalPitch;
            player.field_3932 = finalYaw;
            player.field_3916 = finalPitch;
            player.field_3931 = finalYaw;
            player.field_3914 = finalPitch;
            DQuaternion newCameraRotationWithGravity = TransformationManager.getCameraRotationWithGravity(immediateNewGravityDir, finalPitch, finalYaw);
            DQuaternion newAnimationDelta = newCameraRotationWithGravity.getConjugated().hamiltonProduct(immediateFinalRot);
            if (newAnimationDelta.getRotatingAngleDegrees() > 0.1) {
                animationDeltaStart = newAnimationDelta;
                interpolationStartTime = RenderStates.renderStartNanoTime;
                interpolationEndTime = interpolationStartTime + Helper.secondToNano(TransformationManager.getAnimationDurationSeconds());
            }
            TransformationManager.updateCamera(client);
        }
    }

    private static double getAnimationDurationSeconds() {
        return 1.0;
    }

    private static void updateCamera(class_310 client) {
        class_4184 camera = client.field_1773.method_19418();
        camera.method_19321((class_1922)client.field_1687, (class_1297)client.field_1724, !client.field_1690.method_31044().method_31034(), client.field_1690.method_31044().method_31035(), RenderStates.getPartialTick());
    }

    public static Matrix4f getMirrorTransformation(class_243 normal) {
        float x = (float)normal.field_1352;
        float y = (float)normal.field_1351;
        float z = (float)normal.field_1350;
        Matrix4f matrix = new Matrix4f();
        matrix.reflection(x, y, z, 0.0f);
        return matrix;
    }

    public static Matrix4f getIsometricProjection() {
        int w = client.method_22683().method_4489();
        int h = client.method_22683().method_4506();
        float wView = isometricViewLength / (float)h * (float)w;
        float near = -2000.0f;
        float far = 2000.0f;
        float left = -wView / 2.0f;
        float right = wView / 2.0f;
        float top = isometricViewLength / 2.0f;
        float bottom = -isometricViewLength / 2.0f;
        float[] arr = new float[]{2.0f / (right - left), 0.0f, 0.0f, -(right + left) / (right - left), 0.0f, 2.0f / (top - bottom), 0.0f, -(top + bottom) / (top - bottom), 0.0f, 0.0f, -2.0f / (far - near), -(far + near) / (far - near), 0.0f, 0.0f, 0.0f, 1.0f};
        Matrix4f m1 = new Matrix4f();
        m1.set(arr);
        return m1;
    }

    public static class_243 getIsometricAdjustedCameraPos() {
        class_4184 camera = TransformationManager.client.field_1773.method_19418();
        return TransformationManager.getIsometricAdjustedCameraPos(camera);
    }

    public static class_243 getIsometricAdjustedCameraPos(class_4184 camera) {
        class_243 cameraPos = camera.method_19326();
        if (!isIsometricView) {
            return cameraPos;
        }
        Quaternionf rotation = camera.method_23767();
        Vector3f vec = new Vector3f(0.0f, 0.0f, (float)(TransformationManager.client.field_1690.method_38521() * -10));
        rotation.transform(vec);
        return cameraPos.method_1031((double)vec.x(), (double)vec.y(), (double)vec.z());
    }

    static {
        interpolationStartTime = 0L;
        interpolationEndTime = 1L;
        client = class_310.method_1551();
        isIsometricView = false;
        isometricViewLength = 50.0f;
        isCalculatingViewBobbingOffset = false;
    }

    @Environment(value=EnvType.CLIENT)
    public static class RemoteCallables {
        public static void enableIsometricView(float viewLength) {
            isometricViewLength = viewLength;
            isIsometricView = true;
            TransformationManager.client.field_1730 = false;
        }

        public static void disableIsometricView() {
            isIsometricView = false;
            TransformationManager.client.field_1730 = true;
        }
    }
}

