/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayDeque;
import java.util.Stack;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_4076;
import net.minecraft.class_4184;
import net.minecraft.class_4604;
import net.minecraft.class_638;
import net.minecraft.class_846;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPCGlobal;
import qouteall.imm_ptl.core.chunk_loading.PerformanceLevel;
import qouteall.imm_ptl.core.ducks.IERenderSection;
import qouteall.imm_ptl.core.miscellaneous.ClientPerformanceMonitor;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalLike;
import qouteall.imm_ptl.core.portal.nether_portal.BlockTraverse;
import qouteall.imm_ptl.core.render.ImmPtlViewArea;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.imm_ptl.core.render.context_management.WorldRenderInfo;

@Environment(value=EnvType.CLIENT)
public class VisibleSectionDiscovery {
    private static ImmPtlViewArea builtChunks;
    private static class_4604 vanillaFrustum;
    private static ObjectArrayList<class_846.class_851> resultHolder;
    private static final ArrayDeque<class_846.class_851> tempQueue;
    private static class_4076 cameraSectionPos;
    private static long timeMark;
    private static int viewDistance;
    private static final Stack<ObjectArrayList<class_846.class_851>> listCaches;

    public static void discoverVisibleSections(class_638 world, ImmPtlViewArea builtChunks_, class_4184 camera, class_4604 vanillaFrustum_, ObjectArrayList<class_846.class_851> resultHolder_) {
        PortalLike renderingPortal;
        builtChunks = builtChunks_;
        vanillaFrustum = vanillaFrustum_;
        resultHolder = resultHolder_;
        resultHolder.clear();
        tempQueue.clear();
        VisibleSectionDiscovery.updateViewDistance();
        timeMark = System.nanoTime();
        class_243 cameraPos = camera.method_19326();
        vanillaFrustum.method_23088(cameraPos.field_1352, cameraPos.field_1351, cameraPos.field_1350);
        cameraSectionPos = class_4076.method_18682((class_2338)class_2338.method_49638((class_2374)cameraPos));
        class_4076 modifiedVisibleSectionIterationOrigin = null;
        if (PortalRendering.isRendering() && (renderingPortal = PortalRendering.getRenderingPortal()) instanceof Portal) {
            Portal portal = (Portal)renderingPortal;
            modifiedVisibleSectionIterationOrigin = portal.getPortalShape().getModifiedVisibleSectionIterationOrigin(portal, cameraPos);
        }
        if (modifiedVisibleSectionIterationOrigin != null) {
            VisibleSectionDiscovery.checkSection(modifiedVisibleSectionIterationOrigin.method_10263(), modifiedVisibleSectionIterationOrigin.method_10264(), modifiedVisibleSectionIterationOrigin.method_10260(), true);
        } else if (cameraPos.field_1351 < (double)world.method_31607()) {
            VisibleSectionDiscovery.discoverBottomOrTopLayerVisibleChunks(VisibleSectionDiscovery.builtChunks.minSectionY);
        } else if (cameraPos.field_1351 > (double)world.method_31600()) {
            VisibleSectionDiscovery.discoverBottomOrTopLayerVisibleChunks(VisibleSectionDiscovery.builtChunks.endSectionY - 1);
        } else {
            VisibleSectionDiscovery.checkSection(cameraSectionPos.method_18674(), cameraSectionPos.method_18683(), cameraSectionPos.method_18687(), true);
        }
        while (!tempQueue.isEmpty()) {
            class_846.class_851 curr = tempQueue.poll();
            int cx = class_4076.method_18675((int)curr.method_3670().method_10263());
            int cy = class_4076.method_18675((int)curr.method_3670().method_10264());
            int cz = class_4076.method_18675((int)curr.method_3670().method_10260());
            VisibleSectionDiscovery.checkSection(cx + 1, cy, cz, false);
            VisibleSectionDiscovery.checkSection(cx - 1, cy, cz, false);
            VisibleSectionDiscovery.checkSection(cx, cy + 1, cz, false);
            VisibleSectionDiscovery.checkSection(cx, cy - 1, cz, false);
            VisibleSectionDiscovery.checkSection(cx, cy, cz + 1, false);
            VisibleSectionDiscovery.checkSection(cx, cy, cz - 1, false);
        }
        resultHolder = null;
        builtChunks = null;
        vanillaFrustum = null;
    }

    private static void updateViewDistance() {
        int distance = WorldRenderInfo.getRenderDistance();
        viewDistance = PerformanceLevel.getPortalRenderingDistance(ClientPerformanceMonitor.level, distance);
    }

    private static boolean isVisible(class_846.class_851 builtChunk) {
        class_238 box = builtChunk.method_40051();
        return vanillaFrustum.method_23093(box);
    }

    private static void discoverBottomOrTopLayerVisibleChunks(int cy) {
        BlockTraverse.searchOnPlane(cameraSectionPos.method_18674(), cameraSectionPos.method_18687(), viewDistance - 1, (cx, cz) -> {
            VisibleSectionDiscovery.checkSection(cx, cy, cz, false);
            return null;
        });
    }

    private static void checkSection(int cx, int cy, int cz, boolean skipFrustumTest) {
        IERenderSection ieRenderSection;
        if (Math.abs(cx - cameraSectionPos.method_18674()) > viewDistance) {
            return;
        }
        if (Math.abs(cy - cameraSectionPos.method_18683()) > viewDistance) {
            return;
        }
        if (Math.abs(cz - cameraSectionPos.method_18687()) > viewDistance) {
            return;
        }
        class_846.class_851 builtChunk = builtChunks.rawFetch(cx, cy, cz, timeMark);
        if (builtChunk != null && (ieRenderSection = (IERenderSection)builtChunk).portal_getMark() != timeMark) {
            ieRenderSection.portal_setMark(timeMark);
            if (skipFrustumTest || VisibleSectionDiscovery.isVisible(builtChunk)) {
                tempQueue.add(builtChunk);
                resultHolder.add((Object)builtChunk);
            }
        }
    }

    public static ObjectArrayList<class_846.class_851> takeList() {
        if (listCaches.isEmpty()) {
            return new ObjectArrayList();
        }
        return listCaches.pop();
    }

    public static void returnList(ObjectArrayList<class_846.class_851> list) {
        list.clear();
        listCaches.push(list);
    }

    public static void init() {
        IPCGlobal.CLIENT_CLEANUP_EVENT.register(VisibleSectionDiscovery::cleanUp);
        ClientWorldLoader.CLIENT_DIMENSION_DYNAMIC_REMOVE_EVENT.register(dim -> VisibleSectionDiscovery.cleanUp());
    }

    private static void cleanUp() {
        listCaches.clear();
        resultHolder = null;
        builtChunks = null;
        vanillaFrustum = null;
    }

    static {
        tempQueue = new ArrayDeque();
        listCaches = new Stack();
    }
}

