/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render.context_management;

import com.mojang.logging.LogUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_5321;
import net.minecraft.class_640;
import net.minecraft.class_703;
import net.minecraft.class_746;
import org.joml.Matrix4f;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.block_manipulation.BlockManipulationClient;
import qouteall.imm_ptl.core.ducks.IEEntity;
import qouteall.imm_ptl.core.ducks.IEGameRenderer;
import qouteall.imm_ptl.core.miscellaneous.ClientPerformanceMonitor;
import qouteall.imm_ptl.core.mixin.client.particle.IEParticle;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalLike;
import qouteall.imm_ptl.core.portal.animation.StableClientTimer;
import qouteall.imm_ptl.core.render.ForceMainThreadRebuild;
import qouteall.imm_ptl.core.render.MyRenderHelper;
import qouteall.imm_ptl.core.render.QueryManager;
import qouteall.imm_ptl.core.render.context_management.FogRendererContext;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.imm_ptl.core.render.context_management.WorldRenderInfo;
import qouteall.q_misc_util.Helper;

public class RenderStates {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static int frameIndex = 0;
    public static class_5321<class_1937> originalPlayerDimension;
    public static class_243 originalPlayerPos;
    public static class_243 originalPlayerLastTickPos;
    public static class_1934 originalGameMode;
    public static class_238 originalPlayerBoundingBox;
    private static float partialTick;
    public static Set<class_5321<class_1937>> renderedDimensions;
    public static List<List<WeakReference<PortalLike>>> lastPortalRenderInfos;
    public static List<List<WeakReference<PortalLike>>> portalRenderInfos;
    public static int portalsRenderedThisFrame;
    public static class_243 lastCameraPos;
    public static class_243 cameraPosDelta;
    public static boolean shouldForceDisableCull;
    public static long renderStartNanoTime;
    public static double viewBobFactor;
    public static Matrix4f basicProjectionMatrix;
    public static class_4184 originalCamera;
    public static String debugText;
    public static boolean isLaggy;
    public static boolean isRenderingEntities;
    public static boolean renderedScalingPortal;
    public static boolean isRenderingPortalWeather;

    public static void updatePreRenderInfo(float tickDelta_) {
        ClientWorldLoader.initializeIfNeeded();
        class_1297 cameraEntity = MyRenderHelper.client.field_1719;
        if (cameraEntity == null) {
            return;
        }
        originalPlayerDimension = cameraEntity.method_37908().method_27983();
        originalPlayerPos = cameraEntity.method_19538();
        originalPlayerLastTickPos = McHelper.lastTickPosOf(cameraEntity);
        class_640 entry = CHelper.getClientPlayerListEntry();
        originalGameMode = entry != null ? entry.method_2958() : class_1934.field_9220;
        partialTick = tickDelta_;
        renderedDimensions.clear();
        lastPortalRenderInfos = portalRenderInfos;
        portalRenderInfos = new ArrayList<List<WeakReference<PortalLike>>>();
        portalsRenderedThisFrame = 0;
        FogRendererContext.update();
        renderStartNanoTime = System.nanoTime();
        RenderStates.updateViewBobbingFactor(cameraEntity);
        basicProjectionMatrix = null;
        originalCamera = MyRenderHelper.client.field_1773.method_19418();
        RenderStates.updateIsLaggy();
        ForceMainThreadRebuild.onPreRender();
        debugText = "";
        QueryManager.queryStallCounter = 0;
        class_243 velocity = McHelper.getWorldVelocity(cameraEntity);
        originalPlayerBoundingBox = cameraEntity.method_5829().method_1012(-velocity.field_1352, -velocity.field_1351, -velocity.field_1350);
    }

    private static void updateIsLaggy() {
        if (!IPGlobal.lagAttackProof) {
            isLaggy = false;
            return;
        }
        if (isLaggy) {
            if (ClientPerformanceMonitor.getMinimumFps() > 15) {
                isLaggy = false;
            }
        } else if (lastPortalRenderInfos.size() > 10 && (ClientPerformanceMonitor.getAverageFps() < 8 || ClientPerformanceMonitor.getMinimumFps() < 6)) {
            MyRenderHelper.client.field_1705.method_1758((class_2561)class_2561.method_43471((String)"imm_ptl.laggy"), false);
            isLaggy = true;
        }
    }

    private static void updateViewBobbingFactor(class_1297 cameraEntity) {
        class_243 cameraPosVec = cameraEntity.method_5836(RenderStates.getPartialTick());
        double minPortalDistance = CHelper.getClientNearbyPortals(16.0).map(portal -> portal.getDistanceToNearestPointInPortal(cameraPosVec)).min(Double::compareTo).orElse(100.0);
        if (minPortalDistance < 2.0) {
            if (minPortalDistance < 1.0) {
                RenderStates.setViewBobFactor(0.0);
            } else {
                RenderStates.setViewBobFactor(minPortalDistance - 1.0);
            }
        } else {
            RenderStates.setViewBobFactor(1.0);
        }
    }

    public static double getViewBobbingOffsetMultiplier() {
        if (!IPGlobal.viewBobbingReduce) {
            return 1.0;
        }
        if (!WorldRenderInfo.isViewBobbingEnabled()) {
            return 0.0;
        }
        double allScaling = PortalRendering.getExtraModelViewScaling();
        return viewBobFactor * allScaling;
    }

    private static void setViewBobFactor(double arg) {
        viewBobFactor = arg < viewBobFactor ? arg : class_3532.method_16436((double)0.1, (double)viewBobFactor, (double)arg);
    }

    public static void onTotalRenderEnd() {
        class_310 client = class_310.method_1551();
        IEGameRenderer gameRenderer = (IEGameRenderer)class_310.method_1551().field_1773;
        gameRenderer.ip_setLightmapTextureManager(ClientWorldLoader.getDimensionRenderHelper((class_5321<class_1937>)client.field_1687.method_27983()).lightmapTexture);
        class_243 currCameraPos = client.field_1773.method_19418().method_19326();
        cameraPosDelta = currCameraPos.method_1020(lastCameraPos);
        if (cameraPosDelta.method_1027() > 1.0) {
            cameraPosDelta = class_243.field_1353;
        }
        lastCameraPos = currCameraPos;
    }

    public static int getRenderedPortalNum() {
        return portalRenderInfos.size();
    }

    public static boolean isDimensionRendered(class_5321<class_1937> dimensionType) {
        if (dimensionType == originalPlayerDimension) {
            return true;
        }
        return renderedDimensions.contains(dimensionType);
    }

    public static boolean shouldRenderParticle(class_703 particle) {
        if (((IEParticle)particle).portal_getWorld() != class_310.method_1551().field_1687) {
            return false;
        }
        if (PortalRendering.isRendering()) {
            PortalLike renderingPortal = PortalRendering.getRenderingPortal();
            class_243 particlePos = particle.method_3064().method_1005();
            return renderingPortal.isOnDestinationSide(particlePos, 0.5);
        }
        return true;
    }

    public static void setPartialTick(float partialTick_) {
        partialTick = partialTick_;
    }

    public static float getPartialTick() {
        return partialTick;
    }

    public static List<String> collectDebugText() {
        Portal collidingPortal;
        ArrayList<String> result = new ArrayList<String>();
        result.add("Rendered Portals: " + lastPortalRenderInfos.size());
        class_746 player = class_310.method_1551().field_1724;
        if (player != null && (collidingPortal = ((IEEntity)player).ip_getCollidingPortal()) != null) {
            String text = "Colliding " + collidingPortal.toString();
            result.addAll(Helper.splitStringByLen(text, 50));
        }
        result.add("Occlusion Query Stall: " + QueryManager.queryStallCounter);
        result.add("Client Perf %s %d %d".formatted(new Object[]{ClientPerformanceMonitor.level, ClientPerformanceMonitor.getAverageFps(), ClientPerformanceMonitor.getAverageFreeMemoryMB()}));
        result.add(StableClientTimer.getDebugString());
        String blockPointingInfo = BlockManipulationClient.getDebugString();
        if (blockPointingInfo != null) {
            result.add(blockPointingInfo);
        }
        if (debugText != null && !debugText.isEmpty()) {
            result.addAll(Helper.splitStringByLen("Debug: " + debugText, 50));
        }
        return result;
    }

    static {
        originalPlayerPos = class_243.field_1353;
        originalPlayerLastTickPos = class_243.field_1353;
        partialTick = 0.0f;
        renderedDimensions = new HashSet<class_5321<class_1937>>();
        lastPortalRenderInfos = new ArrayList<List<WeakReference<PortalLike>>>();
        portalRenderInfos = new ArrayList<List<WeakReference<PortalLike>>>();
        portalsRenderedThisFrame = 0;
        lastCameraPos = class_243.field_1353;
        cameraPosDelta = class_243.field_1353;
        shouldForceDisableCull = false;
        isLaggy = false;
        isRenderingEntities = false;
        renderedScalingPortal = false;
        isRenderingPortalWeather = false;
    }
}

