/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import org.lwjgl.opengl.GL11;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.compat.IPPortingLibCompat;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalLike;
import qouteall.imm_ptl.core.portal.PortalRenderInfo;
import qouteall.imm_ptl.core.render.FrontClipping;
import qouteall.imm_ptl.core.render.MyRenderHelper;
import qouteall.imm_ptl.core.render.PortalRenderable;
import qouteall.imm_ptl.core.render.ViewAreaRenderer;
import qouteall.imm_ptl.core.render.context_management.FogRendererContext;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.imm_ptl.core.render.context_management.WorldRenderInfo;
import qouteall.imm_ptl.core.render.renderer.PortalRenderer;

public class RendererUsingStencil
extends PortalRenderer {
    @Override
    public boolean replaceFrameBufferClearing() {
        boolean skipClearing = WorldRenderInfo.isRendering();
        if (skipClearing && WorldRenderInfo.getTopRenderInfo().doRenderSky) {
            RenderSystem.depthMask((boolean)false);
            MyRenderHelper.renderScreenTriangle(FogRendererContext.getCurrentFogColor.get());
            RenderSystem.depthMask((boolean)true);
        }
        return skipClearing;
    }

    @Override
    public void onBeforeTranslucentRendering(class_4587 matrixStack) {
        this.doPortalRendering(matrixStack);
    }

    protected void doPortalRendering(class_4587 matrixStack) {
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        client.method_16011().method_15405("render_portal_total");
        this.renderPortals(matrixStack);
        if (PortalRendering.isRendering()) {
            this.setStencilStateForWorldRendering();
        } else {
            this.myFinishRendering();
        }
    }

    protected void renderPortals(class_4587 matrixStack) {
        List<PortalRenderable> portalsToRender = this.getPortalsToRender(matrixStack);
        for (PortalRenderable portal : portalsToRender) {
            this.doRenderPortal(portal, matrixStack);
        }
    }

    @Override
    public void onAfterTranslucentRendering(class_4587 matrixStack) {
    }

    @Override
    public void onHandRenderingEnded(class_4587 matrixStack) {
    }

    @Override
    public void prepareRendering() {
        if (!IPPortingLibCompat.getIsStencilEnabled(client.method_1522())) {
            IPPortingLibCompat.setIsStencilEnabled(client.method_1522(), true);
            if (class_310.method_29611()) {
                // empty if block
            }
        }
        client.method_1522().method_1235(false);
        GL11.glClearStencil((int)0);
        GL11.glClear((int)1024);
        GlStateManager._enableDepthTest();
        GL11.glEnable((int)2960);
    }

    @Override
    public void finishRendering() {
    }

    private void myFinishRendering() {
        GL11.glStencilFunc((int)519, (int)2333, (int)255);
        GL11.glStencilOp((int)7680, (int)7680, (int)7680);
        GL11.glDisable((int)2960);
        GlStateManager._enableDepthTest();
    }

    protected void doRenderPortal(PortalRenderable portal, class_4587 matrixStack) {
        PortalLike portalLike = portal.getPortalLike();
        if (RendererUsingStencil.shouldSkipRenderingInsideFuseViewPortal(portal)) {
            return;
        }
        int outerPortalStencilValue = PortalRendering.getPortalLayer();
        client.method_16011().method_15396("render_view_area");
        boolean anySamplePassed = PortalRenderInfo.renderAndDecideVisibility(portalLike, () -> this.renderPortalViewAreaToStencil(portal, matrixStack));
        client.method_16011().method_15407();
        if (!anySamplePassed) {
            this.setStencilStateForWorldRendering();
            return;
        }
        PortalRendering.pushPortalLayer(portalLike);
        int thisPortalStencilValue = outerPortalStencilValue + 1;
        if (!portalLike.isFuseView()) {
            client.method_16011().method_15396("clear_depth_of_view_area");
            this.clearDepthOfThePortalViewArea(portal);
            client.method_16011().method_15407();
        }
        this.setStencilStateForWorldRendering();
        this.renderPortalContent(portal);
        PortalRendering.popPortalLayer();
        if (!portalLike.isFuseView()) {
            this.restoreDepthOfPortalViewArea(portal, matrixStack, thisPortalStencilValue);
        }
        RendererUsingStencil.clampStencilValue(outerPortalStencilValue);
    }

    @Override
    public void renderPortalInEntityRenderer(Portal portal) {
    }

    private void renderPortalViewAreaToStencil(PortalRenderable portal, class_4587 matrixStack) {
        int outerPortalStencilValue = PortalRendering.getPortalLayer();
        GL11.glStencilFunc((int)514, (int)outerPortalStencilValue, (int)255);
        GL11.glStencilOp((int)7680, (int)7680, (int)7682);
        GL11.glStencilMask((int)255);
        FrontClipping.updateInnerClipping(matrixStack);
        ViewAreaRenderer.renderPortalArea(portal, class_243.field_1353, matrixStack.method_23760().method_23761(), RenderSystem.getProjectionMatrix(), true, true, true, true);
    }

    private void clearDepthOfThePortalViewArea(PortalRenderable portal) {
        GlStateManager._enableDepthTest();
        GlStateManager._depthMask((boolean)true);
        this.setStencilStateForWorldRendering();
        GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        int originalDepthFunc = GL11.glGetInteger((int)2932);
        GL11.glDepthFunc((int)519);
        GL11.glDepthRange((double)1.0, (double)1.0);
        MyRenderHelper.renderScreenTriangle();
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glDepthFunc((int)originalDepthFunc);
        GL11.glDepthRange((double)0.0, (double)1.0);
    }

    protected void restoreDepthOfPortalViewArea(PortalRenderable portal, class_4587 matrixStack, int portalStencilValue) {
        RendererUsingStencil.setStencilLimitation(portalStencilValue);
        int originalDepthFunc = GL11.glGetInteger((int)2932);
        GL11.glDepthFunc((int)519);
        ViewAreaRenderer.renderPortalArea(portal, class_243.field_1353, matrixStack.method_23760().method_23761(), RenderSystem.getProjectionMatrix(), false, false, true, true);
        GL11.glDepthFunc((int)originalDepthFunc);
    }

    public static void clampStencilValue(int maximumValue) {
        GlStateManager._depthMask((boolean)true);
        GL11.glStencilFunc((int)513, (int)maximumValue, (int)255);
        GL11.glStencilOp((int)7680, (int)7681, (int)7681);
        GL11.glDepthMask((boolean)false);
        GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GlStateManager._disableDepthTest();
        MyRenderHelper.renderScreenTriangle();
        GL11.glDepthMask((boolean)true);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager._enableDepthTest();
    }

    private void setStencilStateForWorldRendering() {
        int thisPortalStencilValue = PortalRendering.getPortalLayer();
        RendererUsingStencil.setStencilLimitation(thisPortalStencilValue);
    }

    public static void setStencilLimitation(int stencilValue) {
        GL11.glStencilFunc((int)514, (int)stencilValue, (int)255);
        GL11.glStencilOp((int)7680, (int)7680, (int)7680);
    }

    public static boolean shouldSkipRenderingInsideFuseViewPortal(PortalRenderable portal) {
        class_243 transformedCameraPos;
        if (!PortalRendering.isRendering()) {
            return false;
        }
        PortalLike renderingPortal = PortalRendering.getRenderingPortal();
        if (!renderingPortal.isFuseView()) {
            return false;
        }
        class_243 cameraPos = CHelper.getCurrentCameraPos();
        return cameraPos.method_1025(transformedCameraPos = portal.getPortalLike().transformPoint(renderingPortal.transformPoint(cameraPos))) < 0.1;
    }
}

