/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.teleportation;

import java.util.Comparator;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.IPMcHelper;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.render.context_management.RenderStates;

@Environment(value=EnvType.CLIENT)
public class CrossPortalSound {
    public static final float VOLUME_RADIUS_MULT = 16.0f;
    public static final float MIN_SOUND_RADIUS = 16.0f;

    public static boolean isPlayerWorld(class_638 world) {
        return world.method_27983() == RenderStates.originalPlayerDimension;
    }

    @Nullable
    public static class_1109 createCrossPortalSound(class_638 soundWorld, class_3414 soundEvent, class_3419 soundSource, class_243 soundPos, float soundVol, float soundPitch, long seed) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return null;
        }
        soundWorld.method_16107().method_15396("cross_portal_sound");
        double soundRadius = Math.min(64.0f, Math.max(16.0f * soundVol, 16.0f));
        class_243 playerCameraPos = RenderStates.originalPlayerPos.method_1019(McHelper.getEyeOffset((class_1297)client.field_1724));
        class_1109 result = IPMcHelper.getNearbyPortalList((class_1937)soundWorld, soundPos, IPGlobal.maxNormalPortalRadius, portal -> portal.getDestDim() == RenderStates.originalPlayerDimension && CrossPortalSound.isPlayerInRange(portal, soundPos, soundRadius, playerCameraPos)).stream().min(Comparator.comparingDouble(portal -> CrossPortalSound.getPortalDistance(portal, soundPos))).map(portal -> {
            class_243 soundEnterPortalPoint = portal.getNearestPointInPortal(soundPos);
            class_243 soundExitPortalPoint = portal.transformPoint(soundEnterPortalPoint);
            float volumeToEnterPortal = (float)soundEnterPortalPoint.method_1022(soundPos) / 16.0f;
            float volumeMultiplier = Math.max(0.0f, 1.0f - (float)(playerCameraPos.method_1022(soundExitPortalPoint) / 16.0));
            float volumeAtPortal = Math.max(0.0f, soundVol - volumeToEnterPortal) * volumeMultiplier;
            return new class_1109(soundEvent, soundSource, volumeAtPortal, soundPitch, class_5819.method_43049((long)seed), soundExitPortalPoint.method_10216(), soundExitPortalPoint.method_10214(), soundExitPortalPoint.method_10215());
        }).orElse(null);
        soundWorld.method_16107().method_15407();
        return result;
    }

    private static boolean isPlayerInRange(Portal portal, class_243 soundPos, double soundRadius, class_243 playerCameraPos) {
        class_243 soundExitPoint = portal.transformPoint(portal.getNearestPointInPortal(soundPos));
        return soundExitPoint.method_24802((class_2374)playerCameraPos, soundRadius);
    }

    private static double getPortalDistance(Portal portal, class_243 soundPos) {
        class_243 soundEnterPortalPoint = portal.getNearestPointInPortal(soundPos);
        return soundEnterPortalPoint.method_1025(soundPos);
    }
}

