/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.commands.PortalCommand;

public class CommandStickItem
extends class_1792 {
    public static final LinkedHashMap<String, Data> BUILT_IN_COMMAND_STICK_TYPES = new LinkedHashMap();
    public static final CommandStickItem instance = new CommandStickItem(new class_1792.class_1793());

    public static void registerBuiltInCommandStick(Data data) {
        BUILT_IN_COMMAND_STICK_TYPES.put(data.command, data);
    }

    public CommandStickItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public boolean method_7886(class_1799 stack) {
        return true;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        this.doUse(player, player.method_5998(hand));
        return super.method_7836(world, player, hand);
    }

    private void doUse(class_1657 player, class_1799 stack) {
        if (player.method_37908().method_8608()) {
            return;
        }
        if (CommandStickItem.canUseCommand(player)) {
            Data data = Data.deserialize(stack.method_7948());
            class_2168 commandSource = player.method_5671().method_9206(2);
            class_2170 commandManager = player.method_5682().method_3734();
            String command = data.command;
            if (command.startsWith("/")) {
                command = command.substring(1);
            }
            commandManager.method_44252(commandSource, command);
        } else {
            CommandStickItem.sendMessage(player, (class_2561)class_2561.method_43470((String)"No Permission"));
        }
    }

    private static boolean canUseCommand(class_1657 player) {
        if (IPGlobal.easeCommandStickPermission) {
            return true;
        }
        return player.method_5687(2) || player.method_7337();
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        Data data = Data.deserialize(stack.method_7948());
        Iterable splitCommand = Splitter.fixedLength((int)40).split((CharSequence)data.command);
        for (String commandPortion : splitCommand) {
            tooltip.add((class_2561)class_2561.method_43470((String)commandPortion).method_27692(class_124.field_1065));
        }
        for (String descriptionTranslationKey : data.descriptionTranslationKeys) {
            tooltip.add((class_2561)class_2561.method_43471((String)descriptionTranslationKey).method_27692(class_124.field_1075));
        }
        tooltip.add((class_2561)class_2561.method_43471((String)"imm_ptl.command_stick").method_27692(class_124.field_1080));
    }

    public String method_7866(class_1799 stack) {
        Data data = Data.deserialize(stack.method_7948());
        return data.nameTranslationKey;
    }

    public static void sendMessage(class_1657 player, class_2561 message) {
        ((class_3222)player).method_43496(message);
    }

    public static void init() {
        PortalCommand.createCommandStickCommandSignal.connect((player, command) -> {
            class_1799 itemStack = new class_1799((class_1935)instance, 1);
            Data data = new Data((String)command, (String)command, (List<String>)new ArrayList<String>());
            data.serialize(itemStack.method_7948());
            player.method_31548().method_7394(itemStack);
            player.field_7498.method_7623();
        });
    }

    public static void addIntoCreativeTag(class_1761.class_7704 entries) {
        for (Data data : BUILT_IN_COMMAND_STICK_TYPES.values()) {
            class_1799 stack = new class_1799((class_1935)instance);
            data.serialize(stack.method_7948());
            entries.method_45420(stack);
        }
    }

    public static void registerCommandStickTypes() {
        CommandStickItem.registerPortalSubCommandStick("delete_portal");
        CommandStickItem.registerPortalSubCommandStick("remove_connected_portals");
        CommandStickItem.registerPortalSubCommandStick("eradicate_portal_cluster");
        CommandStickItem.registerPortalSubCommandStick("complete_bi_way_bi_faced_portal");
        CommandStickItem.registerPortalSubCommandStick("complete_bi_way_portal");
        CommandStickItem.registerPortalSubCommandStick("move_portal_front", "move_portal 0.5");
        CommandStickItem.registerPortalSubCommandStick("move_portal_back", "move_portal -0.5");
        CommandStickItem.registerPortalSubCommandStick("move_portal_back_a_little", "move_portal -0.001");
        CommandStickItem.registerPortalSubCommandStick("move_portal_destination_front", "move_portal_destination 0.5");
        CommandStickItem.registerPortalSubCommandStick("move_portal_destination_back", "move_portal_destination -0.5");
        CommandStickItem.registerPortalSubCommandStick("rotate_x", "rotate_portal_rotation_along x 15");
        CommandStickItem.registerPortalSubCommandStick("rotate_y", "rotate_portal_rotation_along y 15");
        CommandStickItem.registerPortalSubCommandStick("rotate_z", "rotate_portal_rotation_along z 15");
        CommandStickItem.registerPortalSubCommandStick("make_unbreakable", "nbt {unbreakable:true}");
        CommandStickItem.registerPortalSubCommandStick("make_fuse_view", "nbt {fuseView:true}");
        CommandStickItem.registerPortalSubCommandStick("enable_pos_adjust", "nbt {adjustPositionAfterTeleport:true}");
        CommandStickItem.registerPortalSubCommandStick("disable_rendering_yourself", "nbt {doRenderPlayer:false}");
        CommandStickItem.registerPortalSubCommandStick("enable_isometric", "debug isometric_enable 50");
        CommandStickItem.registerPortalSubCommandStick("disable_isometric", "debug isometric_disable");
        CommandStickItem.registerPortalSubCommandStick("create_5_connected_rooms", "create_connected_rooms roomSize 6 4 6 roomNumber 5");
        CommandStickItem.registerPortalSubCommandStick("accelerate50", "debug accelerate 50");
        CommandStickItem.registerPortalSubCommandStick("accelerate200", "debug accelerate 200");
        CommandStickItem.registerPortalSubCommandStick("reverse_accelerate50", "debug accelerate -50");
        CommandStickItem.registerPortalSubCommandStick("enable_gravity_change", "nbt {teleportChangesGravity:true}");
        CommandStickItem.registerPortalSubCommandStick("make_invisible", "nbt {isVisible:false}");
        CommandStickItem.registerPortalSubCommandStick("make_visible", "nbt {isVisible:true}");
        CommandStickItem.registerPortalSubCommandStick("disable_default_animation", "nbt {defaultAnimation:{durationTicks:0}}");
        CommandStickItem.registerPortalSubCommandStick("pause_animation", "animation pause");
        CommandStickItem.registerPortalSubCommandStick("resume_animation", "animation resume");
        CommandStickItem.registerPortalSubCommandStick("rotate_around_y", "animation rotate_infinitely @s 0 1 0 1.0");
        CommandStickItem.registerPortalSubCommandStick("rotate_randomly", "animation rotate_infinitely_random");
        CommandStickItem.registerBuiltInCommandStick(new Data("execute positioned 0.0 0.0 0.0 run portal animation rotate_infinitely @p ^0.0 ^0.0 ^1.0 1.7", "imm_ptl.command.rotate_around_view", Lists.newArrayList((Object[])new String[]{"imm_ptl.command_desc.rotate_around_view"})));
        CommandStickItem.registerPortalSubCommandStick("expand_from_center", "animation expand_from_center 20");
        CommandStickItem.registerPortalSubCommandStick("clear_animation", "animation clear");
        CommandStickItem.registerPortalSubCommandStick("sculpt", "shape sculpt");
        CommandStickItem.registerPortalSubCommandStick("reset_shape", "shape reset");
        CommandStickItem.registerBuiltInCommandStick(new Data("/scale set pehkui:base 1", "imm_ptl.command.reset_scale", Lists.newArrayList((Object[])new String[]{"imm_ptl.command_desc.reset_scale"})));
        CommandStickItem.registerBuiltInCommandStick(new Data("/scale set pehkui:reach 5", "imm_ptl.command.long_reach", Lists.newArrayList((Object[])new String[]{"imm_ptl.command_desc.long_reach"})));
        CommandStickItem.registerBuiltInCommandStick(new Data("/effect give @s minecraft:night_vision 9999 1 true", "imm_ptl.command.night_vision", List.of()));
        CommandStickItem.registerPortalSubCommandStick("goback");
        CommandStickItem.registerPortalSubCommandStick("show_wiki", "wiki");
    }

    private static Data registerPortalSubCommandStick(String name) {
        return CommandStickItem.registerPortalSubCommandStick(name, name);
    }

    private static Data registerPortalSubCommandStick(String name, String subCommand) {
        Data data = new Data("/portal " + subCommand, "imm_ptl.command." + name, Lists.newArrayList((Object[])new String[]{"imm_ptl.command_desc." + name}));
        CommandStickItem.registerBuiltInCommandStick(data);
        return data;
    }

    public record Data(String command, String nameTranslationKey, List<String> descriptionTranslationKeys) {
        public void serialize(class_2487 tag) {
            tag.method_10582("command", this.command);
            tag.method_10582("nameTranslationKey", this.nameTranslationKey);
            class_2499 listTag = new class_2499();
            for (String descriptionTK : this.descriptionTranslationKeys) {
                listTag.add((Object)class_2519.method_23256((String)descriptionTK));
            }
            tag.method_10566("descriptionTranslationKeys", (class_2520)listTag);
        }

        public class_2487 toTag() {
            class_2487 tag = new class_2487();
            this.serialize(tag);
            return tag;
        }

        public static Data deserialize(class_2487 tag) {
            return new Data(tag.method_10558("command"), tag.method_10558("nameTranslationKey"), tag.method_10554("descriptionTranslationKeys", (int)class_2519.method_23256((String)"").method_10711()).stream().map(tag1 -> ((class_2519)tag1).method_10714()).collect(Collectors.toList()));
        }
    }
}

