/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.alternate_dimension;

import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2378;
import net.minecraft.class_2794;
import net.minecraft.class_2874;
import net.minecraft.class_2897;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3229;
import net.minecraft.class_3232;
import net.minecraft.class_5216;
import net.minecraft.class_5284;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6910;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import net.minecraft.class_8197;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import qouteall.dimlib.DimensionTemplate;
import qouteall.dimlib.api.DimensionAPI;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.ducks.IEWorld;
import qouteall.imm_ptl.peripheral.alternate_dimension.ErrorTerrainGenerator;
import qouteall.imm_ptl.peripheral.alternate_dimension.NormalSkylandGenerator;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackInfo;
import qouteall.imm_ptl.peripheral.dim_stack.DimensionStackAPI;

public class AlternateDimensions {
    public static final class_5321<class_2874> SURFACE_TYPE = class_5321.method_29179((class_5321)class_7924.field_41241, (class_2960)new class_2960("immersive_portals:surface_type"));
    public static final class_5321<class_2874> SURFACE_TYPE_BRIGHT = class_5321.method_29179((class_5321)class_7924.field_41241, (class_2960)new class_2960("immersive_portals:surface_type_bright"));
    public static final class_5321<class_1937> SKYLAND = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960("immersive_portals:skyland"));
    public static final class_5321<class_1937> BRIGHT_SKYLAND = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960("immersive_portals:bright_skyland"));
    public static final class_5321<class_1937> CHAOS = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960("immersive_portals:chaos"));
    public static final class_5321<class_1937> VOID = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960("immersive_portals:void"));
    public static final class_5321<class_1937> BRIGHT_VOID = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960("immersive_portals:bright_void"));
    public static final DimensionTemplate SKYLAND_TEMPLATE = new DimensionTemplate(SURFACE_TYPE, (server, dimensionTypeHolder) -> new class_5363(dimensionTypeHolder, AlternateDimensions.createSkylandGenerator((class_5455)server.method_30611(), server.method_27728().method_28057().method_28028())));
    public static final DimensionTemplate BRIGHT_SKYLAND_TEMPLATE = new DimensionTemplate(SURFACE_TYPE_BRIGHT, (server, dimensionTypeHolder) -> new class_5363(dimensionTypeHolder, AlternateDimensions.createSkylandGenerator((class_5455)server.method_30611(), server.method_27728().method_28057().method_28028())));
    public static final DimensionTemplate CHAOS_TEMPLATE = new DimensionTemplate(SURFACE_TYPE, (server, dimensionTypeHolder) -> new class_5363(dimensionTypeHolder, AlternateDimensions.createErrorTerrainGenerator(server.method_27728().method_28057().method_28028(), (class_5455)server.method_30611())));
    public static final DimensionTemplate BRIGHT_VOID_TEMPLATE = new DimensionTemplate(SURFACE_TYPE_BRIGHT, (server, dimensionTypeHolder) -> new class_5363(dimensionTypeHolder, AlternateDimensions.createVoidGenerator((class_5455)server.method_30611())));

    public static void init() {
        DimensionStackAPI.DIMENSION_STACK_CANDIDATE_COLLECTION_EVENT.register((registryAccess, options) -> List.of(BRIGHT_SKYLAND, SKYLAND, CHAOS, VOID));
        DimensionStackAPI.DIMENSION_STACK_PRE_UPDATE_EVENT.register(AlternateDimensions::addAltDimsIfUsedInDimStack);
        ServerTickEvents.END_SERVER_TICK.register(AlternateDimensions::tick);
        DimensionTemplate.registerDimensionTemplate((String)"skyland", (DimensionTemplate)SKYLAND_TEMPLATE);
        DimensionTemplate.registerDimensionTemplate((String)"bright_skyland", (DimensionTemplate)BRIGHT_SKYLAND_TEMPLATE);
        DimensionTemplate.registerDimensionTemplate((String)"chaos", (DimensionTemplate)CHAOS_TEMPLATE);
        DimensionTemplate.registerDimensionTemplate((String)"bright_void", (DimensionTemplate)BRIGHT_VOID_TEMPLATE);
    }

    private static void addAltDimsIfUsedInDimStack(MinecraftServer server, @Nullable DimStackInfo dimStackInfo) {
        if (dimStackInfo == null) {
            return;
        }
        if (dimStackInfo.hasDimension(BRIGHT_SKYLAND)) {
            DimensionAPI.addDimensionIfNotExists((MinecraftServer)server, (class_2960)BRIGHT_SKYLAND.method_29177(), () -> BRIGHT_SKYLAND_TEMPLATE.createLevelStem(server));
        }
        if (dimStackInfo.hasDimension(SKYLAND)) {
            DimensionAPI.addDimensionIfNotExists((MinecraftServer)server, (class_2960)SKYLAND.method_29177(), () -> SKYLAND_TEMPLATE.createLevelStem(server));
        }
        if (dimStackInfo.hasDimension(CHAOS)) {
            DimensionAPI.addDimensionIfNotExists((MinecraftServer)server, (class_2960)CHAOS.method_29177(), () -> CHAOS_TEMPLATE.createLevelStem(server));
        }
        if (dimStackInfo.hasDimension(VOID)) {
            DimensionAPI.addDimensionIfNotExists((MinecraftServer)server, (class_2960)VOID.method_29177(), () -> DimensionTemplate.VOID_TEMPLATE.createLevelStem(server));
        }
        if (dimStackInfo.hasDimension(BRIGHT_VOID)) {
            DimensionAPI.addDimensionIfNotExists((MinecraftServer)server, (class_2960)BRIGHT_VOID.method_29177(), () -> BRIGHT_VOID_TEMPLATE.createLevelStem(server));
        }
    }

    public static boolean isAlternateDimension(class_1937 world) {
        class_5321 dimensionTypeId = world.method_44013();
        return dimensionTypeId == SURFACE_TYPE || dimensionTypeId == SURFACE_TYPE_BRIGHT;
    }

    public static class_2794 createSkylandGenerator(class_5455 rm, long seed) {
        return NormalSkylandGenerator.create((class_7871<class_1959>)rm.method_30530(class_7924.field_41236).method_46771(), (class_7871<class_6910>)rm.method_30530(class_7924.field_41240).method_46771(), (class_7871<class_5216.class_5487>)rm.method_30530(class_7924.field_41244).method_46771(), (class_7871<class_5284>)rm.method_30530(class_7924.field_41243).method_46771(), (class_7871<class_8197>)rm.method_30530(class_7924.field_43089).method_46771(), seed);
    }

    public static class_2794 createErrorTerrainGenerator(long seed, class_5455 rm) {
        return ErrorTerrainGenerator.create((class_7871<class_1959>)rm.method_30530(class_7924.field_41236).method_46771(), (class_7871<class_5284>)rm.method_30530(class_7924.field_41243).method_46771());
    }

    public static class_2794 createVoidGenerator(class_5455 rm) {
        class_2378 biomeRegistry = rm.method_30530(class_7924.field_41236);
        class_6880.class_6883 plainsHolder = biomeRegistry.method_40290(class_1972.field_9451);
        class_3232 flatChunkGeneratorConfig = new class_3232(Optional.of(class_6885.method_40246((class_6880[])new class_6880[0])), (class_6880)plainsHolder, List.of());
        flatChunkGeneratorConfig.method_14327().add(new class_3229(1, class_2246.field_10124));
        flatChunkGeneratorConfig.method_14330();
        return new class_2897(flatChunkGeneratorConfig);
    }

    private static void tick(MinecraftServer server) {
        for (class_3218 world : server.method_3738()) {
            if (!AlternateDimensions.isAlternateDimension((class_1937)world)) continue;
            AlternateDimensions.syncWeatherFromOverworld(world, McHelper.getOverWorldOnServer());
        }
    }

    private static void syncWeatherFromOverworld(class_3218 world, class_3218 overworld) {
        ((IEWorld)world).portal_setWeather(overworld.method_8430(1.0f), overworld.method_8430(1.0f), overworld.method_8478(1.0f), overworld.method_8478(1.0f));
    }
}

