/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.dim_stack;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.api.PortalAPI;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorage;
import qouteall.imm_ptl.core.portal.global_portals.VerticalConnectingPortal;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackEntry;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackManagement;
import qouteall.q_misc_util.Helper;

public class DimStackInfo {
    public boolean loop;
    public boolean gravityTransform;
    public List<DimStackEntry> entries;

    public DimStackInfo() {
        this.entries = new ArrayList<DimStackEntry>();
        this.loop = false;
        this.gravityTransform = false;
    }

    public DimStackInfo(List<DimStackEntry> entries, boolean loop, boolean gravityTransform) {
        this.entries = entries;
        this.loop = loop;
        this.gravityTransform = gravityTransform;
    }

    public static void initializeFuseViewProperty(Portal portal) {
        portal.setFuseView(true);
    }

    public static void createConnectionBetween(DimStackEntry a, DimStackEntry b, boolean gravityChange) {
        class_3218 fromWorld = McHelper.getServerWorld(a.getDimension());
        class_3218 toWorld = McHelper.getServerWorld(b.getDimension());
        boolean xorFlipped = a.flipped ^ b.flipped;
        int fromWorldMinY = McHelper.getMinY((class_1936)fromWorld);
        if (a.bottomY != null) {
            fromWorldMinY = a.bottomY;
        }
        int fromWorldMaxY = McHelper.getMaxContentYExclusive((class_1936)fromWorld);
        if (a.topY != null) {
            fromWorldMaxY = a.topY;
        }
        int toWorldMinY = McHelper.getMinY((class_1936)toWorld);
        if (b.bottomY != null) {
            toWorldMinY = b.bottomY;
        }
        int toWorldMaxY = McHelper.getMaxContentYExclusive((class_1936)toWorld);
        if (b.topY != null) {
            toWorldMaxY = b.topY;
        }
        VerticalConnectingPortal connectingPortal = VerticalConnectingPortal.createConnectingPortal(fromWorld, a.flipped ? VerticalConnectingPortal.ConnectorType.ceil : VerticalConnectingPortal.ConnectorType.floor, toWorld, b.scale / a.scale, xorFlipped, b.horizontalRotation - a.horizontalRotation, fromWorldMinY, fromWorldMaxY, toWorldMinY, toWorldMaxY);
        VerticalConnectingPortal reverse = PortalAPI.createReversePortal(connectingPortal);
        DimStackInfo.initializeFuseViewProperty(connectingPortal);
        DimStackInfo.initializeFuseViewProperty(reverse);
        if (gravityChange) {
            connectingPortal.setTeleportChangesGravity(true);
            reverse.setTeleportChangesGravity(true);
        }
        if (a.connectsNext) {
            PortalAPI.addGlobalPortal(fromWorld, connectingPortal);
        }
        if (b.connectsPrevious) {
            PortalAPI.addGlobalPortal(toWorld, reverse);
        }
    }

    public void apply(MinecraftServer server) {
        if (this.entries.isEmpty()) {
            McHelper.sendMessageToFirstLoggedPlayer(server, (class_2561)class_2561.method_43470((String)"Error: No dimension for dimension stack"));
            return;
        }
        for (DimStackEntry dimStackEntry : this.entries) {
            if (server.method_3847(dimStackEntry.getDimension()) != null) continue;
            McHelper.sendMessageToFirstLoggedPlayer(server, (class_2561)class_2561.method_43470((String)("Failed to apply dimension stack. Missing dimension " + dimStackEntry.dimensionIdStr)).method_27692(class_124.field_1061));
            return;
        }
        if (!GlobalPortalStorage.getGlobalPortals((class_1937)McHelper.getServerWorld(this.entries.get(0).getDimension())).isEmpty()) {
            Helper.err("There are already global portals when initializing dimension stack");
            McHelper.sendMessageToFirstLoggedPlayer(server, (class_2561)class_2561.method_43470((String)"Failed to apply dimension stack because there are already global portals when initializing dimension stack").method_27692(class_124.field_1061));
            return;
        }
        Map<PortalInfo, List<DimStackEntry>> portalInfoMap = this.getPortalInfoMap();
        for (Map.Entry<PortalInfo, List<DimStackEntry>> entry : portalInfoMap.entrySet()) {
            PortalInfo key = entry.getKey();
            List<DimStackEntry> value = entry.getValue();
            if (value == null || value.size() <= 1) continue;
            McHelper.sendMessageToFirstLoggedPlayer(server, (class_2561)class_2561.method_43470((String)"Failed to apply dimension stack because of connection conflict. There are multiple connections in the %s of %s".formatted(new Object[]{key.connectorType, key.dimension.method_29177()})).method_27692(class_124.field_1061));
            return;
        }
        Helper.wrapAdjacentAndMap(this.entries.stream(), Pair::of).forEach(pair -> {
            DimStackEntry before = (DimStackEntry)pair.getFirst();
            DimStackEntry after = (DimStackEntry)pair.getSecond();
            DimStackInfo.createConnectionBetween(before, after, this.gravityTransform);
        });
        if (this.loop) {
            DimStackInfo.createConnectionBetween(this.entries.get(this.entries.size() - 1), this.entries.get(0), this.gravityTransform);
        }
        HashMap<class_5321<class_1937>, class_2680> hashMap = new HashMap<class_5321<class_1937>, class_2680>();
        for (DimStackEntry entry : this.entries) {
            String bedrockReplacementStr = entry.bedrockReplacementStr;
            class_2680 bedrockReplacement = DimStackInfo.parseBlockString(bedrockReplacementStr);
            class_5321<class_1937> dimId = entry.getDimension();
            if (bedrockReplacement != null) {
                hashMap.put(dimId, bedrockReplacement);
            }
            class_3218 world = server.method_3847(dimId);
            Validate.notNull((Object)world, (String)"Missing dimension %s", (Object[])new Object[]{dimId.method_29177()});
            GlobalPortalStorage gps = GlobalPortalStorage.get(world);
            gps.bedrockReplacement = bedrockReplacement;
            gps.onDataChanged();
        }
        DimStackManagement.bedrockReplacementMap = hashMap;
        McHelper.sendMessageToFirstLoggedPlayer(server, (class_2561)class_2561.method_43471((String)"imm_ptl.dim_stack_initialized"));
    }

    public boolean isEffectivelyConnectingPrevious(int index) {
        DimStackEntry entry = this.entries.get(index);
        if (!entry.connectsPrevious) {
            return false;
        }
        if (index == 0) {
            return this.loop;
        }
        return true;
    }

    public boolean isEffectivelyConnectionNext(int index) {
        DimStackEntry entry = this.entries.get(index);
        if (!entry.connectsNext) {
            return false;
        }
        if (index == this.entries.size() - 1) {
            return this.loop;
        }
        return true;
    }

    public boolean isEffectivelyConnectingCeil(int index) {
        DimStackEntry entry = this.entries.get(index);
        if (!entry.flipped) {
            return this.isEffectivelyConnectingPrevious(index);
        }
        return this.isEffectivelyConnectionNext(index);
    }

    public boolean isEffectivelyConnectingFloor(int index) {
        DimStackEntry entry = this.entries.get(index);
        if (!entry.flipped) {
            return this.isEffectivelyConnectionNext(index);
        }
        return this.isEffectivelyConnectingPrevious(index);
    }

    public Map<PortalInfo, List<DimStackEntry>> getPortalInfoMap() {
        HashMap<PortalInfo, List<DimStackEntry>> map = new HashMap<PortalInfo, List<DimStackEntry>>();
        for (int i = 0; i < this.entries.size(); ++i) {
            PortalInfo portalInfo;
            DimStackEntry entry = this.entries.get(i);
            if (this.isEffectivelyConnectingCeil(i)) {
                portalInfo = new PortalInfo(entry.getDimension(), VerticalConnectingPortal.ConnectorType.ceil);
                map.computeIfAbsent(portalInfo, k -> new ArrayList()).add(entry);
            }
            if (!this.isEffectivelyConnectingFloor(i)) continue;
            portalInfo = new PortalInfo(entry.getDimension(), VerticalConnectingPortal.ConnectorType.floor);
            map.computeIfAbsent(portalInfo, k -> new ArrayList()).add(entry);
        }
        return map;
    }

    @Nullable
    public static class_2680 parseBlockString(@Nullable String str) {
        if (str == null) {
            return null;
        }
        if (str.isEmpty()) {
            return null;
        }
        try {
            Optional block = class_7923.field_41175.method_17966(new class_2960(str));
            return block.map(class_2248::method_9564).orElse(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean hasDimension(class_5321<class_1937> dimension) {
        return this.entries.stream().anyMatch(e -> e.getDimension() == dimension);
    }

    public record PortalInfo(class_5321<class_1937> dimension, VerticalConnectingPortal.ConnectorType connectorType) {
    }
}

