/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.wand;

import com.mojang.logging.LogUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.mc_utils.WireRenderingHelper;
import qouteall.imm_ptl.core.platform_specific.IPConfig;
import qouteall.imm_ptl.core.portal.animation.TimingFunction;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.imm_ptl.peripheral.wand.ProtoPortal;
import qouteall.imm_ptl.peripheral.wand.WandUtil;
import qouteall.q_misc_util.CustomTextOverlay;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.api.McRemoteProcedureCall;
import qouteall.q_misc_util.my_util.Circle;
import qouteall.q_misc_util.my_util.Plane;
import qouteall.q_misc_util.my_util.WithDim;
import qouteall.q_misc_util.my_util.animation.Animated;
import qouteall.q_misc_util.my_util.animation.RenderedPlane;

@Environment(value=EnvType.CLIENT)
public class ClientPortalWandPortalCreation {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Animated<class_243> cursor = new Animated<Object>(Animated.VEC3_NULLABLE_TYPE_INFO, () -> RenderStates.renderStartNanoTime, TimingFunction.circle::mapProgress, null);
    public static final Animated<RenderedPlane> renderedPlane = new Animated<RenderedPlane>(Animated.RENDERED_PLANE_TYPE_INFO, () -> RenderStates.renderStartNanoTime, TimingFunction.sine::mapProgress, RenderedPlane.NONE);
    @NotNull
    public static ProtoPortal protoPortal = new ProtoPortal();
    private static final int colorOfFirstSideLeftBottom = -327425;
    private static final int colorOfFirstSideRightBottom = -1691038;
    private static final int colorOfFirstSideLeftUp = -200864;
    private static final int colorOfSecondSideLeftBottom = -5308585;
    private static final int colorOfSecondSideRightBottom = -11010094;
    private static final int colorOfSecondSideLeftUp = -4344833;
    private static final int colorOfPlane = -5254150;
    private static final int colorOfCircle = -16515869;
    private static final int colorOfFirstPortalArea = -225277;
    private static final int colorOfFirstPortalArea2 = -33384;
    private static final int colorOfSecondPortalArea = -10423556;
    private static final int colorOfSecondPortalArea2 = -10423556;

    public static void reset() {
        protoPortal.reset();
        renderedPlane.clearTarget();
    }

    public static void onLeftClick() {
        ClientPortalWandPortalCreation.undo();
    }

    private static void undo() {
        protoPortal.undo();
    }

    public static void onRightClick() {
        class_243 cursorTarget = cursor.getTarget();
        if (cursorTarget == null) {
            return;
        }
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        protoPortal.tryPlaceCursor((class_5321<class_1937>)world.method_27983(), cursorTarget);
        if (protoPortal.isComplete()) {
            ClientPortalWandPortalCreation.finish();
        }
    }

    public static void clearCursorPointing() {
        cursor.clearTarget();
    }

    public static void updateDisplay() {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        class_5321<class_1937> cursorLimitingDim = protoPortal.getCursorConstraintDim();
        if (cursorLimitingDim != null && player.method_37908().method_27983() != cursorLimitingDim) {
            cursor.clearTarget();
            renderedPlane.clearTarget();
            return;
        }
        WithDim<Plane> limitingPlane = protoPortal.getCursorConstraintPlane();
        WithDim<Circle> limitingCircle = protoPortal.getCursorConstraintCircle();
        class_243 eyePos = player.method_5836(RenderStates.getPartialTick());
        class_243 viewVec = player.method_5828(RenderStates.getPartialTick());
        class_243 cursorPointing = null;
        int alignment = IPConfig.getConfig().portalWandCursorAlignment;
        if (limitingPlane != null) {
            cursorPointing = limitingPlane.value().rayTrace(eyePos, viewVec);
            if (cursorPointing != null) {
                cursorPointing = WandUtil.alignOnBlocks(player.method_37908(), cursorPointing, alignment);
                cursorPointing = limitingPlane.value().getProjection(cursorPointing);
                if (limitingCircle != null) {
                    cursorPointing = limitingCircle.value().projectToCircle(cursorPointing);
                }
            }
        } else {
            class_239 hitResult = player.method_5745(64.0, RenderStates.getPartialTick(), false);
            if (hitResult.method_17783() == class_239.class_240.field_1332 && hitResult instanceof class_3965) {
                class_3965 blockHitResult = (class_3965)hitResult;
                cursorPointing = WandUtil.alignOnBlocks(player.method_37908(), blockHitResult.method_17784(), alignment);
            }
        }
        if (limitingPlane != null && limitingCircle == null) {
            renderedPlane.setTarget(new RenderedPlane(limitingPlane, 1.0), Helper.secondToNano(3.0));
        } else {
            renderedPlane.setTarget(RenderedPlane.NONE, Helper.secondToNano(0.5));
        }
        if (cursorPointing != null) {
            class_5250 promptMessage;
            ProtoPortal pendingState = protoPortal.copy();
            boolean canPlace = pendingState.tryPlaceCursor((class_5321<class_1937>)player.method_37908().method_27983(), cursorPointing);
            if (!canPlace || !pendingState.isValidPlacement()) {
                cursorPointing = null;
                pendingState = null;
            }
            if ((promptMessage = protoPortal.getPromptMessage(pendingState)) != null) {
                CustomTextOverlay.putText((class_2561)promptMessage);
            }
        }
        if (cursorPointing != null) {
            cursor.setTarget(cursorPointing, Helper.secondToNano(0.5));
        } else {
            cursor.clearTarget();
        }
    }

    public static void finish() {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        McRemoteProcedureCall.tellServerToInvoke("qouteall.imm_ptl.peripheral.wand.PortalWandInteraction.RemoteCallables.finishPortalCreation", protoPortal);
        ClientPortalWandPortalCreation.reset();
    }

    public static void render(class_4587 matrixStack, class_4597.class_4598 bufferSource, double camX, double camY, double camZ) {
        double scale;
        RenderedPlane currRenderedPlane;
        WithDim<Circle> renderedCircle;
        ProtoPortal pending;
        boolean canPlace;
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        class_5321 currDim = player.method_37908().method_27983();
        class_4588 vertexConsumer = bufferSource.getBuffer(class_1921.method_23594());
        class_243 cameraPos = new class_243(camX, camY, camZ);
        WithDim<Circle> circle = protoPortal.getCursorConstraintCircle();
        class_243 renderedCursor = cursor.getCurrent();
        if (circle != null && renderedCursor != null) {
            renderedCursor = circle.value().projectToCircle(renderedCursor);
        }
        ProtoPortal renderedProtoPortal = protoPortal;
        if (renderedCursor != null && (canPlace = (pending = protoPortal.copy()).tryPlaceCursor((class_5321<class_1937>)currDim, renderedCursor))) {
            renderedProtoPortal = pending;
        }
        if (circle == null) {
            circle = protoPortal.getCursorConstraintCircle();
        }
        if (renderedProtoPortal.firstSide != null && currDim == renderedProtoPortal.firstSide.dimension) {
            WireRenderingHelper.renderSmallCubeFrame(vertexConsumer, cameraPos, renderedProtoPortal.firstSide.leftBottom, -327425, 1.0, matrixStack);
            if (renderedProtoPortal.firstSide.rightBottom != null) {
                WireRenderingHelper.renderSmallCubeFrame(vertexConsumer, cameraPos, renderedProtoPortal.firstSide.rightBottom, -1691038, 1.0, matrixStack);
            }
            if (renderedProtoPortal.firstSide.leftTop != null) {
                WireRenderingHelper.renderSmallCubeFrame(vertexConsumer, cameraPos, renderedProtoPortal.firstSide.leftTop, -200864, 1.0, matrixStack);
                WandUtil.renderPortalAreaGrid(vertexConsumer, cameraPos, renderedProtoPortal.firstSide, -225277, matrixStack);
            }
        }
        if (renderedProtoPortal.secondSide != null && currDim == renderedProtoPortal.secondSide.dimension) {
            WireRenderingHelper.renderSmallCubeFrame(vertexConsumer, cameraPos, renderedProtoPortal.secondSide.leftBottom, -5308585, 1.0, matrixStack);
            if (renderedProtoPortal.secondSide.rightBottom != null) {
                WireRenderingHelper.renderSmallCubeFrame(vertexConsumer, cameraPos, renderedProtoPortal.secondSide.rightBottom, -11010094, 1.0, matrixStack);
            }
            if (renderedProtoPortal.secondSide.leftTop != null) {
                WireRenderingHelper.renderSmallCubeFrame(vertexConsumer, cameraPos, renderedProtoPortal.secondSide.leftTop, -4344833, 1.0, matrixStack);
                WandUtil.renderPortalAreaGrid(vertexConsumer, cameraPos, renderedProtoPortal.secondSide, -10423556, matrixStack);
            }
        }
        class_4588 debugLineStripConsumer = bufferSource.getBuffer(class_1921.method_49043((double)1.0));
        WithDim<Circle> withDim = renderedCircle = circle != null ? circle : renderedProtoPortal.getCursorConstraintCircle();
        if (renderedCircle != null && renderedCircle.dimension() == currDim) {
            WireRenderingHelper.renderCircle(debugLineStripConsumer, cameraPos, renderedCircle.value(), -16515869, matrixStack);
        }
        if ((currRenderedPlane = renderedPlane.getCurrent()) != null && currRenderedPlane.plane() != null && currRenderedPlane.plane().dimension() == currDim && (scale = currRenderedPlane.scale()) > 0.01) {
            WireRenderingHelper.renderPlane(debugLineStripConsumer, cameraPos, currRenderedPlane.plane().value(), scale, -5254150, matrixStack, true);
        }
    }
}

