/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.wand;

import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.UUID;
import java.util.WeakHashMap;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.IPPerServerInfo;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.platform_specific.IPConfig;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalExtension;
import qouteall.imm_ptl.core.portal.PortalManipulation;
import qouteall.imm_ptl.core.portal.PortalState;
import qouteall.imm_ptl.core.portal.animation.UnilateralPortalState;
import qouteall.imm_ptl.core.portal.util.PortalLocalXYNormalized;
import qouteall.imm_ptl.peripheral.CommandStickItem;
import qouteall.imm_ptl.peripheral.wand.PortalWandItem;
import qouteall.imm_ptl.peripheral.wand.ProtoPortal;
import qouteall.imm_ptl.peripheral.wand.WandUtil;
import qouteall.q_misc_util.my_util.DQuaternion;
import qouteall.q_misc_util.my_util.Plane;
import qouteall.q_misc_util.my_util.Range;

public class PortalWandInteraction {
    private static final double SIZE_LIMIT = 64.0;
    private static final Logger LOGGER = LogUtils.getLogger();
    private final WeakHashMap<class_3222, DraggingSession> draggingSessionMap = new WeakHashMap();
    private static final WeakHashMap<class_3222, CopyingSession> copyingSessionMap = new WeakHashMap();

    public static PortalWandInteraction of(MinecraftServer server) {
        return IPPerServerInfo.of((MinecraftServer)server).portalWandInteraction;
    }

    private static void handleFinishPortalCreation(class_3222 player, ProtoPortal protoPortal) {
        class_243 secondSideNormal;
        class_243 firstSideNormal;
        Validate.isTrue((protoPortal.firstSide != null ? 1 : 0) != 0);
        Validate.isTrue((protoPortal.secondSide != null ? 1 : 0) != 0);
        class_243 firstSideLeftBottom = protoPortal.firstSide.leftBottom;
        class_243 firstSideRightBottom = protoPortal.firstSide.rightBottom;
        class_243 firstSideLeftUp = protoPortal.firstSide.leftTop;
        class_243 secondSideLeftBottom = protoPortal.secondSide.leftBottom;
        class_243 secondSideRightBottom = protoPortal.secondSide.rightBottom;
        class_243 secondSideLeftUp = protoPortal.secondSide.leftTop;
        Validate.notNull((Object)firstSideLeftBottom);
        Validate.notNull((Object)firstSideRightBottom);
        Validate.notNull((Object)firstSideLeftUp);
        Validate.notNull((Object)secondSideLeftBottom);
        Validate.notNull((Object)secondSideRightBottom);
        Validate.notNull((Object)secondSideLeftUp);
        class_5321<class_1937> firstSideDimension = protoPortal.firstSide.dimension;
        class_5321<class_1937> secondSideDimension = protoPortal.secondSide.dimension;
        class_243 firstSideHorizontalAxis = firstSideRightBottom.method_1020(firstSideLeftBottom);
        class_243 firstSideVerticalAxis = firstSideLeftUp.method_1020(firstSideLeftBottom);
        double firstSideWidth = firstSideHorizontalAxis.method_1033();
        double firstSideHeight = firstSideVerticalAxis.method_1033();
        class_243 firstSideHorizontalUnitAxis = firstSideHorizontalAxis.method_1029();
        class_243 firstSideVerticalUnitAxis = firstSideVerticalAxis.method_1029();
        if (Math.abs(firstSideWidth) < 0.001 || Math.abs(firstSideHeight) < 0.001) {
            player.method_43496((class_2561)class_2561.method_43470((String)"The first side is too small"));
            LOGGER.error("The first side is too small");
            return;
        }
        if (firstSideHorizontalUnitAxis.method_1026(firstSideVerticalUnitAxis) > 0.001) {
            player.method_43496((class_2561)class_2561.method_43470((String)"The horizontal and vertical axis are not perpendicular in first side"));
            LOGGER.error("The horizontal and vertical axis are not perpendicular in first side");
            return;
        }
        if (firstSideWidth > 64.0 || firstSideHeight > 64.0) {
            player.method_43496((class_2561)class_2561.method_43470((String)"The first side is too large"));
            LOGGER.error("The first side is too large");
            return;
        }
        class_243 secondSideHorizontalAxis = secondSideRightBottom.method_1020(secondSideLeftBottom);
        class_243 secondSideVerticalAxis = secondSideLeftUp.method_1020(secondSideLeftBottom);
        double secondSideWidth = secondSideHorizontalAxis.method_1033();
        double secondSideHeight = secondSideVerticalAxis.method_1033();
        class_243 secondSideHorizontalUnitAxis = secondSideHorizontalAxis.method_1029();
        class_243 secondSideVerticalUnitAxis = secondSideVerticalAxis.method_1029();
        if (Math.abs(secondSideWidth) < 0.001 || Math.abs(secondSideHeight) < 0.001) {
            player.method_43496((class_2561)class_2561.method_43470((String)"The second side is too small"));
            LOGGER.error("The second side is too small");
            return;
        }
        if (secondSideHorizontalUnitAxis.method_1026(secondSideVerticalUnitAxis) > 0.001) {
            player.method_43496((class_2561)class_2561.method_43470((String)"The horizontal and vertical axis are not perpendicular in second side"));
            LOGGER.error("The horizontal and vertical axis are not perpendicular in second side");
            return;
        }
        if (secondSideWidth > 64.0 || secondSideHeight > 64.0) {
            player.method_43496((class_2561)class_2561.method_43470((String)"The second side is too large"));
            LOGGER.error("The second side is too large");
            return;
        }
        if (Math.abs(firstSideHeight / firstSideWidth - secondSideHeight / secondSideWidth) > 0.001) {
            player.method_43496((class_2561)class_2561.method_43470((String)"The two sides have different aspect ratio"));
            LOGGER.error("The two sides have different aspect ratio");
            return;
        }
        boolean overlaps = false;
        if (firstSideDimension == secondSideDimension && Math.abs((firstSideNormal = firstSideHorizontalUnitAxis.method_1036(firstSideVerticalUnitAxis)).method_1026(secondSideNormal = secondSideHorizontalUnitAxis.method_1036(secondSideVerticalUnitAxis))) > 0.99 && Math.abs(firstSideLeftBottom.method_1020(secondSideLeftBottom).method_1026(firstSideNormal)) < 0.001) {
            class_243 coordCenter = firstSideLeftBottom;
            class_243 coordX = firstSideHorizontalAxis;
            class_243 coordY = firstSideVerticalAxis;
            Range firstSideXRange = Range.createUnordered(firstSideLeftBottom.method_1020(coordCenter).method_1026(coordX), firstSideRightBottom.method_1020(coordCenter).method_1026(coordX));
            Range firstSideYRange = Range.createUnordered(firstSideLeftBottom.method_1020(coordCenter).method_1026(coordY), firstSideLeftUp.method_1020(coordCenter).method_1026(coordY));
            Range secondSideXRange = Range.createUnordered(secondSideLeftBottom.method_1020(coordCenter).method_1026(coordX), secondSideRightBottom.method_1020(coordCenter).method_1026(coordX));
            Range secondSideYRange = Range.createUnordered(secondSideLeftBottom.method_1020(coordCenter).method_1026(coordY), secondSideLeftUp.method_1020(coordCenter).method_1026(coordY));
            if (firstSideXRange.intersect(secondSideXRange) != null && firstSideYRange.intersect(secondSideYRange) != null) {
                overlaps = true;
            }
        }
        Portal portal = (Portal)Portal.ENTITY_TYPE.method_5883((class_1937)McHelper.getServerWorld(firstSideDimension));
        Validate.notNull((Object)portal);
        portal.setOriginPos(firstSideLeftBottom.method_1019(firstSideHorizontalAxis.method_1021(0.5)).method_1019(firstSideVerticalAxis.method_1021(0.5)));
        portal.setWidth(firstSideWidth);
        portal.setHeight(firstSideHeight);
        portal.setAxisW(firstSideHorizontalUnitAxis);
        portal.setAxisH(firstSideVerticalUnitAxis);
        portal.setDestDim(secondSideDimension);
        portal.setDestination(secondSideLeftBottom.method_1019(secondSideHorizontalAxis.method_1021(0.5)).method_1019(secondSideVerticalAxis.method_1021(0.5)));
        portal.setScaling(secondSideWidth / firstSideWidth);
        DQuaternion secondSideOrientation = DQuaternion.matrixToQuaternion(secondSideHorizontalUnitAxis, secondSideVerticalUnitAxis, secondSideHorizontalUnitAxis.method_1036(secondSideVerticalUnitAxis));
        portal.setOtherSideOrientation(secondSideOrientation);
        Portal flippedPortal = PortalManipulation.createFlippedPortal(portal, Portal.ENTITY_TYPE);
        Portal reversePortal = PortalManipulation.createReversePortal(portal, Portal.ENTITY_TYPE);
        Portal parallelPortal = PortalManipulation.createFlippedPortal(reversePortal, Portal.ENTITY_TYPE);
        McHelper.spawnServerEntity(portal);
        if (overlaps) {
            player.method_43496((class_2561)class_2561.method_43471((String)"imm_ptl.wand.overlap"));
        } else {
            McHelper.spawnServerEntity(flippedPortal);
            McHelper.spawnServerEntity(reversePortal);
            McHelper.spawnServerEntity(parallelPortal);
        }
        player.method_43496((class_2561)class_2561.method_43471((String)"imm_ptl.wand.finished"));
        PortalWandInteraction.giveCommandStick(player, "/portal eradicate_portal_cluster");
    }

    public static void init() {
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            PortalWandInteraction.of((MinecraftServer)server).draggingSessionMap.entrySet().removeIf(e -> {
                class_3222 player = (class_3222)e.getKey();
                if (player.method_31481()) {
                    return true;
                }
                return player.method_6047().method_7909() != PortalWandItem.instance;
            });
            copyingSessionMap.entrySet().removeIf(e -> {
                class_3222 player = (class_3222)e.getKey();
                return player.method_31481();
            });
        });
        IPGlobal.SERVER_CLEANUP_EVENT.register(s -> PortalWandInteraction.of((MinecraftServer)s).draggingSessionMap.clear());
        IPGlobal.SERVER_CLEANUP_EVENT.register(s -> copyingSessionMap.clear());
    }

    @Nullable
    public static UnilateralPortalState applyDrag(UnilateralPortalState originalState, class_243 cursorPos, DraggingInfo info, boolean updateInternalState) {
        if (info.lockedAnchor == null) {
            class_243 offset = info.draggingAnchor.getOffset(originalState);
            class_243 newPos = cursorPos.method_1020(offset);
            return new UnilateralPortalState.Builder().from(originalState).position(newPos).build();
        }
        OneLockDraggingResult r = PortalWandInteraction.performDragWithOneLockedAnchor(originalState, info.lockedAnchor, info.draggingAnchor, cursorPos, info.previousRotationAxis, info.lockWidth, info.lockHeight);
        if (r == null) {
            return null;
        }
        if (updateInternalState) {
            info.previousRotationAxis = r.rotationAxis();
        }
        return r.newState();
    }

    private static void handleFinishDrag(class_3222 player) {
        DraggingSession session = PortalWandInteraction.of((MinecraftServer)player.field_13995).draggingSessionMap.remove(player);
        if (session == null) {
            return;
        }
        Portal portal = session.getPortal();
        if (portal != null) {
            portal.reloadAndSyncToClientNextTick();
        }
    }

    private static void handleUndoDrag(class_3222 player) {
        PortalWandInteraction portalWandInteraction = PortalWandInteraction.of(player.field_13995);
        DraggingSession session = portalWandInteraction.draggingSessionMap.get(player);
        if (session == null) {
            return;
        }
        Portal portal = session.getPortal();
        if (portal == null) {
            LOGGER.error("Cannot find portal {}", (Object)session.portalId);
            return;
        }
        portal.setPortalState(session.originalState);
        portal.reloadAndSyncToClientNextTick();
        portal.rectifyClusterPortals(true);
        portalWandInteraction.draggingSessionMap.remove(player);
    }

    private static void handleDraggingRequest(class_3222 player, UUID portalId, class_243 cursorPos, DraggingInfo draggingInfo, Portal portal) {
        PortalWandInteraction portalWandInteraction = PortalWandInteraction.of(player.field_13995);
        DraggingSession session = portalWandInteraction.draggingSessionMap.get(player);
        if (session == null || !session.portalId.equals(portalId)) {
            session = new DraggingSession((class_5321<class_1937>)player.method_37908().method_27983(), portalId, portal.getPortalState(), draggingInfo);
            portalWandInteraction.draggingSessionMap.put(player, session);
        }
        UnilateralPortalState newThisSideState = PortalWandInteraction.applyDrag(session.originalState.getThisSideState(), cursorPos, draggingInfo, true);
        if (PortalWandInteraction.validateDraggedPortalState(session.originalState, newThisSideState, (class_1657)player)) {
            portal.setThisSideState(newThisSideState, draggingInfo.shouldLockScale());
            portal.reloadAndSyncToClientNextTick();
            portal.rectifyClusterPortals(true);
        } else {
            player.method_43496((class_2561)class_2561.method_43470((String)"Invalid dragging"));
        }
    }

    private static boolean checkPermission(class_3222 player) {
        if (!PortalWandInteraction.canPlayerUsePortalWand(player)) {
            player.method_43496((class_2561)class_2561.method_43470((String)"You cannot use portal wand"));
            LOGGER.error("Player cannot use portal wand {}", (Object)player);
            return false;
        }
        return true;
    }

    public static boolean validateDraggedPortalState(PortalState originalState, UnilateralPortalState newThisSideState, class_1657 player) {
        if (newThisSideState == null) {
            return false;
        }
        if (newThisSideState.width() > 64.1) {
            return false;
        }
        if (newThisSideState.height() > 64.1) {
            return false;
        }
        if (newThisSideState.width() < 0.05) {
            return false;
        }
        if (newThisSideState.height() < 0.05) {
            return false;
        }
        if (originalState.fromWorld != newThisSideState.dimension()) {
            return false;
        }
        return !(newThisSideState.position().method_1022(player.method_19538()) > 64.0);
    }

    private static boolean canPlayerUsePortalWand(class_3222 player) {
        return player.method_5687(2) || IPGlobal.easeCreativePermission && player.method_7337() || IPConfig.getConfig().portalWandUsableOnSurvivalMode && player.field_13974.method_14257() == class_1934.field_9215;
    }

    private static void giveCommandStick(class_3222 player, String command) {
        CommandStickItem.Data data = CommandStickItem.BUILT_IN_COMMAND_STICK_TYPES.get(command);
        if (data == null) {
            data = new CommandStickItem.Data(command, command, List.of());
        }
        class_1799 stack = new class_1799((class_1935)CommandStickItem.instance);
        stack.method_7980(data.toTag());
        if (!player.method_31548().method_7379(stack)) {
            player.method_31548().method_7394(stack);
        }
    }

    public static boolean isDragging(class_3222 player) {
        return PortalWandInteraction.of((MinecraftServer)player.field_13995).draggingSessionMap.containsKey(player);
    }

    @Nullable
    public static OneLockDraggingResult performDragWithOneLockedAnchor(UnilateralPortalState originalState, PortalLocalXYNormalized lockedLocalPos, PortalLocalXYNormalized draggingLocalPos, class_243 draggedPos, @Nullable class_243 previousRotationAxis, boolean lockWidth, boolean lockHeight) {
        double newHeight;
        double newWidth;
        DQuaternion rotation;
        class_243 newOffsetN;
        class_243 draggedPosOriginalPos = draggingLocalPos.getPos(originalState);
        class_243 lockedPos = lockedLocalPos.getPos(originalState);
        class_243 originalOffset = draggedPosOriginalPos.method_1020(lockedPos);
        class_243 newOffset = draggedPos.method_1020(lockedPos);
        double newOffsetLen = newOffset.method_1033();
        double originalOffsetLen = originalOffset.method_1033();
        if (newOffsetLen < 1.0E-5 || originalOffsetLen < 1.0E-5) {
            return null;
        }
        class_243 originalOffsetN = originalOffset.method_1029();
        double dot = originalOffsetN.method_1026(newOffsetN = newOffset.method_1029());
        if (Math.abs(dot) < 0.99999) {
            rotation = DQuaternion.getRotationBetween(originalOffset, newOffset).fixFloatingPointErrorAccumulation();
        } else if (dot > 0.0) {
            rotation = DQuaternion.identity;
        } else {
            Plane planeOfPossibleAxis = new Plane(class_243.field_1353, originalOffsetN);
            if (previousRotationAxis != null) {
                class_243 projected = planeOfPossibleAxis.getProjection(previousRotationAxis);
                if (projected.method_1027() < 1.0E-5) {
                    return null;
                }
                class_243 axis = projected.method_1029();
                rotation = DQuaternion.rotationByDegrees(axis, 180.0).fixFloatingPointErrorAccumulation();
            } else {
                rotation = DQuaternion.identity;
            }
        }
        DQuaternion newOrientation = rotation.hamiltonProduct(originalState.orientation()).fixFloatingPointErrorAccumulation();
        PortalLocalXYNormalized deltaLocalXY = draggingLocalPos.subtract(lockedLocalPos);
        if (lockWidth && lockHeight) {
            newWidth = originalState.width();
            newHeight = originalState.height();
        } else {
            class_243 newNormal = rotation.rotate(originalState.getNormal());
            if (lockWidth) {
                assert (!lockHeight);
                newWidth = originalState.width();
                if (Math.abs(deltaLocalXY.ny()) < 0.001) {
                    newHeight = originalState.height();
                } else {
                    double subWidth = Math.abs(deltaLocalXY.nx()) * newWidth;
                    double diff = newOffsetLen * newOffsetLen - subWidth * subWidth;
                    if (diff < 1.0E-6) {
                        return null;
                    }
                    double subHeight = Math.sqrt(diff);
                    newHeight = subHeight / Math.abs(deltaLocalXY.ny());
                    if (Math.abs(subWidth) > 0.001) {
                        newOrientation = PortalWandInteraction.getOrientationByNormalDiagonalWidthHeight(newNormal, newOffset, subWidth, subHeight, Math.signum(deltaLocalXY.nx()), Math.signum(deltaLocalXY.ny()));
                    }
                }
            } else if (lockHeight) {
                assert (!lockWidth);
                newHeight = originalState.height();
                if (Math.abs(deltaLocalXY.nx()) < 0.001) {
                    newWidth = originalState.width();
                } else {
                    double subHeight = Math.abs(deltaLocalXY.ny()) * newHeight;
                    double diff = newOffsetLen * newOffsetLen - subHeight * subHeight;
                    if (diff < 1.0E-6) {
                        return null;
                    }
                    double subWidth = Math.sqrt(diff);
                    newWidth = subWidth / Math.abs(deltaLocalXY.nx());
                    if (Math.abs(subHeight) > 0.001) {
                        newOrientation = PortalWandInteraction.getOrientationByNormalDiagonalWidthHeight(newNormal, newOffset, subWidth, subHeight, Math.signum(deltaLocalXY.nx()), Math.signum(deltaLocalXY.ny()));
                    }
                }
            } else {
                double scaling = newOffsetLen / originalOffsetLen;
                newWidth = originalState.width() * scaling;
                newHeight = originalState.height() * scaling;
            }
        }
        class_243 newLockedPosOffset = newOrientation.rotate(new class_243((lockedLocalPos.nx() - 0.5) * newWidth, (lockedLocalPos.ny() - 0.5) * newHeight, 0.0));
        class_243 newOrigin = lockedPos.method_1020(newLockedPosOffset);
        UnilateralPortalState newPortalState = new UnilateralPortalState(originalState.dimension(), newOrigin, newOrientation, newWidth, newHeight);
        return new OneLockDraggingResult(newPortalState, rotation.getRotatingAxis());
    }

    private static DQuaternion getOrientationByNormalDiagonalWidthHeight(class_243 normal, class_243 diagonal, double width, double height, double sigX, double sigY) {
        class_243 newOffsetN = diagonal.method_1029();
        double newOffsetLen = diagonal.method_1033();
        class_243 sideVecN = normal.method_1036(newOffsetN).method_1029();
        double sideVecLen = width * height / newOffsetLen;
        double wFront = sideVecLen * width / height;
        double hFront = sideVecLen * height / width;
        class_243 sideVecW = sideVecN.method_1021(-sideVecLen * sigX * sigY);
        class_243 sideVecH = sideVecW.method_1021(-1.0);
        class_243 newAxisW = newOffsetN.method_1021(wFront).method_1019(sideVecW).method_1029().method_1021(sigX);
        class_243 newAxisH = newOffsetN.method_1021(hFront).method_1019(sideVecH).method_1029().method_1021(sigY);
        DQuaternion newOrientation = DQuaternion.fromFacingVecs(newAxisW, newAxisH).fixFloatingPointErrorAccumulation();
        return newOrientation;
    }

    public static void handleCopyCutPortal(class_3222 player, UUID portalId, boolean isCut) {
        Portal portal = WandUtil.getPortalByUUID(player.method_37908(), portalId);
        if (portal == null) {
            player.method_43496((class_2561)class_2561.method_43470((String)("Cannot find portal " + portalId)));
            return;
        }
        PortalState portalState = portal.getPortalState();
        class_2487 portalData = portal.writePortalDataToNbt();
        Portal flipped = null;
        Portal reverse = null;
        Portal parallel = null;
        PortalExtension ext = PortalExtension.get(portal);
        if (ext.flippedPortal != null) {
            flipped = ext.flippedPortal;
        }
        if (ext.reversePortal != null) {
            reverse = ext.reversePortal;
        }
        if (ext.parallelPortal != null) {
            parallel = ext.parallelPortal;
        }
        CopyingSession copyingSession = new CopyingSession(portalState, portalData, isCut, flipped != null, reverse != null, parallel != null);
        copyingSessionMap.put(player, copyingSession);
        if (isCut) {
            portal.method_5650(class_1297.class_5529.field_26998);
            if (flipped != null) {
                flipped.method_5650(class_1297.class_5529.field_26998);
            }
            if (reverse != null) {
                reverse.method_5650(class_1297.class_5529.field_26998);
            }
            if (parallel != null) {
                parallel.method_5650(class_1297.class_5529.field_26998);
            }
        }
    }

    private static void handleConfirmCopyCut(class_3222 player, class_243 origin, DQuaternion rawOrientation) {
        CopyingSession copyingSession = copyingSessionMap.remove(player);
        if (copyingSession == null) {
            player.method_43496((class_2561)class_2561.method_43470((String)"Missing copying session"));
            return;
        }
        DQuaternion orientation = rawOrientation.fixFloatingPointErrorAccumulation();
        if (player.method_19538().method_1025(origin) > 4096.0) {
            player.method_43496((class_2561)class_2561.method_43470((String)"Too far away from the portal"));
            return;
        }
        Portal portal = (Portal)Portal.ENTITY_TYPE.method_5883(player.method_37908());
        assert (portal != null);
        portal.readPortalDataFromNbt(copyingSession.portalData);
        PortalState originalPortalState = copyingSession.portalState;
        UnilateralPortalState originalThisSide = originalPortalState.getThisSideState();
        UnilateralPortalState originalOtherSide = originalPortalState.getOtherSideState();
        UnilateralPortalState newThisSide = new UnilateralPortalState((class_5321<class_1937>)player.method_37908().method_27983(), origin, orientation, originalThisSide.width(), originalThisSide.height());
        portal.setPortalState(UnilateralPortalState.combine(newThisSide, originalOtherSide));
        portal.resetAnimationReferenceState(true, false);
        if (copyingSession.isCut()) {
            McHelper.spawnServerEntity(portal);
            if (copyingSession.hasFlipped) {
                Portal flippedPortal = PortalManipulation.createFlippedPortal(portal, Portal.ENTITY_TYPE);
                flippedPortal.resetAnimationReferenceState(true, false);
                McHelper.spawnServerEntity(flippedPortal);
            }
            if (copyingSession.hasReverse) {
                Portal reversePortal = PortalManipulation.createReversePortal(portal, Portal.ENTITY_TYPE);
                reversePortal.resetAnimationReferenceState(false, true);
                McHelper.spawnServerEntity(reversePortal);
                if (copyingSession.hasParallel) {
                    Portal parallelPortal = PortalManipulation.createFlippedPortal(reversePortal, Portal.ENTITY_TYPE);
                    parallelPortal.resetAnimationReferenceState(false, true);
                    McHelper.spawnServerEntity(parallelPortal);
                }
            }
        } else {
            PortalExtension.get((Portal)portal).bindCluster = false;
            McHelper.spawnServerEntity(portal);
            if (copyingSession.hasFlipped || copyingSession.hasReverse || copyingSession.hasParallel) {
                player.method_43496((class_2561)class_2561.method_43471((String)"imm_ptl.wand.copy.not_copying_cluster"));
                PortalWandInteraction.giveCommandStick(player, "/portal complete_bi_way_bi_faced_portal");
            }
        }
    }

    private static void handleClearPortalClipboard(class_3222 player) {
        copyingSessionMap.remove(player);
    }

    public static final class DraggingInfo {
        @Nullable
        public final PortalLocalXYNormalized lockedAnchor;
        public final PortalLocalXYNormalized draggingAnchor;
        @Nullable
        public class_243 previousRotationAxis;
        public final boolean lockWidth;
        public final boolean lockHeight;

        public DraggingInfo(@Nullable PortalLocalXYNormalized lockedAnchor, PortalLocalXYNormalized draggingAnchor, @Nullable class_243 previousRotationAxis, boolean lockWidth, boolean lockHeight) {
            this.lockedAnchor = lockedAnchor;
            this.draggingAnchor = draggingAnchor;
            this.previousRotationAxis = previousRotationAxis;
            this.lockWidth = lockWidth;
            this.lockHeight = lockHeight;
        }

        public boolean shouldLockScale() {
            return this.lockWidth || this.lockHeight;
        }

        public boolean isValid() {
            if (this.lockedAnchor != null && !this.lockedAnchor.isValid()) {
                return false;
            }
            return this.draggingAnchor.isValid();
        }
    }

    public record OneLockDraggingResult(UnilateralPortalState newState, class_243 rotationAxis) {
    }

    private static class DraggingSession {
        private final class_5321<class_1937> dimension;
        private final UUID portalId;
        private final PortalState originalState;
        private final DraggingInfo lastDraggingInfo;

        public DraggingSession(class_5321<class_1937> dimension, UUID portalId, PortalState originalState, DraggingInfo lastDraggingInfo) {
            this.dimension = dimension;
            this.portalId = portalId;
            this.originalState = originalState;
            this.lastDraggingInfo = lastDraggingInfo;
        }

        @Nullable
        public Portal getPortal() {
            class_1297 entity = McHelper.getServerWorld(this.dimension).method_14190(this.portalId);
            if (entity instanceof Portal) {
                return (Portal)entity;
            }
            return null;
        }
    }

    private record CopyingSession(PortalState portalState, class_2487 portalData, boolean isCut, boolean hasFlipped, boolean hasReverse, boolean hasParallel) {
    }

    public static class RemoteCallables {
        public static void finishPortalCreation(class_3222 player, ProtoPortal protoPortal) {
            if (!PortalWandInteraction.checkPermission(player)) {
                return;
            }
            PortalWandInteraction.handleFinishPortalCreation(player, protoPortal);
        }

        public static void requestApplyDrag(class_3222 player, UUID portalId, class_243 cursorPos, DraggingInfo draggingInfo) {
            if (!PortalWandInteraction.checkPermission(player)) {
                return;
            }
            class_1297 entity = ((class_3218)player.method_37908()).method_14190(portalId);
            if (!(entity instanceof Portal)) {
                LOGGER.error("Cannot find portal {}", (Object)portalId);
                return;
            }
            Portal portal = (Portal)entity;
            if (!draggingInfo.isValid()) {
                player.method_43496((class_2561)class_2561.method_43470((String)"Invalid dragging info"));
                LOGGER.error("Invalid dragging info {}", (Object)draggingInfo);
                return;
            }
            PortalWandInteraction.handleDraggingRequest(player, portalId, cursorPos, draggingInfo, portal);
        }

        public static void undoDrag(class_3222 player) {
            if (!PortalWandInteraction.checkPermission(player)) {
                return;
            }
            PortalWandInteraction.handleUndoDrag(player);
        }

        public static void finishDragging(class_3222 player) {
            if (!PortalWandInteraction.checkPermission(player)) {
                return;
            }
            PortalWandInteraction.handleFinishDrag(player);
        }

        public static void copyCutPortal(class_3222 player, UUID portalId, boolean isCut) {
            if (!PortalWandInteraction.checkPermission(player)) {
                return;
            }
            PortalWandInteraction.handleCopyCutPortal(player, portalId, isCut);
        }

        public static void confirmCopyCut(class_3222 player, class_243 origin, DQuaternion orientation) {
            if (!PortalWandInteraction.checkPermission(player)) {
                return;
            }
            PortalWandInteraction.handleConfirmCopyCut(player, origin, orientation);
        }

        public static void clearPortalClipboard(class_3222 player) {
            if (!PortalWandInteraction.checkPermission(player)) {
                return;
            }
            PortalWandInteraction.handleClearPortalClipboard(player);
        }
    }
}

