/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.netty.buffer.Unpooled;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8705;
import net.minecraft.class_8706;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.MiscNetworking;
import qouteall.q_misc_util.my_util.DQuaternion;
import qouteall.q_misc_util.my_util.LimitedLogger;

public class ImplRemoteProcedureCall {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final LimitedLogger LIMITED_LOGGER = new LimitedLogger(100);
    public static final Gson gson = MiscHelper.gson;
    private static final ConcurrentHashMap<String, Method> methodCache = new ConcurrentHashMap();
    private static final ImmutableMap<Class, BiConsumer<class_2540, Object>> serializerMap;
    private static final ImmutableMap<Type, Function<class_2540, Object>> deserializerMap;
    private static final JsonParser jsonParser;

    public static void init() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)MiscNetworking.id_ctsRemote, (server, player, handler, buf, responseSender) -> {
            Runnable runnable = ImplRemoteProcedureCall.serverReadPacketAndGetHandler(player, buf);
            MiscHelper.executeOnServerThread(server, runnable);
        });
    }

    @Environment(value=EnvType.CLIENT)
    public static void initClient() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)MiscNetworking.id_stcRemote, (client, handler, buf, responseSender) -> {
            Runnable runnable = ImplRemoteProcedureCall.clientReadPacketAndGetHandler(buf);
            MiscHelper.executeOnRenderThread(runnable);
        });
    }

    private static Object deserializeByCodec(class_2540 buf, Codec codec) {
        String jsonString = buf.method_19772();
        JsonElement jsonElement = jsonParser.parse(jsonString);
        return codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).getOrThrow(false, e -> {
            throw new RuntimeException(e.toString());
        });
    }

    private static Object deserializeArgument(class_2540 buf, Type type) {
        Function deserializer = (Function)deserializerMap.get((Object)type);
        if (deserializer == null) {
            String json = buf.method_19772();
            return gson.fromJson(json, type);
        }
        return deserializer.apply(buf);
    }

    private static void serializeArgument(class_2540 buf, Object object) {
        BiConsumer serializer = (BiConsumer)serializerMap.get(object.getClass());
        if (serializer == null) {
            serializer = serializerMap.entrySet().stream().filter(e -> ((Class)e.getKey()).isAssignableFrom(object.getClass())).findFirst().map(Map.Entry::getValue).orElse(null);
        }
        if (serializer == null) {
            String json = gson.toJson(object);
            buf.method_10814(json);
            return;
        }
        serializer.accept(buf, object);
    }

    private static void serializeByCodec(class_2540 buf, Codec codec, Object object) {
        JsonElement result = (JsonElement)codec.encodeStart((DynamicOps)JsonOps.INSTANCE, object).getOrThrow(false, e -> {
            throw new RuntimeException(e.toString());
        });
        String jsonString = gson.toJson(result);
        buf.method_10814(jsonString);
    }

    @Environment(value=EnvType.CLIENT)
    public static class_2596<class_8706> createC2SPacket(String methodPath, Object ... arguments) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        ImplRemoteProcedureCall.serializeStringWithArguments(methodPath, arguments, buf);
        return ClientPlayNetworking.createC2SPacket((class_2960)MiscNetworking.id_ctsRemote, (class_2540)buf);
    }

    public static class_2596<class_8705> createS2CPacket(String methodPath, Object ... arguments) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        ImplRemoteProcedureCall.serializeStringWithArguments(methodPath, arguments, buf);
        return ServerPlayNetworking.createS2CPacket((class_2960)MiscNetworking.id_stcRemote, (class_2540)buf);
    }

    @Environment(value=EnvType.CLIENT)
    public static Runnable clientReadPacketAndGetHandler(class_2540 buf) {
        String methodPath = null;
        try {
            methodPath = buf.method_19772();
            Method method = ImplRemoteProcedureCall.getMethodByPath(methodPath);
            Type[] genericParameterTypes = method.getGenericParameterTypes();
            Object[] arguments = new Object[genericParameterTypes.length];
            for (int i = 0; i < genericParameterTypes.length; ++i) {
                Object obj;
                Type parameterType = genericParameterTypes[i];
                arguments[i] = obj = ImplRemoteProcedureCall.deserializeArgument(buf, parameterType);
            }
            return () -> {
                try {
                    method.invoke(null, arguments);
                }
                catch (Exception e) {
                    LIMITED_LOGGER.invoke(() -> {
                        LOGGER.error("Processing remote procedure call", (Throwable)e);
                        ImplRemoteProcedureCall.clientTellFailure();
                    });
                }
            };
        }
        catch (Exception e) {
            String methodPath_ = methodPath;
            LIMITED_LOGGER.invoke(() -> {
                LOGGER.error("Failed to parse remote procedure call {}", (Object)methodPath_, (Object)e);
                ImplRemoteProcedureCall.clientTellFailure();
            });
            return () -> {};
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static void clientTellFailure() {
        class_310.method_1551().field_1705.method_1743().method_1812((class_2561)class_2561.method_43470((String)"The client failed to process a packet from server. See the log for details.").method_27692(class_124.field_1061));
    }

    public static Runnable serverReadPacketAndGetHandler(class_3222 player, class_2540 buf) {
        String methodPath = null;
        try {
            methodPath = buf.method_19772();
            Method method = ImplRemoteProcedureCall.getMethodByPath(methodPath);
            Type[] genericParameterTypes = method.getGenericParameterTypes();
            Object[] arguments = new Object[genericParameterTypes.length];
            arguments[0] = player;
            for (int i = 1; i < genericParameterTypes.length; ++i) {
                Object obj;
                Type parameterType = genericParameterTypes[i];
                arguments[i] = obj = ImplRemoteProcedureCall.deserializeArgument(buf, parameterType);
            }
            return () -> {
                try {
                    method.invoke(null, arguments);
                }
                catch (Exception e) {
                    LIMITED_LOGGER.invoke(() -> {
                        LOGGER.error("Processing remote procedure call {}", (Object)player, (Object)e);
                        ImplRemoteProcedureCall.serverTellFailure(player);
                    });
                }
            };
        }
        catch (Exception e) {
            String methodPath_ = methodPath;
            LIMITED_LOGGER.invoke(() -> {
                LOGGER.error("Failed to parse remote procedure call {}", (Object)methodPath_, (Object)e);
                ImplRemoteProcedureCall.serverTellFailure(player);
            });
            return () -> {};
        }
    }

    private static void serverTellFailure(class_3222 player) {
        player.method_43496((class_2561)class_2561.method_43470((String)"The server failed to process a packet sent from client.").method_27692(class_124.field_1061));
    }

    private static void serializeStringWithArguments(String methodPath, Object[] arguments, class_2540 buf) {
        buf.method_10814(methodPath);
        for (Object argument : arguments) {
            ImplRemoteProcedureCall.serializeArgument(buf, argument);
        }
    }

    private static Method getMethodByPath(String methodPath) {
        Method result = methodCache.get(methodPath);
        if (result != null) {
            return result;
        }
        Method method = ImplRemoteProcedureCall.findMethodByPath(methodPath);
        Validate.notNull((Object)method);
        methodCache.put(methodPath, method);
        return method;
    }

    private static Method findMethodByPath(String methodPath) {
        Class<?> aClass;
        int lastDotIndex = methodPath.lastIndexOf(46);
        Validate.isTrue((lastDotIndex != -1 ? 1 : 0) != 0);
        String classPath = methodPath.substring(0, lastDotIndex);
        String methodName = methodPath.substring(lastDotIndex + 1);
        if (!classPath.contains("RemoteCallable")) {
            throw new RuntimeException("The class path must contain \"RemoteCallable\"");
        }
        try {
            aClass = Class.forName(classPath);
        }
        catch (ClassNotFoundException e) {
            int dotIndex = classPath.lastIndexOf(46);
            if (dotIndex != -1) {
                String newClassPath = classPath.substring(0, dotIndex) + "$" + classPath.substring(dotIndex + 1);
                try {
                    aClass = Class.forName(newClassPath);
                }
                catch (ClassNotFoundException e1) {
                    throw new RuntimeException("Cannot find class " + classPath, e);
                }
            }
            throw new RuntimeException("Cannot find class " + classPath, e);
        }
        Method method = Arrays.stream(aClass.getMethods()).filter(m -> m.getName().equals(methodName)).findFirst().orElseThrow(() -> new RuntimeException("Cannot find method " + methodPath + " . If it's a private method, make it public."));
        return method;
    }

    static {
        jsonParser = new JsonParser();
        serializerMap = ImmutableMap.builder().put(class_2960.class, (buf, o) -> buf.method_10812((class_2960)o)).put(class_5321.class, (buf, o) -> buf.method_10812(((class_5321)o).method_29177())).put(class_2338.class, (buf, o) -> buf.method_10807((class_2338)o)).put(class_243.class, (buf, o) -> {
            class_243 vec = (class_243)o;
            buf.method_52940(vec.field_1352);
            buf.method_52940(vec.field_1351);
            buf.method_52940(vec.field_1350);
        }).put(UUID.class, (buf, o) -> buf.method_10797((UUID)o)).put(class_2248.class, (buf, o) -> ImplRemoteProcedureCall.serializeByCodec(buf, class_7923.field_41175.method_39673(), o)).put(class_1792.class, (buf, o) -> ImplRemoteProcedureCall.serializeByCodec(buf, class_7923.field_41178.method_39673(), o)).put(class_2680.class, (buf, o) -> ImplRemoteProcedureCall.serializeByCodec(buf, class_2680.field_24734, o)).put(class_1799.class, (buf, o) -> ImplRemoteProcedureCall.serializeByCodec(buf, class_1799.field_24671, o)).put(class_2487.class, (buf, o) -> buf.method_10794((class_2520)((class_2487)o))).put(class_2561.class, (buf, o) -> buf.method_10805((class_2561)o)).put(DQuaternion.class, (buf, o) -> {
            DQuaternion dQuaternion = (DQuaternion)o;
            buf.method_52940(dQuaternion.x);
            buf.method_52940(dQuaternion.y);
            buf.method_52940(dQuaternion.z);
            buf.method_52940(dQuaternion.w);
        }).put(byte[].class, (buf, o) -> buf.method_10813((byte[])o)).build();
        deserializerMap = ImmutableMap.builder().put(class_2960.class, buf -> buf.method_10810()).put((Object)new TypeToken<class_5321<class_1937>>(){}.getType(), buf -> class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)buf.method_10810())).put((Object)new TypeToken<class_5321<class_1959>>(){}.getType(), buf -> class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)buf.method_10810())).put(class_2338.class, buf -> buf.method_10811()).put(class_243.class, buf -> new class_243(buf.readDouble(), buf.readDouble(), buf.readDouble())).put(UUID.class, buf -> buf.method_10790()).put(class_2248.class, buf -> ImplRemoteProcedureCall.deserializeByCodec(buf, class_7923.field_41175.method_39673())).put(class_1792.class, buf -> ImplRemoteProcedureCall.deserializeByCodec(buf, class_7923.field_41178.method_39673())).put(class_2680.class, buf -> ImplRemoteProcedureCall.deserializeByCodec(buf, class_2680.field_24734)).put(class_1799.class, buf -> ImplRemoteProcedureCall.deserializeByCodec(buf, class_1799.field_24671)).put(class_2487.class, buf -> buf.method_10798()).put(class_2561.class, buf -> buf.method_10808()).put(DQuaternion.class, buf -> new DQuaternion(buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble())).put(byte[].class, buf -> buf.method_10795()).build();
    }
}

