/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util;

import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7134;
import net.minecraft.class_7924;
import net.minecraft.class_8705;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.q_misc_util.dimension.DimIntIdMap;
import qouteall.q_misc_util.dimension.DimensionIntId;

public class MiscNetworking {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final class_2960 id_stcRemote = new class_2960("imm_ptl", "remote_stc");
    public static final class_2960 id_ctsRemote = new class_2960("imm_ptl", "remote_cts");

    @Environment(value=EnvType.CLIENT)
    public static void initClient() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)DimIdSyncPacket.TYPE.getId(), (client, handler, buf, responseSender) -> {
            DimIdSyncPacket dimIdSyncPacket = (DimIdSyncPacket)DimIdSyncPacket.TYPE.read(buf);
            dimIdSyncPacket.handleOnNetworkingThread((class_2602)handler);
        });
    }

    public static void init() {
    }

    public record DimIdSyncPacket(class_2487 dimIntIdTag, class_2487 dimTypeTag) implements FabricPacket
    {
        public static final PacketType<DimIdSyncPacket> TYPE = PacketType.create((class_2960)new class_2960("imm_ptl", "dim_int_id_sync"), DimIdSyncPacket::read);

        public static DimIdSyncPacket createFromServer(MinecraftServer server) {
            DimIntIdMap rec = DimensionIntId.getServerMap(server);
            class_2487 dimIntIdTag = rec.toTag(dim -> true);
            class_5455.class_6890 registryManager = server.method_30611();
            class_2378 dimensionTypes = registryManager.method_30530(class_7924.field_41241);
            class_2487 dimIdToDimTypeIdTag = new class_2487();
            for (class_3218 world : server.method_3738()) {
                class_5321 dimId = world.method_27983();
                class_2874 dimType = world.method_8597();
                class_2960 dimTypeId = dimensionTypes.method_10221((Object)dimType);
                if (dimTypeId == null) {
                    LOGGER.error("Cannot find dimension type for {}", (Object)dimId.method_29177());
                    LOGGER.error("Registered dimension types {}", (Object)dimensionTypes.method_10235());
                    dimTypeId = class_7134.field_37666.method_29177();
                }
                dimIdToDimTypeIdTag.method_10582(dimId.method_29177().toString(), dimTypeId.toString());
            }
            return new DimIdSyncPacket(dimIntIdTag, dimIdToDimTypeIdTag);
        }

        public static class_2596<class_8705> createPacket(MinecraftServer server) {
            return ServerPlayNetworking.createS2CPacket((FabricPacket)DimIdSyncPacket.createFromServer(server));
        }

        public void write(class_2540 buf) {
            buf.method_10794((class_2520)this.dimIntIdTag);
            buf.method_10794((class_2520)this.dimTypeTag);
        }

        public static DimIdSyncPacket read(class_2540 buf) {
            class_2487 idMapTag = buf.method_10798();
            class_2487 typeTag = buf.method_10798();
            return new DimIdSyncPacket(idMapTag, typeTag);
        }

        public PacketType<?> getType() {
            return TYPE;
        }

        public void handleOnNetworkingThread(class_2602 packetListener) {
            ImmutableMap dimTypeMap;
            DimIntIdMap rec = DimIntIdMap.fromTag(this.dimIntIdTag);
            LOGGER.info("Client received dim id sync packet\n{}", (Object)rec);
            DimensionIntId.clientRecord = rec;
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            for (String key : this.dimTypeTag.method_10541()) {
                class_5321 dimId = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(key));
                String dimTypeId = this.dimTypeTag.method_10558(key);
                class_5321 dimType = class_5321.method_29179((class_5321)class_7924.field_41241, (class_2960)new class_2960(dimTypeId));
                builder.put((Object)dimId, (Object)dimType);
            }
            ClientWorldLoader.dimIdToDimTypeId = dimTypeMap = builder.build();
            LOGGER.info("Client accepted dimension type mapping {}", (Object)dimTypeMap);
        }
    }
}

