/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util.dimension;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2520;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;
import qouteall.q_misc_util.Helper;

public class DimIntIdMap {
    public static final int MISSING_ID = Integer.MIN_VALUE;
    final Object2IntOpenHashMap<class_5321<class_1937>> toIntegerId;
    final Int2ObjectOpenHashMap<class_5321<class_1937>> fromIntegerId;
    private int maxId;

    public DimIntIdMap(Object2IntOpenHashMap<class_5321<class_1937>> toIntegerId, Int2ObjectOpenHashMap<class_5321<class_1937>> fromIntegerId) {
        this.toIntegerId = toIntegerId;
        this.fromIntegerId = fromIntegerId;
        toIntegerId.defaultReturnValue(Integer.MIN_VALUE);
        this.maxId = toIntegerId.values().intStream().max().orElse(0);
    }

    public DimIntIdMap() {
        this((Object2IntOpenHashMap<class_5321<class_1937>>)new Object2IntOpenHashMap(), (Int2ObjectOpenHashMap<class_5321<class_1937>>)new Int2ObjectOpenHashMap());
    }

    public class_5321<class_1937> fromIntegerId(int integerId) {
        class_5321 result = (class_5321)this.fromIntegerId.get(integerId);
        if (result == null) {
            throw new RuntimeException("Missing Dimension " + integerId);
        }
        return result;
    }

    @Nullable
    public class_5321<class_1937> fromIntegerIdNullable(int integerId) {
        return (class_5321)this.fromIntegerId.get(integerId);
    }

    public int toIntegerId(class_5321<class_1937> dim) {
        int result = this.toIntegerId.getInt(dim);
        if (result == Integer.MIN_VALUE) {
            throw new RuntimeException("Missing Dimension " + dim.method_29177());
        }
        return result;
    }

    public void add(class_5321<class_1937> dimId, int intId) {
        if (this.toIntegerId.containsKey(dimId)) {
            throw new RuntimeException("Dimension Id Record already contains " + dimId.method_29177() + " " + this);
        }
        if (this.fromIntegerId.containsKey(intId)) {
            throw new RuntimeException("Dimension Id Record already contains " + intId + " " + this);
        }
        this.toIntegerId.put(dimId, intId);
        this.fromIntegerId.put(intId, dimId);
        this.maxId = Math.max(this.maxId, intId);
    }

    public boolean remove(class_5321<class_1937> dimId) {
        int intId = this.toIntegerId.removeInt(dimId);
        if (intId == Integer.MIN_VALUE) {
            return false;
        }
        this.fromIntegerId.remove(intId);
        return true;
    }

    public boolean removeUnused(Set<class_5321<class_1937>> currentDimIds) {
        boolean changed = false;
        for (class_5321 dimId : this.toIntegerId.keySet()) {
            if (currentDimIds.contains(dimId)) continue;
            this.remove((class_5321<class_1937>)dimId);
            changed = true;
        }
        return changed;
    }

    public boolean containsDimId(class_5321<class_1937> dimId) {
        return this.toIntegerId.containsKey(dimId);
    }

    public boolean containsIntId(int intId) {
        return this.fromIntegerId.containsKey(intId);
    }

    public static DimIntIdMap fromTag(class_2487 tag) {
        class_2487 intids = tag.method_10562("intids");
        Object2IntOpenHashMap toIntegerId = new Object2IntOpenHashMap();
        Int2ObjectOpenHashMap fromIntegerId = new Int2ObjectOpenHashMap();
        intids.method_10541().forEach(dim -> {
            if (intids.method_10545(dim)) {
                int intid = intids.method_10550(dim);
                class_5321<class_1937> dimId = Helper.dimIdToKey(dim);
                toIntegerId.put(dimId, intid);
                fromIntegerId.put(intid, dimId);
            }
        });
        return new DimIntIdMap((Object2IntOpenHashMap<class_5321<class_1937>>)toIntegerId, (Int2ObjectOpenHashMap<class_5321<class_1937>>)fromIntegerId);
    }

    public class_2487 toTag(Predicate<class_5321<class_1937>> filter) {
        class_2487 intids = new class_2487();
        this.toIntegerId.forEach((key, intid) -> {
            if (filter.test((class_5321<class_1937>)key)) {
                intids.method_10566(key.method_29177().toString(), (class_2520)class_2497.method_23247((int)intid));
            }
        });
        class_2487 result = new class_2487();
        result.method_10566("intids", (class_2520)intids);
        return result;
    }

    public Set<class_5321<class_1937>> getDimIdSet() {
        return Collections.unmodifiableSet(this.toIntegerId.keySet());
    }

    public int getNextIntegerId() {
        return this.maxId + 1;
    }

    public String toString() {
        return this.toIntegerId.object2IntEntrySet().stream().sorted(Comparator.comparingInt(e -> e.getIntValue())).map(e -> ((class_5321)e.getKey()).method_29177().toString() + " -> " + e.getIntValue()).collect(Collectors.joining("\n"));
    }
}

