/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util.dimension;

import com.mojang.logging.LogUtils;
import java.util.HashSet;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.Event;
import net.minecraft.class_1937;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_8705;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import qouteall.dimlib.api.DimensionAPI;
import qouteall.imm_ptl.core.IPCGlobal;
import qouteall.imm_ptl.core.IPPerServerInfo;
import qouteall.q_misc_util.MiscNetworking;
import qouteall.q_misc_util.dimension.DimIntIdMap;

public class DimensionIntId {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final class_2960 DYNAMIC_UPDATE_EVENT_EARLY_PHASE = new class_2960("iportal:early_phase");
    public static DimIntIdMap clientRecord;

    public static void init() {
        DimensionAPI.SERVER_DIMENSION_DYNAMIC_UPDATE_EVENT.addPhaseOrdering(DYNAMIC_UPDATE_EVENT_EARLY_PHASE, Event.DEFAULT_PHASE);
        DimensionAPI.SERVER_DIMENSION_DYNAMIC_UPDATE_EVENT.register(DYNAMIC_UPDATE_EVENT_EARLY_PHASE, (server, dimensions) -> DimensionIntId.onServerDimensionChanged(server));
    }

    @Environment(value=EnvType.CLIENT)
    public static void initClient() {
        IPCGlobal.CLIENT_EXIT_EVENT.register(DimensionIntId::onClientExit);
    }

    @Environment(value=EnvType.CLIENT)
    private static void onClientExit() {
        clientRecord = null;
    }

    @Environment(value=EnvType.CLIENT)
    @NotNull
    public static DimIntIdMap getClientMap() {
        Validate.notNull((Object)clientRecord, (String)"Client dim id record is not yet synced", (Object[])new Object[0]);
        return clientRecord;
    }

    @NotNull
    public static DimIntIdMap getServerMap(MinecraftServer server) {
        IPPerServerInfo perServerInfo = IPPerServerInfo.of(server);
        DimIntIdMap rec = perServerInfo.dimIntIdMap;
        Validate.notNull((Object)rec, (String)"Server dim id record is not yet initialized", (Object[])new Object[0]);
        return rec;
    }

    public static void onServerStarted(MinecraftServer server) {
        DimIntIdMap rec = new DimIntIdMap();
        DimensionIntId.fillInVanillaDimIds(rec);
        for (class_3218 world : server.method_3738()) {
            class_5321 dimId = world.method_27983();
            if (rec.containsDimId((class_5321<class_1937>)dimId)) continue;
            rec.add((class_5321<class_1937>)dimId, rec.getNextIntegerId());
        }
        IPPerServerInfo perServerInfo = IPPerServerInfo.of(server);
        perServerInfo.dimIntIdMap = rec;
        LOGGER.info("Server dimension integer id mapping:\n{}", (Object)rec);
    }

    private static void fillInVanillaDimIds(DimIntIdMap rec) {
        if (!rec.containsDimId((class_5321<class_1937>)class_1937.field_25179)) {
            rec.add((class_5321<class_1937>)class_1937.field_25179, 0);
        }
        if (!rec.containsDimId((class_5321<class_1937>)class_1937.field_25180)) {
            rec.add((class_5321<class_1937>)class_1937.field_25180, -1);
        }
        if (!rec.containsDimId((class_5321<class_1937>)class_1937.field_25181)) {
            rec.add((class_5321<class_1937>)class_1937.field_25181, 1);
        }
    }

    public static void onServerDimensionChanged(MinecraftServer server) {
        DimIntIdMap map = DimensionIntId.getServerMap(server);
        for (class_5321 levelKey : server.method_29435()) {
            if (map.containsDimId((class_5321<class_1937>)levelKey)) continue;
            map.add((class_5321<class_1937>)levelKey, map.getNextIntegerId());
        }
        HashSet<class_5321<class_1937>> usedDimKeys = new HashSet<class_5321<class_1937>>(server.method_29435());
        usedDimKeys.add(class_1937.field_25179);
        usedDimKeys.add(class_1937.field_25180);
        usedDimKeys.add(class_1937.field_25181);
        map.removeUnused(usedDimKeys);
        LOGGER.info("Current dimension integer id mapping:\n{}", (Object)map);
        class_2596<class_8705> packet = MiscNetworking.DimIdSyncPacket.createPacket(server);
        for (class_3222 player : server.method_3760().method_14571()) {
            player.field_13987.method_14364(packet);
        }
    }
}

