/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util.my_util;

import net.minecraft.class_243;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record Plane(class_243 pos, class_243 normal) {
    public Plane(class_243 pos, class_243 normal) {
        this.pos = pos;
        this.normal = normal.method_1029();
    }

    public double getDistanceTo(class_243 point) {
        return this.normal.method_1026(point.method_1020(this.pos));
    }

    public double getDistanceTo(double x, double y, double z) {
        return this.normal.method_10216() * (x - this.pos.method_10216()) + this.normal.method_10214() * (y - this.pos.method_10214()) + this.normal.method_10215() * (z - this.pos.method_10215());
    }

    @NotNull
    public class_243 getProjection(class_243 point) {
        return point.method_1020(this.normal.method_1021(this.getDistanceTo(point)));
    }

    public class_243 getReflection(class_243 point) {
        return point.method_1020(this.normal.method_1021(2.0 * this.getDistanceTo(point)));
    }

    public boolean isPointOnPositiveSide(class_243 point) {
        return this.getDistanceTo(point) > 0.0;
    }

    public Plane move(double distance) {
        return new Plane(this.pos.method_1019(this.normal.method_1021(distance)), this.normal);
    }

    public Plane getOpposite() {
        return new Plane(this.pos, this.normal.method_1021(-1.0));
    }

    @Nullable
    public class_243 rayTrace(class_243 origin, class_243 vec) {
        double t = this.rayTraceGetT(origin, vec);
        if (Double.isNaN(t)) {
            return null;
        }
        if (t < 0.0) {
            return null;
        }
        return origin.method_1019(vec.method_1021(t));
    }

    public double rayTraceGetT(class_243 lineOrigin, class_243 lineVec) {
        double lineVecProjectToNormal = this.normal.method_1026(lineVec);
        if (Math.abs(lineVecProjectToNormal) < 1.0E-5) {
            return Double.NaN;
        }
        return -this.getDistanceTo(lineOrigin) / lineVecProjectToNormal;
    }

    public double rayTraceGetT(double lineOriginX, double lineOriginY, double lineOriginZ, double lineVecX, double lineVecY, double lineVecZ) {
        double lineVecProjectToNormal = this.normal.method_10216() * lineVecX + this.normal.method_10214() * lineVecY + this.normal.method_10215() * lineVecZ;
        if (Math.abs(lineVecProjectToNormal) < 1.0E-5) {
            return Double.NaN;
        }
        return -this.getDistanceTo(lineOriginX, lineOriginY, lineOriginZ) / lineVecProjectToNormal;
    }

    @Nullable
    public class_243 intersectionWithLineSegment(class_243 lineP1, class_243 lineP2) {
        class_243 lineVec = lineP2.method_1020(lineP1);
        double t = this.rayTraceGetT(lineP1, lineVec);
        if (Double.isNaN(t)) {
            return null;
        }
        if (t < 0.0 || t > 1.0) {
            return null;
        }
        return lineP1.method_1019(lineVec.method_1021(t));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Plane plane = (Plane)o;
        return this.pos.equals((Object)plane.pos) && this.normal.equals((Object)plane.normal);
    }

    @Override
    public String toString() {
        return "Plane{pos=" + this.pos + ", normal=" + this.normal + "}";
    }

    public static Plane interpolate(Plane a, Plane b, double progress) {
        class_243 pos = a.pos.method_35590(b.pos, progress);
        class_243 normal = a.normal.method_35590(b.normal, progress).method_1029();
        return new Plane(pos, normal);
    }

    public Plane getParallelPlane(class_243 pos) {
        return new Plane(pos, this.normal);
    }

    public double getEquationX() {
        return this.normal.method_10216();
    }

    public double getEquationY() {
        return this.normal.method_10214();
    }

    public double getEquationZ() {
        return this.normal.method_10215();
    }

    public double getEquationW() {
        return -this.normal.method_1026(this.pos);
    }
}

